/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLong;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProvider;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapter;
import org.eclipse.stem.definitions.adapters.spatial.geo.LatLongProviderAdapterFactory;
import org.eclipse.stem.definitions.edges.PopulationEdge;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.geography.centers.GeographicCenters;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.populationmodels.standard.PopulationModelLabel;
import org.eclipse.stem.ui.Activator;
import org.eclipse.stem.ui.adapters.color.ColorProvider;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapterFactory;
import org.eclipse.stem.ui.adapters.color.IColorProviderChangedListener;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.MapRenderer;
import org.eclipse.stem.ui.views.geographic.map.Messages;
import org.eclipse.stem.ui.views.geographic.map.StemPolygon;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.stem.ui.widgets.GeoViewOptionsBar;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;

public abstract class GeographicControl
extends Composite
implements ISimulationListener,
ISelectionProvider,
IColorProviderChangedListener,
IPropertyChangeListener,
ISelectionChangedListener,
GeoViewOptionsBar.PropertySelectionListener {
    public boolean expansionState = true;
    protected static final int MARGIN_WIDTH = 5;
    protected static final int MARGIN_HEIGHT = 5;
    private ISimulation simulation = null;
    ISelection selection = null;
    protected final List<ISelectionChangedListener> listeners = new CopyOnWriteArrayList<ISelectionChangedListener>();
    protected GeographicRenderer geographicRenderer;
    protected String selectedEdge = "";
    boolean refreshPending = false;
    Job refreshJob;
    protected ColorProviderAdapter colorProviderAdapter = null;
    private Label simulationNameLabel;
    private GeoViewOptionsBar optionsBar;
    protected final Map<Decorator, DecoratorDisplayData> decoratorToDecoratorDisplayDataMap = new HashMap<Decorator, DecoratorDisplayData>();
    private final Map<LatLong, StemPolygonsList> polygonListMap = new HashMap<LatLong, StemPolygonsList>();
    private static final IPath WORKSPACE_PATH = ResourcesPlugin.getWorkspace().getRoot().getLocation();
    private static final String scenariosURLPrefix = "platform:/resource/";
    private static final String builtInScenarioProjectFolder = "BuiltInScenarios";
    private static final String recordedSimulationsFolderName = "RecordedMapImages";
    private static final SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyyMMddHHmmss", Locale.getDefault());

    public GeographicControl(Composite parent, int style) {
        super(parent, style);
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        this.setPreferences();
        this.createContextMenu(this);
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
        this.geographicRenderer = this.createGeographicRenderer();
        this.geographicRenderer.setColorProviderAdapter(this.colorProviderAdapter);
        this.geographicRenderer.addSelectionChangedListener(this);
        Composite topComposite = this.createTopComposite(this);
        Composite bottomComposite = this.createBottomComposite(this);
        FormData topCompositeFormData = new FormData();
        topComposite.setLayoutData((Object)topCompositeFormData);
        topCompositeFormData.top = new FormAttachment(0, 0);
        topCompositeFormData.left = new FormAttachment(0, 0);
        topCompositeFormData.right = new FormAttachment(100, 0);
        FormData geoRendererFormData = new FormData();
        this.geographicRenderer.setLayoutData(geoRendererFormData);
        geoRendererFormData.top = new FormAttachment((Control)topComposite, 0);
        geoRendererFormData.bottom = new FormAttachment((Control)bottomComposite, 0);
        geoRendererFormData.left = new FormAttachment(0, 0);
        geoRendererFormData.right = new FormAttachment(100, 0);
        FormData bottomCompositeFormData = new FormData();
        bottomComposite.setLayoutData((Object)bottomCompositeFormData);
        bottomCompositeFormData.bottom = new FormAttachment(100, 0);
        bottomCompositeFormData.left = new FormAttachment(0, 0);
        bottomCompositeFormData.right = new FormAttachment(100, 0);
        this.pack();
    }

    protected abstract GeographicRenderer createGeographicRenderer();

    protected void setPreferences() {
    }

    public final ISimulation getSimulation() {
        return this.simulation;
    }

    public final void setSimulation(ISimulation simulation) {
        if (this.simulation == simulation) {
            return;
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.simulation = simulation;
        this.selection = null;
        if (this.simulation != null) {
            this.simulation.addSimulationListener((ISimulationListener)this);
            this.initializeFromSimulation(this.simulation);
        }
        this.refresh();
    }

    protected void initializeFromSimulation(ISimulation simulation) {
        this.simulationNameLabel.setText(simulation.getName());
        this.optionsBar.setSimulation(simulation);
    }

    void refresh() {
        if (!this.refreshPending) {
            if (this.refreshJob == null) {
                this.refreshJob = new Job(Messages.getString("IMView.MRefresh")){

                    protected IStatus run(IProgressMonitor monitor) {
                        final StemPolygonsList polygonsToDraw = GeographicControl.this.createPolygonsToDraw(monitor);
                        if (polygonsToDraw == null) {
                            return Status.OK_STATUS;
                        }
                        Display display = Display.getDefault();
                        if (!display.isDisposed()) {
                            try {
                                display.asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!(this).GeographicControl.this.geographicRenderer.isDisposed()) {
                                            (this).GeographicControl.this.geographicRenderer.render(polygonsToDraw, (this).GeographicControl.this.simulation);
                                            (this).GeographicControl.this.refreshJob = null;
                                            if ((this).GeographicControl.this.refreshPending) {
                                                (this).GeographicControl.this.refreshPending = false;
                                                Display display2 = Display.getDefault();
                                                if (!display2.isDisposed()) {
                                                    display2.asyncExec(new Runnable(){

                                                        @Override
                                                        public void run() {
                                                            GeographicControl.this.refresh();
                                                        }
                                                    });
                                                }
                                            }
                                        }
                                    }
                                });
                            }
                            catch (NullPointerException nullPointerException) {
                                // empty catch block
                            }
                        }
                        monitor.done();
                        return Status.OK_STATUS;
                    }
                };
                this.refreshPending = false;
                this.refreshJob.schedule();
            } else {
                this.refreshPending = true;
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
        this.optionsBar.removeColorProviderChangedListener(this);
        this.optionsBar.removePropertySelectionListener(this);
        this.geographicRenderer.removeSelectionChangedListener(this);
        assert (this.listeners.size() == 0);
        Activator.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    private void createContextMenu(Composite parent) {
        MenuManager contextMenuManager = new MenuManager();
        contextMenuManager.add((IAction)new ResetRenderer());
        contextMenuManager.add((IContributionItem)new Separator("additions"));
        Menu popUpMenu = contextMenuManager.createContextMenu((Control)parent);
        parent.setMenu(popUpMenu);
    }

    public void propertyChange(PropertyChangeEvent event) {
        this.setPreferences();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelection(event.getSelection());
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public final ISelection getSelection() {
        return this.selection;
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        this.fireSelection(selection);
    }

    public void fireSelection(ISelection selection) {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(event);
        }
    }

    protected Composite createBottomComposite(Composite parent) {
        this.optionsBar = new GeoViewOptionsBar(parent, 0);
        this.optionsBar.addColorProviderChangedListener(this);
        this.optionsBar.addPropertySelectionListener(this);
        return this.optionsBar;
    }

    @Override
    public void propertySelected(GeoViewOptionsBar.PropertySelectionEvent propertySelectionEvent) {
        if (propertySelectionEvent == null) {
            this.selectedEdge = "";
        } else if (propertySelectionEvent.getSource() instanceof String) {
            this.selectedEdge = (String)propertySelectionEvent.getSource();
        }
        this.refresh();
    }

    protected Composite createTopComposite(Composite parent) {
        Composite topComposite = new Composite(parent, 0);
        FillLayout topCompositeLayout = new FillLayout(256);
        topComposite.setLayout((Layout)topCompositeLayout);
        this.simulationNameLabel = new Label(topComposite, 16384);
        this.simulationNameLabel.setText("");
        this.geographicRenderer.gainScaleLabel = new Label(topComposite, 131072);
        this.geographicRenderer.updateScaleLogLinLabel();
        return topComposite;
    }

    public void simulationChanged(SimulationEvent event) {
        switch (event.getSimulationState()) {
            case COMPLETED_CYCLE: {
                if (!this.optionsBar.isInitialized()) {
                    this.optionsBar.setSimulation(this.getSimulation());
                }
                this.refresh();
                break;
            }
            case RESET: {
                this.refresh();
                break;
            }
        }
    }

    protected DecoratorDisplayData getDecoratorDisplayData(Decorator decorator, IProgressMonitor monitor) {
        DecoratorDisplayData retValue = this.decoratorToDecoratorDisplayDataMap.get(decorator);
        if (retValue == null) {
            retValue = new DecoratorDisplayData();
            this.decoratorToDecoratorDisplayDataMap.put(decorator, retValue);
            if (decorator.getLabelsToUpdate() == null || decorator.getLabelsToUpdate().isEmpty()) {
                return retValue;
            }
            DynamicNodeLabel firstNodeLabel = (DynamicNodeLabel)decorator.getLabelsToUpdate().get(0);
            if (firstNodeLabel != null) {
                RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)firstNodeLabel, RelativeValueProvider.class);
                if (rvp == null) {
                    return null;
                }
                retValue.setRelativeValueProviderAdapter(rvp);
            }
            for (Object element : decorator.getLabelsToUpdate()) {
                DynamicNodeLabel nodeLabel = (DynamicNodeLabel)element;
                retValue.addLabel(nodeLabel);
            }
        }
        if (!retValue.hasAllLatLong()) {
            monitor.subTask(decorator.getDublinCore().getTitle());
            retValue.updateLatLong(monitor);
        }
        return retValue;
    }

    protected StemPolygonsList createPolygonsToDraw(IProgressMonitor monitor) {
        return this.createPolygonsToDraw(this.optionsBar.getSelectedDecorator(), this.optionsBar.getSelectedPopulationIdentifier(), monitor);
    }

    StemPolygonsList createPolygonsToDraw(Decorator selectedDecorator, String selectedPopulationIdentifier, IProgressMonitor monitor) {
        StemPolygonsList retValue = new StemPolygonsList();
        if (selectedDecorator != null) {
            DecoratorDisplayData displayData = this.getDecoratorDisplayData(selectedDecorator, monitor);
            if (displayData == null) {
                return null;
            }
            RelativeValueProviderAdapter rvp = displayData.getRelativeValueProviderAdapter();
            if (rvp == null) {
                return null;
            }
            monitor.beginTask(selectedDecorator.getDublinCore().getTitle(), displayData.getLabelData().size());
            for (DecoratorDisplayData.LabelData labelData : displayData.getLabelData()) {
                DynamicNodeLabel lab = labelData.getLabel();
                if (lab instanceof DiseaseModelLabel && !((DiseaseModelLabel)lab).getPopulationModelLabel().getPopulationIdentifier().equals(selectedPopulationIdentifier) || lab instanceof PopulationModelLabel && !((PopulationModelLabel)lab).getPopulationIdentifier().equals(selectedPopulationIdentifier)) continue;
                Identifiable identifiable = labelData.getLabel().getIdentifiable();
                monitor.subTask(identifiable.getDublinCore().getTitle());
                LatLong latLong = labelData.getLatLongData();
                if (latLong != null && latLong.size() > 0) {
                    StemPolygonsList stemPolygonsList = this.getStemPolygonsList(latLong, identifiable, rvp, labelData);
                    retValue.addAll(stemPolygonsList);
                }
                monitor.worked(1);
            }
            if (this.selectedEdge != null && !this.selectedEdge.equals("")) {
                LinkedList<URI> edgeTypes = new LinkedList<URI>();
                Graph graph = selectedDecorator.getGraph();
                EMap allEdges = graph.getEdges();
                Iterator iter = allEdges.keySet().iterator();
                ArrayList<Edge> edges = new ArrayList<Edge>();
                while (iter.hasNext()) {
                    URI uri = (URI)iter.next();
                    if (edgeTypes.contains(uri)) {
                        edgeTypes.add(uri);
                    }
                    if (!uri.toString().startsWith(this.selectedEdge)) continue;
                    Edge edge = (Edge)allEdges.get((Object)uri);
                    if (edge instanceof PopulationEdge) {
                        String popID = ((PopulationEdge)edge).getPopulationIdentifier();
                        if (!selectedPopulationIdentifier.equals(popID)) continue;
                        edges.add(edge);
                        continue;
                    }
                    edges.add(edge);
                }
                if (!edges.isEmpty()) {
                    Iterator edgesIter = edges.iterator();
                    ArrayList<URI> addedEdges = new ArrayList<URI>();
                    while (edgesIter.hasNext()) {
                        String nodeBISOKey;
                        double[] centerB;
                        Edge nextEdge = (Edge)edgesIter.next();
                        Node nodeA = nextEdge.getA();
                        Node nodeB = nextEdge.getB();
                        if (nodeA == null || nodeB == null) continue;
                        String nodeAISOKey = nodeA.getURI().lastSegment();
                        double[] centerA = GeographicCenters.getCenter((String)nodeAISOKey);
                        if (centerA == null) {
                            LatLongProviderAdapter latLongProviderA = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeA, LatLongProvider.class);
                            centerA = latLongProviderA.getCenter();
                        }
                        if ((centerB = GeographicCenters.getCenter((String)(nodeBISOKey = nodeB.getURI().lastSegment()))) == null) {
                            LatLongProviderAdapter latLongProviderB = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeB, LatLongProvider.class);
                            centerB = latLongProviderB.getCenter();
                        }
                        if (centerA == null || centerB == null) continue;
                        double[][] data = new double[2][2];
                        data[0][0] = centerA[0];
                        data[0][1] = centerA[1];
                        data[1][0] = centerB[0];
                        data[1][1] = centerB[1];
                        if (addedEdges.contains(nextEdge.getURI())) continue;
                        LatLong.Segment edgeSegment = new LatLong.Segment(data);
                        StemPolygon stemPolygon = new StemPolygon(edgeSegment, (Identifiable)nextEdge);
                        retValue.add(stemPolygon);
                        addedEdges.add(nextEdge.getURI());
                    }
                }
            }
        }
        return retValue;
    }

    private StemPolygonsList getStemPolygonsList(LatLong latLong, Identifiable identifiable, RelativeValueProviderAdapter rvp, DecoratorDisplayData.LabelData labelData) {
        StemPolygonsList retValue = this.polygonListMap.get(latLong);
        rvp.setTarget((Notifier)labelData.getLabel());
        if (retValue == null) {
            retValue = new StemPolygonsList(latLong, identifiable);
            this.polygonListMap.put(latLong, retValue);
        }
        return retValue;
    }

    public GeographicRenderer getGeographicRenderer() {
        return this.geographicRenderer;
    }

    @Override
    public void colorProviderChanged(Class<? extends ColorProvider> selectedColorProvider) {
        Decorator decorator = this.optionsBar.getSelectedDecorator();
        if (decorator == null) {
            return;
        }
        AdapterFactory adapterFactory = ColorProviderAdapterFactory.INSTANCE.getFactoryForType(selectedColorProvider);
        Adapter adapter = adapterFactory.adapt((Notifier)decorator.getGraph(), selectedColorProvider);
        if (adapter instanceof ColorProviderAdapter) {
            this.colorProviderAdapter = (ColorProviderAdapter)adapter;
            this.colorProviderAdapter.setSelectedDecorator(this.optionsBar.getSelectedDecorator());
            this.colorProviderAdapter.setSelectedPopulationIdentifier(this.optionsBar.getSelectedPopulationIdentifier());
            this.geographicRenderer.setColorProviderAdapter(this.colorProviderAdapter);
            this.layout();
        }
    }

    private static File getImageFileToLog(ISimulation sim) {
        IPath path1;
        String scenarioURL = sim.getScenario().getURI().toString();
        boolean builtInScenario = scenarioURL.startsWith(scenariosURLPrefix);
        if (builtInScenario) {
            String scenarioRelativePath = scenarioURL.substring(scenariosURLPrefix.length());
            path1 = WORKSPACE_PATH.append(scenarioRelativePath).removeLastSegments(2);
        } else {
            path1 = WORKSPACE_PATH.append(builtInScenarioProjectFolder);
        }
        String path = path1.append(recordedSimulationsFolderName).append(sim.getUniqueIDString()).append(String.valueOf(DATE_FORMATTER.format(sim.getScenario().getSequencer().getCurrentTime().getTime())) + ".png").toOSString();
        File f = new File(path);
        f.getParentFile().mkdirs();
        return f;
    }

    public Image getMapCanvasImage() {
        if (this.geographicRenderer instanceof MapRenderer) {
            return ((MapRenderer)this.geographicRenderer).getCanvas().getCanvasImage();
        }
        return null;
    }

    private void saveCanvasImage(ISimulation sim) {
        if (this.geographicRenderer instanceof MapRenderer) {
            try {
                ((MapRenderer)this.geographicRenderer).getCanvas().saveCanvasImage(GeographicControl.getImageFileToLog(sim));
            }
            catch (IOException ioe) {
                Activator.logInformation("Error saving map canvas image", ioe);
            }
        }
    }

    protected static class DecoratorDisplayData {
        private RelativeValueProviderAdapter rvp;
        private final List<LabelData> labelDatas = new ArrayList<LabelData>();
        private final List<LabelData> labelsWithUnresolvedLatLong = new ArrayList<LabelData>();

        public boolean hasAllLatLong() {
            return this.labelsWithUnresolvedLatLong.size() == 0;
        }

        public List<LabelData> getLabelData() {
            return this.labelDatas;
        }

        public RelativeValueProviderAdapter getRelativeValueProviderAdapter() {
            return this.rvp;
        }

        void updateLatLong(IProgressMonitor monitor) {
            Iterator<LabelData> iter = this.labelsWithUnresolvedLatLong.iterator();
            while (iter.hasNext()) {
                LabelData ld = iter.next();
                LatLongProviderAdapter latLongProvider = (LatLongProviderAdapter)LatLongProviderAdapterFactory.INSTANCE.adapt((Notifier)ld.getLabel().getNode(), LatLongProvider.class);
                ld.setLatLongData(latLongProvider.getLatLongNoWait());
                LatLong data = ld.getLatLongData();
                if (data == null || data.size() == 0) continue;
                iter.remove();
            }
        }

        public void addLabel(DynamicNodeLabel label) {
            LabelData ld = new LabelData(label);
            this.labelDatas.add(ld);
            this.labelsWithUnresolvedLatLong.add(ld);
        }

        public void setRelativeValueProviderAdapter(RelativeValueProviderAdapter rvp) {
            this.rvp = rvp;
        }

        public static class LabelData {
            private final DynamicNodeLabel label;
            private LatLong latLongData;

            public LabelData(DynamicNodeLabel label) {
                this.label = label;
            }

            public DynamicNodeLabel getLabel() {
                return this.label;
            }

            public LatLong getLatLongData() {
                return this.latLongData;
            }

            public void setLatLongData(LatLong latLongData) {
                this.latLongData = latLongData;
            }
        }
    }

    protected class ResetRenderer
    extends Action {
        protected ResetRenderer() {
        }

        public String getText() {
            return Messages.getString("MapMenu.Reset");
        }

        public void run() {
            GeographicControl.this.geographicRenderer.reset();
            GeographicControl.this.geographicRenderer.redraw();
        }
    }
}

