/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.diseasemodels.standard.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.stem.core.STEMObjectPool;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.Edge;
import org.eclipse.stem.core.graph.EdgeLabel;
import org.eclipse.stem.core.graph.Exchange;
import org.eclipse.stem.core.graph.ExchangeType;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.IntegrationLabel;
import org.eclipse.stem.core.graph.IntegrationLabelValue;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.math.BinomialDistributionUtil;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.core.scenario.ScenarioInitializationException;
import org.eclipse.stem.definitions.edges.MixingEdge;
import org.eclipse.stem.definitions.edges.MixingEdgeLabelValue;
import org.eclipse.stem.definitions.edges.impl.MixingEdgeLabelImpl;
import org.eclipse.stem.definitions.labels.AreaLabel;
import org.eclipse.stem.definitions.labels.CommonBorderRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.PopulationLabel;
import org.eclipse.stem.definitions.labels.RoadTransportRelationshipLabelValue;
import org.eclipse.stem.definitions.labels.impl.CommonBorderRelationshipLabelImpl;
import org.eclipse.stem.definitions.labels.impl.RoadTransportRelationshipLabelImpl;
import org.eclipse.stem.definitions.nodes.Region;
import org.eclipse.stem.diseasemodels.Activator;
import org.eclipse.stem.diseasemodels.standard.SEIRLabelValue;
import org.eclipse.stem.diseasemodels.standard.SILabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabel;
import org.eclipse.stem.diseasemodels.standard.StandardDiseaseModelLabelValue;
import org.eclipse.stem.diseasemodels.standard.StandardPackage;
import org.eclipse.stem.diseasemodels.standard.impl.DiseaseModelImpl;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;

public abstract class StandardDiseaseModelImpl
extends DiseaseModelImpl
implements StandardDiseaseModel {
    protected static final double REFERENCE_POPULATION_DENSITY_EDEFAULT = 100.0;
    protected double referencePopulationDensity = 100.0;
    protected static final double ROAD_NETWORK_INFECTIOUS_PROPORTION_EDEFAULT = 0.01;
    protected double roadNetworkInfectiousProportion = 0.01;
    protected static final double CHARACTERISTIC_MIXING_DISTANCE_EDEFAULT = 2.25;
    protected double characteristicMixingDistance = 2.25;
    protected HashMap<String, STEMObjectPool> labelValueObjectPools = new HashMap();
    protected STEMObjectPool edgeListObjectPool = new STEMObjectPool(5, 5){

        protected Object createNewObject() {
            return new ArrayList();
        }

        protected void resetObject(Object o) {
        }
    };
    protected boolean doCommonBorderMixing = true;
    private boolean mixingStrategyDetermined = false;

    protected StandardDiseaseModelImpl() {
    }

    @Override
    protected EClass eStaticClass() {
        return StandardPackage.Literals.STANDARD_DISEASE_MODEL;
    }

    @Override
    public double getReferencePopulationDensity() {
        return this.referencePopulationDensity;
    }

    @Override
    public void setReferencePopulationDensity(double newReferencePopulationDensity) {
        this.referencePopulationDensity = newReferencePopulationDensity;
    }

    @Override
    public double getRoadNetworkInfectiousProportion() {
        return this.roadNetworkInfectiousProportion;
    }

    @Override
    public void setRoadNetworkInfectiousProportion(double newRoadNetworkInfectiousProportion) {
        this.roadNetworkInfectiousProportion = newRoadNetworkInfectiousProportion;
    }

    @Override
    public double getCharacteristicMixingDistance() {
        return this.characteristicMixingDistance;
    }

    @Override
    public void setCharacteristicMixingDistance(double newCharacteristicMixingDistance) {
        this.characteristicMixingDistance = newCharacteristicMixingDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyExternalDeltas(STEMTime time, double t, long timeDelta, EList<DynamicLabel> labels) {
        StandardDiseaseModelImpl standardDiseaseModelImpl = this;
        synchronized (standardDiseaseModelImpl) {
            if (this.labelValueObjectPools.size() == 0) {
                for (final String pop : this.getAllLabelIdentifiers()) {
                    this.labelValueObjectPools.put(pop, new STEMObjectPool(5, 5){

                        protected Object createNewObject() {
                            return StandardDiseaseModelImpl.this.createDiseaseModelLabelValue(pop);
                        }

                        protected void resetObject(Object o) {
                        }
                    });
                }
            }
        }
        int i = 0;
        while (i < labels.size()) {
            StandardDiseaseModelLabel diseaseLabel = (StandardDiseaseModelLabel)labels.get(i);
            StandardDiseaseModelLabelValue myDelta = (StandardDiseaseModelLabelValue)diseaseLabel.getDeltaValue();
            Node n = diseaseLabel.getNode();
            EList labs = n.getLabels();
            int j = 0;
            while (j < labs.size()) {
                block27: {
                    Exchange entry;
                    EList departures;
                    EList arrivals;
                    block28: {
                        NodeLabel l = (NodeLabel)labs.get(j);
                        if (!(l instanceof IntegrationLabel) || l.equals(diseaseLabel) || !((IntegrationLabel)l).getIdentifier().equals(diseaseLabel.getIdentifier())) break block27;
                        IntegrationLabelValue sdeLabelValue = ((IntegrationLabel)l).getDeltaValue();
                        arrivals = sdeLabelValue.getArrivals();
                        departures = sdeLabelValue.getDepartures();
                        if (arrivals != null && departures != null) break block28;
                        Activator.logError("Error, null arrivals or departures for label " + l, new Exception());
                        break block27;
                    }
                    int k = 0;
                    while (k < arrivals.size()) {
                        entry = (Exchange)arrivals.get(k);
                        if (entry.getType() == ExchangeType.BIRTHS_AND_DEATHS) {
                            EAttribute birthsCompartment = this.getBirthsCompartment();
                            myDelta.eSet((EStructuralFeature)birthsCompartment, (Double)myDelta.eGet((EStructuralFeature)birthsCompartment) + entry.getCount());
                            entry.setTarget(birthsCompartment);
                            entry.getOtherLabels().add((Object)diseaseLabel);
                        } else if (entry.getType() == ExchangeType.MIGRATION) {
                            double inflow = entry.getCount();
                            Node otherNode = (Node)((Label)entry.getOtherLabels().get(0)).getIdentifiable();
                            int m = 0;
                            while (m < otherNode.getLabels().size()) {
                                NodeLabel nl = (NodeLabel)otherNode.getLabels().get(m);
                                if (nl instanceof StandardDiseaseModelLabel && ((StandardDiseaseModelLabel)nl).getDecorator().equals(this) && ((StandardDiseaseModelLabel)nl).getPopulationModelLabel().getPopulationIdentifier().equals(diseaseLabel.getIdentifier())) {
                                    String pop = diseaseLabel.getIdentifier();
                                    StandardDiseaseModelLabelValue value = (StandardDiseaseModelLabelValue)this.labelValueObjectPools.get(pop).get();
                                    value.set(((StandardDiseaseModelLabel)nl).getTempValue());
                                    double factor = inflow / value.getPopulationCount();
                                    if (!Double.isInfinite(factor) && !Double.isNaN(factor)) {
                                        value.scale(factor);
                                    }
                                    double diseaseDeaths = myDelta.getDiseaseDeaths();
                                    myDelta.add(value);
                                    myDelta.setDiseaseDeaths(diseaseDeaths);
                                    entry.getOtherLabels().add((Object)nl);
                                    entry.getOtherLabels().add((Object)diseaseLabel);
                                    this.labelValueObjectPools.get(pop).release((Object)value);
                                }
                                ++m;
                            }
                        } else if (entry.getType() == ExchangeType.AGING) {
                            String otherAgeGroup = ((StandardPopulationModelLabel)entry.getOtherLabels().get(0)).getPopulationIdentifier();
                            int m = 0;
                            while (m < labs.size()) {
                                StandardDiseaseModelLabel otherDiseaseLabel;
                                NodeLabel nl = (NodeLabel)labs.get(m);
                                if (nl instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)nl).getDecorator().equals(this) && otherDiseaseLabel.getIdentifier().equals(otherAgeGroup)) {
                                    String pop = otherDiseaseLabel.getIdentifier();
                                    StandardDiseaseModelLabelValue value = (StandardDiseaseModelLabelValue)this.labelValueObjectPools.get(pop).get();
                                    value.set(((StandardDiseaseModelLabel)nl).getTempValue());
                                    if (value.getPopulationCount() > 0.0) {
                                        value.scale(entry.getCount() / value.getPopulationCount());
                                    }
                                    double diseaseDeaths = myDelta.getDiseaseDeaths();
                                    myDelta.add(value);
                                    myDelta.setDiseaseDeaths(diseaseDeaths);
                                    entry.getOtherLabels().add((Object)nl);
                                    entry.getOtherLabels().add((Object)diseaseLabel);
                                    this.labelValueObjectPools.get(pop).release((Object)value);
                                }
                                ++m;
                            }
                        }
                        ++k;
                    }
                    k = 0;
                    while (k < departures.size()) {
                        block32: {
                            StandardDiseaseModelLabelValue currentState;
                            String pop;
                            block30: {
                                block31: {
                                    block29: {
                                        entry = (Exchange)departures.get(k);
                                        pop = diseaseLabel.getIdentifier();
                                        currentState = null;
                                        if (entry.getType() != ExchangeType.BIRTHS_AND_DEATHS && entry.getType() != ExchangeType.AGING) break block29;
                                        currentState = (StandardDiseaseModelLabelValue)this.labelValueObjectPools.get(pop).get();
                                        currentState.set(diseaseLabel.getProbeValue());
                                        break block30;
                                    }
                                    if (entry.getType() != ExchangeType.MIGRATION) break block31;
                                    currentState = (StandardDiseaseModelLabelValue)this.labelValueObjectPools.get(pop).get();
                                    currentState.set(diseaseLabel.getTempValue());
                                    break block30;
                                }
                                if (entry.getType() == ExchangeType.COMPARTMENT_TRANSITION) break block32;
                            }
                            if (entry.getType() == ExchangeType.BIRTHS_AND_DEATHS) {
                                this.doDeaths(currentState, myDelta, entry.getCount());
                                entry.getOtherLabels().add((Object)diseaseLabel);
                                this.labelValueObjectPools.get(pop).release((Object)currentState);
                            } else {
                                double populationCount = currentState.getPopulationCount();
                                double outflow = entry.getCount();
                                double factor = outflow / populationCount;
                                if (Double.isNaN(factor) || Double.isInfinite(factor)) {
                                    factor = 0.0;
                                }
                                currentState.scale(factor);
                                double diseaseDeaths = myDelta.getDiseaseDeaths();
                                myDelta.sub(currentState);
                                myDelta.setDiseaseDeaths(diseaseDeaths);
                                this.labelValueObjectPools.get(pop).release((Object)currentState);
                            }
                        }
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public void doStochasticProcess(IntegrationLabel iLabel, long timeDelta) {
        if (this.getBinomialDistribution() == null) {
            this.setBinomialDistribution(new BinomialDistributionUtil(this.getRandomSeed()));
        }
        if (iLabel.getNextValue() instanceof SEIRLabelValue) {
            SEIRLabelValue nextSEIR = (SEIRLabelValue)iLabel.getNextValue();
            SEIRLabelValue previousSEIR = (SEIRLabelValue)iLabel.getCurrentValue();
            this.addNoise(previousSEIR, nextSEIR, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), StandardPackage.eINSTANCE.getSEIRLabelValue_E(), 1.0);
        } else if (iLabel.getNextValue() instanceof SILabelValue) {
            SILabelValue nextSI = (SILabelValue)iLabel.getNextValue();
            SILabelValue previousSI = (SILabelValue)iLabel.getCurrentValue();
            this.addNoise(previousSI, nextSI, StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S(), StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_Incidence(), StandardPackage.eINSTANCE.getSILabelValue_I(), 1.0);
        }
        IntegrationLabelValue nextVal = (IntegrationLabelValue)iLabel.getNextValue();
        nextVal.eClass().getEAllAttributes();
    }

    protected void addNoise(IntegrationLabelValue previous, IntegrationLabelValue next, EAttribute source, EAttribute delta, EAttribute target, double fraction) {
        double sourceNow;
        if (Double.isInfinite(fraction) || Double.isNaN(fraction)) {
            return;
        }
        double sourcePrevious = previous.eGetDouble(source.getFeatureID());
        double Savg = (sourcePrevious + (sourceNow = next.eGetDouble(source.getFeatureID()))) / 2.0;
        if (Savg <= (double)BinomialDistributionUtil.MAX_N) {
            int S = (int)Math.ceil(Savg);
            double prob = next.eGetDouble(delta.getFeatureID()) * fraction / (double)S;
            if (!Double.isNaN(prob) && prob < 1.0) {
                int newDelta = this.getBinomialDistribution().fastPickFromBinomialDist(prob, S);
                double oldDelta = next.eGetDouble(delta.getFeatureID()) * fraction;
                double diff = (double)newDelta - oldDelta;
                if (next.eGetDouble(source.getFeatureID()) - diff < 0.0 || next.eGetDouble(target.getFeatureID()) + diff < 0.0) {
                    next.eSetDouble(source.getFeatureID(), next.eGetDouble(source.getFeatureID()) + oldDelta);
                    next.eSetDouble(target.getFeatureID(), next.eGetDouble(target.getFeatureID()) - oldDelta);
                    if (next.eGetDouble(source.getFeatureID()) < 0.0) {
                        next.eSetDouble(source.getFeatureID(), 0.0);
                    }
                    if (next.eGetDouble(target.getFeatureID()) < 0.0) {
                        next.eSetDouble(target.getFeatureID(), 0.0);
                    }
                    next.eSetDouble(delta.getFeatureID(), 0.0);
                    return;
                }
                next.eSetDouble(source.getFeatureID(), next.eGetDouble(source.getFeatureID()) - diff);
                next.eSetDouble(target.getFeatureID(), next.eGetDouble(target.getFeatureID()) + diff);
                next.eSetDouble(delta.getFeatureID(), next.eGetDouble(delta.getFeatureID()) + diff);
            }
        }
    }

    @Override
    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 16: {
                return this.getReferencePopulationDensity();
            }
            case 17: {
                return this.getRoadNetworkInfectiousProportion();
            }
            case 18: {
                return this.getCharacteristicMixingDistance();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    @Override
    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 16: {
                this.setReferencePopulationDensity((Double)newValue);
                return;
            }
            case 17: {
                this.setRoadNetworkInfectiousProportion((Double)newValue);
                return;
            }
            case 18: {
                this.setCharacteristicMixingDistance((Double)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    @Override
    public void eUnset(int featureID) {
        switch (featureID) {
            case 16: {
                this.setReferencePopulationDensity(100.0);
                return;
            }
            case 17: {
                this.setRoadNetworkInfectiousProportion(0.01);
                return;
            }
            case 18: {
                this.setCharacteristicMixingDistance(2.25);
                return;
            }
        }
        super.eUnset(featureID);
    }

    @Override
    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 16: {
                return this.referencePopulationDensity != 100.0;
            }
            case 17: {
                return this.roadNetworkInfectiousProportion != 0.01;
            }
            case 18: {
                return this.characteristicMixingDistance != 2.25;
            }
        }
        return super.eIsSet(featureID);
    }

    @Override
    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (referencePopulationDensity: ");
        result.append(this.referencePopulationDensity);
        result.append(", roadNetworkInfectiousProportion: ");
        result.append(this.roadNetworkInfectiousProportion);
        result.append(", characteristicMixingDistance: ");
        result.append(this.characteristicMixingDistance);
        result.append(')');
        return result.toString();
    }

    @Override
    public double getNormalizedEffectiveInfectious(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        this.determineMixingStrategy();
        if (this.doCommonBorderMixing && (Double)this.eGet((EStructuralFeature)mixingAttribute) == 0.0 && (Double)this.eGet((EStructuralFeature)roadAttribute) == 0.0) {
            double totalPopulation = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount();
            double retVal = 0.0;
            if (totalPopulation > 0.0) {
                retVal = onsiteInfectious / totalPopulation;
            }
            return retVal;
        }
        List cEdges = (List)this.edgeListObjectPool.get();
        cEdges.clear();
        if (!this.doCommonBorderMixing) {
            return this.doMixingViaMixingEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, mixingAttribute, roadAttribute);
        }
        return this.doMixingViaCommonBorderEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, mixingAttribute, roadAttribute);
    }

    @Override
    public EAttribute getBirthsCompartment() {
        return StandardPackage.eINSTANCE.getStandardDiseaseModelLabelValue_S();
    }

    @Override
    public void doDeaths(StandardDiseaseModelLabelValue currentState, StandardDiseaseModelLabelValue delta, double deaths) {
        double outflow = deaths;
        double populationCount = currentState.getPopulationCount();
        double factor = outflow / populationCount;
        if (Double.isNaN(factor) || Double.isInfinite(factor)) {
            factor = 0.0;
        }
        currentState.scale(factor);
        double diseaseDeaths = delta.getDiseaseDeaths();
        delta.sub(currentState);
        delta.setDiseaseDeaths(diseaseDeaths);
    }

    protected void determineMixingStrategy() {
        if (this.mixingStrategyDetermined) {
            return;
        }
        Graph g = this.getGraph();
        EMap edges = g.getEdges();
        for (Map.Entry entry : edges.entrySet()) {
            if (!(entry.getValue() instanceof MixingEdge)) continue;
            this.mixingStrategyDetermined = true;
            this.doCommonBorderMixing = false;
            return;
        }
        this.mixingStrategyDetermined = true;
    }

    private double doMixingViaCommonBorderEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = 0.0;
        double populationChangeFromMixing = 0.0;
        List cEdges = (List)this.edgeListObjectPool.get();
        cEdges.clear();
        CommonBorderRelationshipLabelImpl.getCommonBorderEdgesFromNode((Node)node, (List)cEdges);
        int i = 0;
        while (i < cEdges.size()) {
            Edge borderEdge = (Edge)cEdges.get(i);
            Node otherNode = borderEdge.getOtherNode(node);
            double borderLength = ((CommonBorderRelationshipLabelValue)borderEdge.getLabel().getCurrentValue()).getBorderLength();
            if (otherNode instanceof Region) {
                double otherArea = 0.0;
                double otherPopulation = 0.0;
                double otherInfective = 0.0;
                EList labs = otherNode.getLabels();
                int j = 0;
                while (j < labs.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    NodeLabel otherLabel = (NodeLabel)labs.get(j);
                    if (otherLabel instanceof AreaLabel) {
                        otherArea = ((AreaLabel)otherLabel).getCurrentAreaValue().getArea();
                    } else if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                        otherPopulation = ((StandardDiseaseModelLabelValue)otherDiseaseLabel.getTempValue()).getPopulationCount();
                        otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                    }
                    ++j;
                }
                double mixingFactor = Math.min((Double)this.eGet((EStructuralFeature)mixingAttribute) * borderLength / otherArea, 1.0);
                if (otherArea == 0.0) {
                    mixingFactor = 0.0;
                }
                infectiousChangeFromMixing += mixingFactor * otherInfective;
                populationChangeFromMixing += mixingFactor * otherPopulation;
            }
            ++i;
        }
        this.edgeListObjectPool.release((Object)cEdges);
        return this.addMixingRoadTransportationEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, infectiousChangeFromMixing, populationChangeFromMixing, roadAttribute);
    }

    private double doMixingViaMixingEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, EAttribute mixingAttribute, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = 0.0;
        double populationChangeFromMixing = 0.0;
        List mEdges = (List)this.edgeListObjectPool.get();
        mEdges.clear();
        MixingEdgeLabelImpl.getMixingEdgesFromNode((Node)node, (String)this.getPopulationIdentifier(), (List)mEdges);
        int i = 0;
        while (i < mEdges.size()) {
            MixingEdge mixingEdge = (MixingEdge)mEdges.get(i);
            MixingEdgeLabelValue mixingLabelValue = mixingEdge.getLabel().getCurrentValue();
            double mixingRateOrAbs = mixingLabelValue.getMixingRate();
            boolean useAbsoluteValue = mixingEdge.isUseAbsoluteValues();
            Node otherNode = mixingEdge.getOtherNode(node);
            if (otherNode instanceof Region) {
                double otherPopulation = 0.0;
                double otherInfective = 0.0;
                EList labs = otherNode.getLabels();
                int j = 0;
                while (j < labs.size()) {
                    StandardDiseaseModelLabel otherDiseaseLabel;
                    NodeLabel otherLabel = (NodeLabel)labs.get(j);
                    if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                        otherPopulation = ((StandardDiseaseModelLabelValue)otherDiseaseLabel.getTempValue()).getPopulationCount();
                        otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                    }
                    ++j;
                }
                if (useAbsoluteValue && otherPopulation > 0.0) {
                    if (mixingRateOrAbs > otherPopulation) {
                        mixingRateOrAbs = otherPopulation;
                    }
                    double fraction = mixingRateOrAbs / otherPopulation;
                    infectiousChangeFromMixing += fraction * otherInfective;
                    populationChangeFromMixing += fraction * otherPopulation;
                } else {
                    infectiousChangeFromMixing += mixingRateOrAbs * otherInfective;
                    populationChangeFromMixing += mixingRateOrAbs * otherPopulation;
                }
            }
            ++i;
        }
        this.edgeListObjectPool.release((Object)mEdges);
        return this.addMixingRoadTransportationEdges(node, diseaseLabel, onsiteInfectious, infectiousAttribute, infectiousChangeFromMixing, populationChangeFromMixing, roadAttribute);
    }

    private double addMixingRoadTransportationEdges(Node node, StandardDiseaseModelLabel diseaseLabel, double onsiteInfectious, EAttribute infectiousAttribute, double currentInfectiousChangeFromMixing, double currentPopulationChangeFromMixing, EAttribute roadAttribute) {
        double infectiousChangeFromMixing = currentInfectiousChangeFromMixing;
        double populationChangeFromMixing = currentPopulationChangeFromMixing;
        List rEdges = (List)this.edgeListObjectPool.get();
        rEdges.clear();
        RoadTransportRelationshipLabelImpl.getRoadEdgesFromNode((Node)node, (List)rEdges);
        int i = 0;
        while (i < rEdges.size()) {
            Edge roadEdge = (Edge)rEdges.get(i);
            EdgeLabel edgeLabel = roadEdge.getLabel();
            double numCrossings = ((RoadTransportRelationshipLabelValue)edgeLabel.getCurrentValue()).getNumberCrossings();
            double infectiousProportion = Math.min((Double)this.eGet((EStructuralFeature)roadAttribute) * numCrossings, 1.0);
            Node otherNode = roadEdge.getOtherNode(node);
            double otherPopulation = 0.0;
            double otherInfective = 0.0;
            EList labs = otherNode.getLabels();
            int j = 0;
            while (j < labs.size()) {
                StandardDiseaseModelLabel otherDiseaseLabel;
                NodeLabel otherLabel = (NodeLabel)labs.get(j);
                if (otherLabel instanceof StandardDiseaseModelLabel && (otherDiseaseLabel = (StandardDiseaseModelLabel)otherLabel).getDecorator() == this && otherDiseaseLabel.getIdentifier().equals(diseaseLabel.getIdentifier())) {
                    otherPopulation = ((StandardDiseaseModelLabelValue)otherDiseaseLabel.getTempValue()).getPopulationCount();
                    otherInfective = otherDiseaseLabel.getTempValue().eGetDouble(infectiousAttribute.getFeatureID());
                }
                ++j;
            }
            infectiousChangeFromMixing += infectiousProportion * otherInfective;
            populationChangeFromMixing += infectiousProportion * otherPopulation;
            ++i;
        }
        this.edgeListObjectPool.release((Object)rEdges);
        double totalPopulation = ((StandardDiseaseModelLabelValue)diseaseLabel.getTempValue()).getPopulationCount() + populationChangeFromMixing;
        double retVal = 0.0;
        if (totalPopulation > 0.0) {
            retVal = (onsiteInfectious + infectiousChangeFromMixing) / totalPopulation;
        }
        return retVal;
    }

    public double getArea(PopulationLabel populationLabel) {
        double retValue = 0.0;
        retValue = populationLabel.getPopulatedArea();
        if (retValue == 0.0) {
            for (NodeLabel nodeLabel : populationLabel.getNode().getLabels()) {
                if (!(nodeLabel instanceof AreaLabel)) continue;
                AreaLabel areaLabel = (AreaLabel)nodeLabel;
                retValue = areaLabel.getCurrentAreaValue().getArea();
                break;
            }
        }
        return retValue;
    }

    public void resetLabels() throws ScenarioInitializationException {
        super.resetLabels();
        if (this.getBinomialDistribution() != null) {
            this.getBinomialDistribution().setSeed(this.getRandomSeed());
        }
    }
}

