/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ISourceReference;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.refactoring.IVisibilityChangeListener;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.dialogs.CheckedTreeSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceActionDialog
extends CheckedTreeSelectionDialog {
    private static final String SETTINGS_SECTION_METHODS = "SourceActionDialog.methods";
    private static final String SETTINGS_SECTION_CONSTRUCTORS = "SourceActionDialog.constructors";
    private static final String SETTINGS_INSERT_POSITION = "InsertPosition.v2";
    private static final int INSERT_FIRST_INDEX = 0;
    private static final int INSERT_LAST_INDEX = 1;
    private static final int INSERT_POSITION_FROM_EDITOR = 2;
    private static final String SETTINGS_VISIBILITY_MODIFIER = "VisibilityModifier";
    private static final String SETTINGS_FINAL_MODIFIER = "FinalModifier";
    private static final String SETTINGS_SYNCHRONIZED_MODIFIER = "SynchronizedModifier";
    private static final String SETTINGS_COMMENTS = "Comments";
    private List<IJavaElement> fInsertPositions;
    private List<String> fLabels;
    private int fCurrentPositionIndex;
    private IDialogSettings fSettings;
    private CompilationUnitEditor fEditor;
    private ITreeContentProvider fContentProvider;
    private boolean fGenerateComment;
    private IType fType;
    private int fWidth;
    private int fHeight;
    private String fCommentString;
    private boolean fEnableInsertPosition = true;
    private int fVisibilityModifier;
    private boolean fFinal;
    private boolean fSynchronized;
    private Composite fInsertPositionComposite;
    private boolean fHasUserChangedPositionIndex;

    public SourceActionDialog(Shell parent, ILabelProvider labelProvider, ITreeContentProvider contentProvider, CompilationUnitEditor editor, IType type, boolean isConstructor) throws JavaModelException {
        super(parent, labelProvider, contentProvider);
        this.fEditor = editor;
        this.fContentProvider = contentProvider;
        this.fType = type;
        this.fCommentString = ActionMessages.SourceActionDialog_createMethodComment;
        this.setEmptyListMessage(ActionMessages.SourceActionDialog_no_entries);
        this.fWidth = 60;
        this.fHeight = 18;
        boolean generateCommentsDefault = JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject()).createComments;
        IDialogSettings dialogSettings = JavaPlugin.getDefault().getDialogSettings();
        String sectionId = isConstructor ? SETTINGS_SECTION_CONSTRUCTORS : SETTINGS_SECTION_METHODS;
        this.fSettings = dialogSettings.getSection(sectionId);
        if (this.fSettings == null) {
            this.fSettings = dialogSettings.addNewSection(sectionId);
        }
        this.fVisibilityModifier = this.asInt(this.fSettings.get(SETTINGS_VISIBILITY_MODIFIER), 1);
        this.fFinal = this.asBoolean(this.fSettings.get(SETTINGS_FINAL_MODIFIER), false);
        this.fSynchronized = this.asBoolean(this.fSettings.get(SETTINGS_SYNCHRONIZED_MODIFIER), false);
        this.fGenerateComment = this.asBoolean(this.fSettings.get(SETTINGS_COMMENTS), generateCommentsDefault);
        this.fInsertPositions = new ArrayList<IJavaElement>();
        this.fLabels = new ArrayList<String>();
        IJavaElement[] members = this.fType.getChildren();
        this.fInsertPositions.add(members.length > 0 ? members[0] : null);
        this.fInsertPositions.add(null);
        this.fLabels.add(ActionMessages.SourceActionDialog_first);
        this.fLabels.add(ActionMessages.SourceActionDialog_last);
        int i = 0;
        while (i < members.length) {
            IJavaElement curr = members[i];
            String methodLabel = JavaElementLabels.getElementLabel(curr, 1L);
            this.fLabels.add(Messages.format(ActionMessages.SourceActionDialog_after, methodLabel));
            this.fInsertPositions.add(this.findSibling(curr, members));
            ++i;
        }
        this.fInsertPositions.add(null);
        int storedPositionIndex = this.asInt(this.fSettings.get(SETTINGS_INSERT_POSITION), 2);
        if (storedPositionIndex == 2) {
            int indexAfterCursor = this.getElementAfterCursorPosition(this.fEditor, members);
            if (indexAfterCursor == -1) {
                this.fCurrentPositionIndex = isConstructor ? 0 : 1;
            } else if (indexAfterCursor == 0) {
                this.fCurrentPositionIndex = 0;
            } else if (indexAfterCursor > 0) {
                this.fCurrentPositionIndex = indexAfterCursor + 1;
            }
        } else {
            this.fCurrentPositionIndex = storedPositionIndex <= 0 ? 0 : 1;
        }
    }

    protected IType getType() {
        return this.fType;
    }

    protected boolean asBoolean(String string, boolean defaultValue) {
        if (string != null) {
            return StringConverter.asBoolean((String)string, (boolean)defaultValue);
        }
        return defaultValue;
    }

    protected int asInt(String string, int defaultValue) {
        if (string != null) {
            return StringConverter.asInt((String)string, (int)defaultValue);
        }
        return defaultValue;
    }

    private IJavaElement findSibling(IJavaElement curr, IJavaElement[] members) throws JavaModelException {
        IMember res = null;
        int methodStart = ((IMember)curr).getSourceRange().getOffset();
        int i = members.length - 1;
        while (i >= 0) {
            IMember member = (IMember)members[i];
            if (methodStart >= member.getSourceRange().getOffset()) {
                return res;
            }
            res = member;
            --i;
        }
        return null;
    }

    private int getElementAfterCursorPosition(CompilationUnitEditor editor, IJavaElement[] members) throws JavaModelException {
        if (editor == null) {
            return -1;
        }
        int offset = ((ITextSelection)editor.getSelectionProvider().getSelection()).getOffset();
        int i = 0;
        while (i < members.length) {
            IMember curr = (IMember)members[i];
            ISourceRange range = curr.getSourceRange();
            if (offset < range.getOffset()) {
                return i;
            }
            ++i;
        }
        return members.length;
    }

    public boolean close() {
        this.fSettings.put(SETTINGS_VISIBILITY_MODIFIER, StringConverter.asString((int)this.fVisibilityModifier));
        this.fSettings.put(SETTINGS_FINAL_MODIFIER, StringConverter.asString((boolean)this.fFinal));
        this.fSettings.put(SETTINGS_SYNCHRONIZED_MODIFIER, StringConverter.asString((boolean)this.fSynchronized));
        this.fSettings.put(SETTINGS_COMMENTS, this.fGenerateComment);
        if (this.fHasUserChangedPositionIndex) {
            if (this.fCurrentPositionIndex == 0 || this.fCurrentPositionIndex == 1) {
                this.fSettings.put(SETTINGS_INSERT_POSITION, StringConverter.asString((int)this.fCurrentPositionIndex));
            } else if (this.fEditor != null) {
                this.fSettings.put(SETTINGS_INSERT_POSITION, StringConverter.asString((int)2));
            }
        }
        return super.close();
    }

    public void setSize(int width, int height) {
        this.fWidth = width;
        this.fHeight = height;
    }

    private void setInsertPosition(int insert) {
        this.fCurrentPositionIndex = insert;
    }

    public void setCommentString(String string) {
        this.fCommentString = string;
    }

    protected ITreeContentProvider getContentProvider() {
        return this.fContentProvider;
    }

    public boolean getGenerateComment() {
        return this.fGenerateComment;
    }

    public int getVisibilityModifier() {
        return this.fVisibilityModifier;
    }

    public void setGenerateComment(boolean comment) {
        this.fGenerateComment = comment;
    }

    protected void setVisibility(int visibility) {
        this.fVisibilityModifier = visibility;
    }

    private void setFinal(boolean value) {
        this.fFinal = value;
    }

    private void setSynchronized(boolean value) {
        this.fSynchronized = value;
    }

    protected Composite createSelectionButtons(Composite composite) {
        Composite buttonComposite = super.createSelectionButtons(composite);
        GridLayout layout = new GridLayout();
        buttonComposite.setLayout((Layout)layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        return buttonComposite;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 0: {
                this.okPressed();
                break;
            }
            case 1: {
                this.cancelPressed();
            }
        }
    }

    protected Label createMessageArea(Composite composite) {
        if (this.getMessage() != null) {
            Label label = new Label(composite, 0);
            label.setText(this.getMessage());
            label.setFont(composite.getFont());
            return label;
        }
        return null;
    }

    protected Control createDialogArea(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        GridData gd = null;
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        Label messageLabel = this.createMessageArea(composite);
        if (messageLabel != null) {
            gd = new GridData(256);
            gd.horizontalSpan = 2;
            messageLabel.setLayoutData((Object)gd);
        }
        Composite inner = new Composite(composite, 0);
        GridLayout innerLayout = new GridLayout();
        innerLayout.numColumns = 2;
        innerLayout.marginHeight = 0;
        innerLayout.marginWidth = 0;
        inner.setLayout((Layout)innerLayout);
        inner.setFont(parent.getFont());
        CheckboxTreeViewer treeViewer = this.createTreeViewer(inner);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        gd.heightHint = this.convertHeightInCharsToPixels(this.fHeight);
        treeViewer.getControl().setLayoutData((Object)gd);
        Composite buttonComposite = this.createSelectionButtons(inner);
        gd = new GridData(272);
        buttonComposite.setLayoutData((Object)gd);
        gd = new GridData(1808);
        inner.setLayoutData((Object)gd);
        this.fInsertPositionComposite = this.createInsertPositionCombo(composite);
        this.fInsertPositionComposite.setLayoutData((Object)new GridData(768));
        Composite commentComposite = this.createCommentSelection(composite);
        commentComposite.setLayoutData((Object)new GridData(768));
        Control linkControl = this.createLinkControl(composite);
        if (linkControl != null) {
            linkControl.setLayoutData((Object)new GridData(768));
        }
        gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        SourceActionDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected Control createLinkControl(Composite composite) {
        return null;
    }

    protected void openCodeTempatePage(String id) {
        HashMap<String, String> arg = new HashMap<String, String>();
        arg.put("CodeTemplatePreferencePage.select_template", id);
        PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)this.fType.getJavaProject().getProject(), (String)"org.eclipse.jdt.ui.propertyPages.CodeTemplatePreferencePage", null, arg).open();
    }

    protected Composite createCommentSelection(Composite composite) {
        Composite commentComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        commentComposite.setLayout((Layout)layout);
        commentComposite.setFont(composite.getFont());
        Button commentButton = new Button(commentComposite, 32);
        commentButton.setText(this.fCommentString);
        commentButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                boolean isSelected = ((Button)e.widget).getSelection();
                SourceActionDialog.this.setGenerateComment(isSelected);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        commentButton.setSelection(this.getGenerateComment());
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        commentButton.setLayoutData((Object)gd);
        return commentComposite;
    }

    protected Composite addVisibilityAndModifiersChoices(Composite buttonComposite) {
        IVisibilityChangeListener visibilityChangeListener = new IVisibilityChangeListener(){

            public void visibilityChanged(int newVisibility) {
                SourceActionDialog.this.setVisibility(newVisibility);
            }

            public void modifierChanged(int modifier, boolean isChecked) {
                switch (modifier) {
                    case 16: {
                        SourceActionDialog.this.setFinal(isChecked);
                        return;
                    }
                    case 32: {
                        SourceActionDialog.this.setSynchronized(isChecked);
                        return;
                    }
                }
            }
        };
        int initialVisibility = this.getVisibilityModifier();
        int[] nArray = new int[4];
        nArray[0] = 1;
        nArray[1] = 4;
        nArray[2] = 2;
        int[] availableVisibilities = nArray;
        Composite visibilityComposite = this.createVisibilityControlAndModifiers(buttonComposite, visibilityChangeListener, availableVisibilities, initialVisibility);
        return visibilityComposite;
    }

    private List<Integer> convertToIntegerList(int[] array) {
        ArrayList<Integer> result = new ArrayList<Integer>(array.length);
        int i = 0;
        while (i < array.length) {
            result.add(new Integer(array[i]));
            ++i;
        }
        return result;
    }

    public void create() {
        super.create();
        CheckboxTreeViewer treeViewer = this.getTreeViewer();
        TreeItem[] items = treeViewer.getTree().getItems();
        if (items.length > 0) {
            Object revealedElement = items[0];
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    revealedElement = items[i].getData();
                    break;
                }
                ++i;
            }
            treeViewer.setSelection((ISelection)new StructuredSelection(revealedElement));
            treeViewer.reveal(revealedElement);
        }
    }

    protected Composite createVisibilityControl(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        List<Integer> allowedVisibilities = this.convertToIntegerList(availableVisibilities);
        if (allowedVisibilities.size() == 1) {
            return null;
        }
        Group group = new Group(parent, 0);
        group.setText(ActionMessages.SourceActionDialog_modifier_group);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 4;
        group.setLayout((Layout)layout);
        String[] labels = new String[]{ActionMessages.SourceActionDialog_modifier_public, ActionMessages.SourceActionDialog_modifier_protected, ActionMessages.SourceActionDialog_modifier_default, ActionMessages.SourceActionDialog_modifier_private};
        Integer[] data = new Integer[]{new Integer(1), new Integer(4), new Integer(0), new Integer(2)};
        Integer initialVisibility = new Integer(correctVisibility);
        int i = 0;
        while (i < labels.length) {
            Button radio = new Button((Composite)group, 16);
            Integer visibilityCode = data[i];
            radio.setLayoutData((Object)new GridData(256));
            radio.setText(labels[i]);
            radio.setData((Object)visibilityCode);
            radio.setSelection(visibilityCode.equals(initialVisibility));
            radio.setEnabled(allowedVisibilities.contains(visibilityCode));
            radio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    visibilityChangeListener.visibilityChanged((Integer)event.widget.getData());
                }
            });
            ++i;
        }
        return group;
    }

    protected Composite createVisibilityControlAndModifiers(Composite parent, final IVisibilityChangeListener visibilityChangeListener, int[] availableVisibilities, int correctVisibility) {
        Composite visibilityComposite = this.createVisibilityControl(parent, visibilityChangeListener, availableVisibilities, correctVisibility);
        Button finalCheckboxButton = new Button(visibilityComposite, 32);
        finalCheckboxButton.setText(ActionMessages.SourceActionDialog_modifier_final);
        GridData gd = new GridData(256);
        finalCheckboxButton.setLayoutData((Object)gd);
        finalCheckboxButton.setData((Object)new Integer(16));
        finalCheckboxButton.setEnabled(true);
        finalCheckboxButton.setSelection(this.isFinal());
        finalCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                visibilityChangeListener.modifierChanged((Integer)event.widget.getData(), ((Button)event.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        Button syncCheckboxButton = new Button(visibilityComposite, 32);
        syncCheckboxButton.setText(ActionMessages.SourceActionDialog_modifier_synchronized);
        gd = new GridData(256);
        syncCheckboxButton.setLayoutData((Object)gd);
        syncCheckboxButton.setData((Object)new Integer(32));
        syncCheckboxButton.setEnabled(true);
        syncCheckboxButton.setSelection(this.isSynchronized());
        syncCheckboxButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                visibilityChangeListener.modifierChanged((Integer)event.widget.getData(), ((Button)event.widget).getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        return visibilityComposite;
    }

    protected Composite createInsertPositionCombo(Composite composite) {
        Composite selectionComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        selectionComposite.setLayout((Layout)layout);
        this.addOrderEntryChoices(selectionComposite);
        return selectionComposite;
    }

    private Composite addOrderEntryChoices(Composite buttonComposite) {
        Label enterLabel = new Label(buttonComposite, 0);
        enterLabel.setText(ActionMessages.SourceActionDialog_enterAt_label);
        if (!this.fEnableInsertPosition) {
            enterLabel.setEnabled(false);
        }
        GridData gd = new GridData(256);
        enterLabel.setLayoutData((Object)gd);
        final Combo enterCombo = new Combo(buttonComposite, 8);
        SWTUtil.setDefaultVisibleItemCount(enterCombo);
        if (!this.fEnableInsertPosition) {
            enterCombo.setEnabled(false);
        }
        this.fillWithPossibleInsertPositions(enterCombo);
        gd = new GridData(1808);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWidth);
        enterCombo.setLayoutData((Object)gd);
        enterCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = enterCombo.getSelectionIndex();
                SourceActionDialog.this.setInsertPosition(index);
                SourceActionDialog.this.fHasUserChangedPositionIndex = true;
            }
        });
        return buttonComposite;
    }

    private void fillWithPossibleInsertPositions(Combo combo) {
        combo.setItems(this.fLabels.toArray(new String[this.fLabels.size()]));
        combo.select(this.fCurrentPositionIndex);
    }

    public boolean getFinal() {
        return this.fFinal;
    }

    public boolean getSynchronized() {
        return this.fSynchronized;
    }

    public boolean isFinal() {
        return this.fFinal;
    }

    public boolean isSynchronized() {
        return this.fSynchronized;
    }

    public void setElementPositionEnabled(boolean enabled) {
        this.fEnableInsertPosition = enabled;
    }

    public boolean isElementPositionEnabled() {
        return this.fEnableInsertPosition;
    }

    public IJavaElement getElementPosition() {
        return this.fInsertPositions.get(this.fCurrentPositionIndex);
    }

    public int getInsertOffset() throws JavaModelException {
        IJavaElement elementPosition = this.getElementPosition();
        if (elementPosition instanceof ISourceReference) {
            return ((ISourceReference)elementPosition).getSourceRange().getOffset();
        }
        return -1;
    }

    protected IDialogSettings getDialogSettings() {
        return this.fSettings;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return JavaPlugin.getDefault().getDialogSettingsSection("DialogBounds_" + ((Object)((Object)this)).getClass().getSimpleName());
    }
}

