/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.code;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnnotationTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.ChildListPropertyDescriptor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.ContinueStatement;
import org.eclipse.jdt.core.dom.DoStatement;
import org.eclipse.jdt.core.dom.EnhancedForStatement;
import org.eclipse.jdt.core.dom.EnumDeclaration;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ForStatement;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Initializer;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.LabeledStatement;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeParameter;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.WhileStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.core.dom.rewrite.TargetSourceRangeComputer;
import org.eclipse.jdt.core.refactoring.CompilationUnitChange;
import org.eclipse.jdt.core.refactoring.descriptors.ExtractMethodDescriptor;
import org.eclipse.jdt.internal.core.refactoring.descriptors.RefactoringSignatureDescriptorFactory;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.dom.BodyDeclarationRewrite;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.StatementRewrite;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModel;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalPositionGroup;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.jdt.internal.corext.refactoring.JavaRefactoringDescriptorUtil;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.code.ExtractMethodAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.code.SnippetFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.SelectionAwareSourceRangeComputer;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.internal.ui.text.correction.ModifierCorrectionSubProcessor;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringChangeDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.ResourceChangeChecker;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtractMethodRefactoring
extends Refactoring {
    private static final String ATTRIBUTE_VISIBILITY = "visibility";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_COMMENTS = "comments";
    private static final String ATTRIBUTE_REPLACE = "replace";
    private static final String ATTRIBUTE_EXCEPTIONS = "exceptions";
    private ICompilationUnit fCUnit;
    private CompilationUnit fRoot;
    private ImportRewrite fImportRewriter;
    private int fSelectionStart;
    private int fSelectionLength;
    private AST fAST;
    private ASTRewrite fRewriter;
    private ExtractMethodAnalyzer fAnalyzer;
    private int fVisibility;
    private String fMethodName;
    private boolean fThrowRuntimeExceptions;
    private List<ParameterInfo> fParameterInfos;
    private Set<String> fUsedNames;
    private boolean fGenerateJavadoc;
    private boolean fReplaceDuplicates;
    private SnippetFinder.Match[] fDuplicates;
    private int fDestinationIndex = 0;
    private ASTNode fDestination;
    private ASTNode[] fDestinations;
    private LinkedProposalModel fLinkedProposalModel;
    private static final String EMPTY = "";
    private static final String KEY_TYPE = "type";
    private static final String KEY_NAME = "name";

    public ExtractMethodRefactoring(ICompilationUnit unit, int selectionStart, int selectionLength) {
        this.fCUnit = unit;
        this.fRoot = null;
        this.fMethodName = "extracted";
        this.fSelectionStart = selectionStart;
        this.fSelectionLength = selectionLength;
        this.fVisibility = -1;
    }

    public ExtractMethodRefactoring(JavaRefactoringArguments arguments, RefactoringStatus status) {
        this((ICompilationUnit)null, 0, 0);
        RefactoringStatus initializeStatus = this.initialize(arguments);
        status.merge(initializeStatus);
    }

    public ExtractMethodRefactoring(CompilationUnit astRoot, int selectionStart, int selectionLength) {
        this((ICompilationUnit)astRoot.getTypeRoot(), selectionStart, selectionLength);
        this.fRoot = astRoot;
    }

    public void setLinkedProposalModel(LinkedProposalModel linkedProposalModel) {
        this.fLinkedProposalModel = linkedProposalModel;
    }

    public String getName() {
        return RefactoringCoreMessages.ExtractMethodRefactoring_name;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        pm.beginTask(EMPTY, 100);
        if (this.fSelectionStart < 0 || this.fSelectionLength == 0) {
            return this.mergeTextSelectionStatus(result);
        }
        IFile[] changedFiles = ResourceUtil.getFiles(new ICompilationUnit[]{this.fCUnit});
        result.merge(Checks.validateModifiesFiles(changedFiles, this.getValidationContext()));
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(ResourceChangeChecker.checkFilesToBeChanged((IFile[])changedFiles, (IProgressMonitor)new SubProgressMonitor(pm, 1)));
        if (this.fRoot == null) {
            this.fRoot = RefactoringASTParser.parseWithASTProvider((ITypeRoot)this.fCUnit, true, (IProgressMonitor)new SubProgressMonitor(pm, 99));
        }
        this.fImportRewriter = StubUtility.createImportRewrite(this.fRoot, true);
        this.fAST = this.fRoot.getAST();
        this.fRoot.accept(this.createVisitor());
        this.fSelectionStart = this.fAnalyzer.getSelection().getOffset();
        this.fSelectionLength = this.fAnalyzer.getSelection().getLength();
        result.merge(this.fAnalyzer.checkInitialConditions(this.fImportRewriter));
        if (result.hasFatalError()) {
            return result;
        }
        if (this.fVisibility == -1) {
            this.setVisibility(2);
        }
        this.initializeParameterInfos();
        this.initializeUsedNames();
        this.initializeDuplicates();
        this.initializeDestinations();
        return result;
    }

    private ASTVisitor createVisitor() throws CoreException {
        this.fAnalyzer = new ExtractMethodAnalyzer(this.fCUnit, Selection.createFromStartLength(this.fSelectionStart, this.fSelectionLength));
        return this.fAnalyzer;
    }

    public void setMethodName(String name) {
        this.fMethodName = name;
    }

    public String getMethodName() {
        return this.fMethodName;
    }

    public void setVisibility(int visibility) {
        this.fVisibility = visibility;
    }

    public int getVisibility() {
        return this.fVisibility;
    }

    public List<ParameterInfo> getParameterInfos() {
        return this.fParameterInfos;
    }

    public void setThrowRuntimeExceptions(boolean throwRuntimeExceptions) {
        this.fThrowRuntimeExceptions = throwRuntimeExceptions;
    }

    public RefactoringStatus checkMethodName() {
        return Checks.checkMethodName(this.fMethodName, (IJavaElement)this.fCUnit);
    }

    public ASTNode[] getDestinations() {
        return this.fDestinations;
    }

    public void setDestination(int index) {
        this.fDestination = this.fDestinations[index];
        this.fDestinationIndex = index;
    }

    public RefactoringStatus checkParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        for (ParameterInfo parameter : this.fParameterInfos) {
            result.merge(Checks.checkIdentifier(parameter.getNewName(), (IJavaElement)this.fCUnit));
            for (ParameterInfo other : this.fParameterInfos) {
                if (parameter == other || !other.getNewName().equals(parameter.getNewName())) continue;
                result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_sameParameter, BasicElementLabels.getJavaElementName(other.getNewName())));
                return result;
            }
            if (!parameter.isRenamed() || !this.fUsedNames.contains(parameter.getNewName())) continue;
            result.addError(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_nameInUse, BasicElementLabels.getJavaElementName(parameter.getNewName())));
            return result;
        }
        return result;
    }

    public RefactoringStatus checkVarargOrder() {
        Iterator<ParameterInfo> iter = this.fParameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo info = iter.next();
            if (!info.isOldVarargs() || !iter.hasNext()) continue;
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_error_vararg_ordering, BasicElementLabels.getJavaElementName(info.getOldName())));
        }
        return new RefactoringStatus();
    }

    public Set<String> getUsedNames() {
        return this.fUsedNames;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.ExtractMethodRefactoring_checking_new_name, 2);
        pm.subTask(EMPTY);
        RefactoringStatus result = this.checkMethodName();
        result.merge(this.checkParameterNames());
        result.merge(this.checkVarargOrder());
        pm.worked(1);
        if (pm.isCanceled()) {
            throw new OperationCanceledException();
        }
        BodyDeclaration node = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (node != null) {
            this.fAnalyzer.checkInput(result, this.fMethodName, this.fDestination);
            pm.worked(1);
        }
        pm.done();
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        if (this.fMethodName == null) {
            return null;
        }
        pm.beginTask(EMPTY, 2);
        try {
            this.fAnalyzer.aboutToCreateChange();
            BodyDeclaration declaration = this.fAnalyzer.getEnclosingBodyDeclaration();
            this.fRewriter = ASTRewrite.create((AST)declaration.getAST());
            CompilationUnitChange result = new CompilationUnitChange(RefactoringCoreMessages.ExtractMethodRefactoring_change_name, this.fCUnit);
            result.setSaveMode(1);
            result.setDescriptor((ChangeDescriptor)new RefactoringChangeDescriptor((RefactoringDescriptor)this.getRefactoringDescriptor()));
            MultiTextEdit root = new MultiTextEdit();
            result.setEdit((TextEdit)root);
            ASTNode[] selectedNodes = this.fAnalyzer.getSelectedNodes();
            this.fRewriter.setTargetSourceRangeComputer((TargetSourceRangeComputer)new SelectionAwareSourceRangeComputer(selectedNodes, this.fCUnit.getBuffer(), this.fSelectionStart, this.fSelectionLength));
            TextEditGroup substituteDesc = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_substitute_with_call, BasicElementLabels.getJavaElementName(this.fMethodName)));
            result.addTextEditGroup(substituteDesc);
            MethodDeclaration mm = this.createNewMethod(selectedNodes, this.fCUnit.findRecommendedLineSeparator(), substituteDesc);
            if (this.fLinkedProposalModel != null) {
                LinkedProposalPositionGroup typeGroup = this.fLinkedProposalModel.getPositionGroup(KEY_TYPE, true);
                typeGroup.addPosition(this.fRewriter.track((ASTNode)mm.getReturnType2()), false);
                ITypeBinding typeBinding = this.fAnalyzer.getReturnTypeBinding();
                if (typeBinding != null) {
                    ITypeBinding[] relaxingTypes = ASTResolving.getNarrowingTypes(this.fAST, typeBinding);
                    int i = 0;
                    while (i < relaxingTypes.length) {
                        typeGroup.addProposal(relaxingTypes[i], this.fCUnit, relaxingTypes.length - i);
                        ++i;
                    }
                }
                LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
                nameGroup.addPosition(this.fRewriter.track((ASTNode)mm.getName()), false);
                ModifierCorrectionSubProcessor.installLinkedVisibilityProposals(this.fLinkedProposalModel, this.fRewriter, mm.modifiers(), false);
            }
            TextEditGroup insertDesc = new TextEditGroup(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_add_method, BasicElementLabels.getJavaElementName(this.fMethodName)));
            result.addTextEditGroup(insertDesc);
            if (this.fDestination == this.fDestinations[0]) {
                ChildListPropertyDescriptor desc = (ChildListPropertyDescriptor)declaration.getLocationInParent();
                ListRewrite container = this.fRewriter.getListRewrite(declaration.getParent(), desc);
                container.insertAfter((ASTNode)mm, (ASTNode)declaration, insertDesc);
            } else {
                BodyDeclarationRewrite container = BodyDeclarationRewrite.create(this.fRewriter, this.fDestination);
                container.insert((BodyDeclaration)mm, insertDesc);
            }
            this.replaceDuplicates(result, mm.getModifiers());
            this.replaceBranches(result);
            if (this.fImportRewriter.hasRecordedChanges()) {
                TextEdit edit = this.fImportRewriter.rewriteImports(null);
                root.addChild(edit);
                result.addTextEditGroup(new TextEditGroup(RefactoringCoreMessages.ExtractMethodRefactoring_organize_imports, new TextEdit[]{edit}));
            }
            root.addChild(this.fRewriter.rewriteAST());
            CompilationUnitChange compilationUnitChange = result;
            return compilationUnitChange;
        }
        finally {
            pm.done();
        }
    }

    private void replaceBranches(final CompilationUnitChange result) {
        ASTNode[] selectedNodes = this.fAnalyzer.getSelectedNodes();
        int i = 0;
        while (i < selectedNodes.length) {
            ASTNode astNode = selectedNodes[i];
            astNode.accept(new ASTVisitor(){
                private LinkedList<String> fOpenLoopLabels = new LinkedList();

                private void registerLoopLabel(Statement node) {
                    String identifier;
                    if (node.getParent() instanceof LabeledStatement) {
                        LabeledStatement labeledStatement = (LabeledStatement)node.getParent();
                        identifier = labeledStatement.getLabel().getIdentifier();
                    } else {
                        identifier = null;
                    }
                    this.fOpenLoopLabels.add(identifier);
                }

                public boolean visit(ForStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(ForStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(WhileStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(WhileStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(EnhancedForStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(EnhancedForStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public boolean visit(DoStatement node) {
                    this.registerLoopLabel((Statement)node);
                    return super.visit(node);
                }

                public void endVisit(DoStatement node) {
                    this.fOpenLoopLabels.removeLast();
                }

                public void endVisit(ContinueStatement node) {
                    SimpleName label = node.getLabel();
                    if (this.fOpenLoopLabels.isEmpty() || label != null && !this.fOpenLoopLabels.contains(label.getIdentifier())) {
                        TextEditGroup description = new TextEditGroup(RefactoringCoreMessages.ExtractMethodRefactoring_replace_continue);
                        result.addTextEditGroup(description);
                        ReturnStatement rs = ExtractMethodRefactoring.this.fAST.newReturnStatement();
                        IVariableBinding returnValue = ExtractMethodRefactoring.this.fAnalyzer.getReturnValue();
                        if (returnValue != null) {
                            rs.setExpression((Expression)ExtractMethodRefactoring.this.fAST.newSimpleName(ExtractMethodRefactoring.this.getName(returnValue)));
                        }
                        ExtractMethodRefactoring.this.fRewriter.replace((ASTNode)node, (ASTNode)rs, description);
                    }
                }
            });
            ++i;
        }
    }

    private ExtractMethodDescriptor getRefactoringDescriptor() {
        AbstractTypeDeclaration decl;
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaProject javaProject = this.fCUnit.getJavaProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        ITypeBinding type = null;
        if (this.fDestination instanceof AbstractTypeDeclaration) {
            decl = (AbstractTypeDeclaration)this.fDestination;
            type = decl.resolveBinding();
        } else if (this.fDestination instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fDestination;
            type = decl.resolveBinding();
        }
        IMethodBinding method = null;
        BodyDeclaration enclosing = this.fAnalyzer.getEnclosingBodyDeclaration();
        if (enclosing instanceof MethodDeclaration) {
            MethodDeclaration node = (MethodDeclaration)enclosing;
            method = node.resolveBinding();
        }
        String description = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description_short, BasicElementLabels.getJavaElementName(this.fMethodName));
        String label = method != null ? BindingLabelProvider.getBindingLabel((IBinding)method, JavaElementLabels.ALL_FULLY_QUALIFIED) : "{...}";
        String header = Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_descriptor_description, new String[]{BasicElementLabels.getJavaElementName(this.getSignature()), label, BindingLabelProvider.getBindingLabel((IBinding)type, JavaElementLabels.ALL_FULLY_QUALIFIED)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, (Object)this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_name_pattern, BasicElementLabels.getJavaElementName(this.fMethodName)));
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_destination_pattern, BindingLabelProvider.getBindingLabel((IBinding)type, JavaElementLabels.ALL_FULLY_QUALIFIED)));
        String visibility = JdtFlags.getVisibilityString(this.fVisibility);
        if (EMPTY.equals(visibility)) {
            visibility = RefactoringCoreMessages.ExtractMethodRefactoring_default_visibility;
        }
        comment.addSetting(Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_visibility_pattern, visibility));
        if (this.fThrowRuntimeExceptions) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_declare_thrown_exceptions);
        }
        if (this.fReplaceDuplicates) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_replace_occurrences);
        }
        if (this.fGenerateJavadoc) {
            comment.addSetting(RefactoringCoreMessages.ExtractMethodRefactoring_generate_comment);
        }
        ExtractMethodDescriptor descriptor = RefactoringSignatureDescriptorFactory.createExtractMethodDescriptor((String)project, (String)description, (String)comment.asString(), arguments, (int)786434);
        arguments.put("input", JavaRefactoringDescriptorUtil.elementToHandle(project, (IJavaElement)this.fCUnit));
        arguments.put(KEY_NAME, this.fMethodName);
        arguments.put("selection", String.valueOf(new Integer(this.fSelectionStart).toString()) + " " + new Integer(this.fSelectionLength).toString());
        arguments.put(ATTRIBUTE_VISIBILITY, new Integer(this.fVisibility).toString());
        arguments.put(ATTRIBUTE_DESTINATION, new Integer(this.fDestinationIndex).toString());
        arguments.put(ATTRIBUTE_EXCEPTIONS, Boolean.valueOf(this.fThrowRuntimeExceptions).toString());
        arguments.put(ATTRIBUTE_COMMENTS, Boolean.valueOf(this.fGenerateJavadoc).toString());
        arguments.put(ATTRIBUTE_REPLACE, Boolean.valueOf(this.fReplaceDuplicates).toString());
        return descriptor;
    }

    public String getSignature() {
        return this.getSignature(this.fMethodName);
    }

    public String getSignature(String methodName) {
        MethodDeclaration methodDecl = this.createNewMethodDeclaration();
        methodDecl.setBody(null);
        String str = ASTNodes.asString((ASTNode)methodDecl);
        return str.substring(0, str.indexOf(59));
    }

    public int getNumberOfDuplicates() {
        if (this.fDuplicates == null) {
            return 0;
        }
        int result = 0;
        int i = 0;
        while (i < this.fDuplicates.length) {
            if (!this.fDuplicates[i].isMethodBody()) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public boolean getReplaceDuplicates() {
        return this.fReplaceDuplicates;
    }

    public void setReplaceDuplicates(boolean replace) {
        this.fReplaceDuplicates = replace;
    }

    public void setGenerateJavadoc(boolean generate) {
        this.fGenerateJavadoc = generate;
    }

    public boolean getGenerateJavadoc() {
        return this.fGenerateJavadoc;
    }

    private void initializeParameterInfos() {
        IVariableBinding[] arguments = this.fAnalyzer.getArguments();
        this.fParameterInfos = new ArrayList<ParameterInfo>(arguments.length);
        BodyDeclaration root = this.fAnalyzer.getEnclosingBodyDeclaration();
        ParameterInfo vararg = null;
        int i = 0;
        while (i < arguments.length) {
            IVariableBinding argument = arguments[i];
            if (argument != null) {
                VariableDeclaration declaration = ASTNodes.findVariableDeclaration(argument, (ASTNode)root);
                boolean isVarargs = declaration instanceof SingleVariableDeclaration ? ((SingleVariableDeclaration)declaration).isVarargs() : false;
                ParameterInfo info = new ParameterInfo(argument, this.getType(declaration, isVarargs), argument.getName(), i);
                if (isVarargs) {
                    vararg = info;
                } else {
                    this.fParameterInfos.add(info);
                }
            }
            ++i;
        }
        if (vararg != null) {
            this.fParameterInfos.add(vararg);
        }
    }

    private void initializeUsedNames() {
        this.fUsedNames = UsedNamesCollector.perform(this.fAnalyzer.getSelectedNodes());
        for (ParameterInfo parameter : this.fParameterInfos) {
            this.fUsedNames.remove(parameter.getOldName());
        }
    }

    private void initializeDuplicates() {
        BodyDeclaration start = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (!(start instanceof AbstractTypeDeclaration)) {
            start = start.getParent();
        }
        this.fDuplicates = SnippetFinder.perform((ASTNode)start, this.fAnalyzer.getSelectedNodes());
        this.fReplaceDuplicates = this.fDuplicates.length > 0 && !this.fAnalyzer.isLiteralNodeSelected();
    }

    private void initializeDestinations() {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        BodyDeclaration decl = this.fAnalyzer.getEnclosingBodyDeclaration();
        ASTNode current = this.getNextParent((ASTNode)decl);
        result.add(current);
        if (decl instanceof MethodDeclaration || decl instanceof Initializer || decl instanceof FieldDeclaration) {
            ITypeBinding binding = ASTNodes.getEnclosingType(current);
            ASTNode next = this.getNextParent(current);
            while (next != null && binding != null && binding.isNested()) {
                result.add(next);
                current = next;
                binding = ASTNodes.getEnclosingType(current);
                next = this.getNextParent(next);
            }
        }
        this.fDestinations = result.toArray(new ASTNode[result.size()]);
        this.fDestination = this.fDestinations[this.fDestinationIndex];
    }

    private ASTNode getNextParent(ASTNode node) {
        while ((node = node.getParent()) != null && !(node instanceof AbstractTypeDeclaration) && !(node instanceof AnonymousClassDeclaration)) {
        }
        return node;
    }

    private RefactoringStatus mergeTextSelectionStatus(RefactoringStatus status) {
        status.addFatalError(RefactoringCoreMessages.ExtractMethodRefactoring_no_set_of_statements);
        return status;
    }

    private String getType(VariableDeclaration declaration, boolean isVarargs) {
        String type = ASTNodes.asString((ASTNode)ASTNodeFactory.newType(declaration.getAST(), declaration, this.fImportRewriter, new ContextSensitiveImportRewriteContext((ASTNode)declaration, this.fImportRewriter)));
        if (isVarargs) {
            return String.valueOf(type) + "...";
        }
        return type;
    }

    private ASTNode[] createCallNodes(SnippetFinder.Match duplicate, int modifiers) {
        MethodInvocation call;
        ArrayList<Object> result = new ArrayList<Object>(2);
        IVariableBinding[] locals = this.fAnalyzer.getCallerLocals();
        int i = 0;
        while (i < locals.length) {
            result.add(this.createDeclaration(locals[i], null));
            ++i;
        }
        MethodInvocation invocation = this.fAST.newMethodInvocation();
        invocation.setName(this.fAST.newSimpleName(this.fMethodName));
        ASTNode typeNode = ASTResolving.findParentType((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        RefactoringStatus status = new RefactoringStatus();
        while (this.fDestination != typeNode) {
            this.fAnalyzer.checkInput(status, this.fMethodName, typeNode);
            if (!status.isOK()) {
                SimpleName destinationTypeName = this.fAST.newSimpleName(ASTNodes.getEnclosingType(this.fDestination).getName());
                if ((modifiers & 8) == 0) {
                    ThisExpression thisExpression = this.fAST.newThisExpression();
                    thisExpression.setQualifier((Name)destinationTypeName);
                    invocation.setExpression((Expression)thisExpression);
                    break;
                }
                invocation.setExpression((Expression)destinationTypeName);
                break;
            }
            typeNode = typeNode.getParent();
        }
        List arguments = invocation.arguments();
        int i2 = 0;
        while (i2 < this.fParameterInfos.size()) {
            ParameterInfo parameter = this.fParameterInfos.get(i2);
            arguments.add(ASTNodeFactory.newName(this.fAST, this.getMappedName(duplicate, parameter)));
            ++i2;
        }
        if (this.fLinkedProposalModel != null) {
            LinkedProposalPositionGroup nameGroup = this.fLinkedProposalModel.getPositionGroup(KEY_NAME, true);
            nameGroup.addPosition(this.fRewriter.track((ASTNode)invocation.getName()), false);
        }
        int returnKind = this.fAnalyzer.getReturnKind();
        switch (returnKind) {
            case 2: {
                IVariableBinding binding = this.fAnalyzer.getReturnLocal();
                if (binding != null) {
                    VariableDeclarationStatement decl = this.createDeclaration(this.getMappedBinding(duplicate, binding), (Expression)invocation);
                    call = decl;
                    break;
                }
                Assignment assignment = this.fAST.newAssignment();
                assignment.setLeftHandSide((Expression)ASTNodeFactory.newName(this.fAST, this.getMappedBinding(duplicate, this.fAnalyzer.getReturnValue()).getName()));
                assignment.setRightHandSide((Expression)invocation);
                call = assignment;
                break;
            }
            case 4: {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)invocation);
                call = rs;
                break;
            }
            default: {
                call = invocation;
            }
        }
        if (call instanceof Expression && !this.fAnalyzer.isExpressionSelected()) {
            call = this.fAST.newExpressionStatement((Expression)call);
        }
        result.add(call);
        if (returnKind == 3 && !this.fAnalyzer.isLastStatementSelected()) {
            result.add(this.fAST.newReturnStatement());
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    private IVariableBinding getMappedBinding(SnippetFinder.Match duplicate, IVariableBinding org) {
        if (duplicate == null) {
            return org;
        }
        return duplicate.getMappedBinding(org);
    }

    private String getMappedName(SnippetFinder.Match duplicate, ParameterInfo paramter) {
        if (duplicate == null) {
            return paramter.getOldName();
        }
        return duplicate.getMappedName(paramter.getOldBinding()).getIdentifier();
    }

    private void replaceDuplicates(CompilationUnitChange result, int modifiers) {
        int numberOf = this.getNumberOfDuplicates();
        if (numberOf == 0 || !this.fReplaceDuplicates) {
            return;
        }
        String label = null;
        label = numberOf == 1 ? Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_single, BasicElementLabels.getJavaElementName(this.fMethodName)) : Messages.format(RefactoringCoreMessages.ExtractMethodRefactoring_duplicates_multi, BasicElementLabels.getJavaElementName(this.fMethodName));
        TextEditGroup description = new TextEditGroup(label);
        result.addTextEditGroup(description);
        int d = 0;
        while (d < this.fDuplicates.length) {
            SnippetFinder.Match duplicate = this.fDuplicates[d];
            if (!duplicate.isMethodBody() && this.isDestinationReachable(duplicate.getEnclosingMethod())) {
                ASTNode[] callNodes = this.createCallNodes(duplicate, modifiers);
                ASTNode[] duplicateNodes = duplicate.getNodes();
                int i = 0;
                while (i < duplicateNodes.length) {
                    ASTNode parent = duplicateNodes[i].getParent();
                    if (parent instanceof ParenthesizedExpression) {
                        duplicateNodes[i] = parent;
                    }
                    ++i;
                }
                new StatementRewrite(this.fRewriter, duplicateNodes).replace(callNodes, description);
            }
            ++d;
        }
    }

    private boolean isDestinationReachable(MethodDeclaration methodDeclaration) {
        MethodDeclaration start = methodDeclaration;
        while (start != null && start != this.fDestination) {
            start = start.getParent();
        }
        return start == this.fDestination;
    }

    private MethodDeclaration createNewMethod(ASTNode[] selectedNodes, String lineDelimiter, TextEditGroup substitute) throws CoreException {
        AbstractTypeDeclaration enclosingType;
        String string;
        MethodDeclaration result = this.createNewMethodDeclaration();
        result.setBody(this.createMethodBody(selectedNodes, substitute, result.getModifiers()));
        if (this.fGenerateJavadoc && (string = CodeGeneration.getMethodComment(this.fCUnit, (enclosingType = (AbstractTypeDeclaration)ASTNodes.getParent((ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration(), AbstractTypeDeclaration.class)).getName().getIdentifier(), result, null, lineDelimiter)) != null) {
            Javadoc javadoc = (Javadoc)this.fRewriter.createStringPlaceholder(string, 29);
            result.setJavadoc(javadoc);
        }
        return result;
    }

    private MethodDeclaration createNewMethodDeclaration() {
        MethodDeclaration result = this.fAST.newMethodDeclaration();
        int modifiers = this.fVisibility;
        BodyDeclaration enclosingBodyDeclaration = this.fAnalyzer.getEnclosingBodyDeclaration();
        while (enclosingBodyDeclaration != null && enclosingBodyDeclaration.getParent() != this.fDestination) {
            enclosingBodyDeclaration = enclosingBodyDeclaration.getParent();
        }
        if (enclosingBodyDeclaration instanceof BodyDeclaration) {
            boolean shouldBeStatic;
            int enclosingModifiers = enclosingBodyDeclaration.getModifiers();
            boolean bl = shouldBeStatic = Modifier.isStatic((int)enclosingModifiers) || enclosingBodyDeclaration instanceof EnumDeclaration || this.fAnalyzer.getForceStatic();
            if (shouldBeStatic) {
                modifiers |= 8;
            }
        }
        ITypeBinding[] typeVariables = this.computeLocalTypeVariables();
        List typeParameters = result.typeParameters();
        int i = 0;
        while (i < typeVariables.length) {
            TypeParameter parameter = this.fAST.newTypeParameter();
            parameter.setName(this.fAST.newSimpleName(typeVariables[i].getName()));
            ITypeBinding[] bounds = typeVariables[i].getTypeBounds();
            int j = 0;
            while (j < bounds.length) {
                if (!"java.lang.Object".equals(bounds[j].getQualifiedName())) {
                    parameter.typeBounds().add(this.fImportRewriter.addImport(bounds[j], this.fAST));
                }
                ++j;
            }
            typeParameters.add(parameter);
            ++i;
        }
        result.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, modifiers));
        result.setReturnType2((Type)ASTNode.copySubtree((AST)this.fAST, (ASTNode)this.fAnalyzer.getReturnType()));
        result.setName(this.fAST.newSimpleName(this.fMethodName));
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((ASTNode)enclosingBodyDeclaration, this.fImportRewriter);
        List parameters = result.parameters();
        int i2 = 0;
        while (i2 < this.fParameterInfos.size()) {
            ParameterInfo info = this.fParameterInfos.get(i2);
            VariableDeclaration infoDecl = this.getVariableDeclaration(info);
            SingleVariableDeclaration parameter = this.fAST.newSingleVariableDeclaration();
            parameter.modifiers().addAll(ASTNodeFactory.newModifiers(this.fAST, ASTNodes.getModifiers(infoDecl)));
            parameter.setType(ASTNodeFactory.newType(this.fAST, infoDecl, this.fImportRewriter, context));
            parameter.setName(this.fAST.newSimpleName(info.getNewName()));
            parameter.setVarargs(info.isNewVarargs());
            parameters.add(parameter);
            ++i2;
        }
        List exceptions = result.thrownExceptions();
        ITypeBinding[] exceptionTypes = this.fAnalyzer.getExceptions(this.fThrowRuntimeExceptions);
        int i3 = 0;
        while (i3 < exceptionTypes.length) {
            ITypeBinding exceptionType = exceptionTypes[i3];
            exceptions.add(ASTNodeFactory.newName(this.fAST, this.fImportRewriter.addImport(exceptionType, (ImportRewrite.ImportRewriteContext)context)));
            ++i3;
        }
        return result;
    }

    private ITypeBinding[] computeLocalTypeVariables() {
        ArrayList<ITypeBinding> result = new ArrayList<ITypeBinding>(Arrays.asList(this.fAnalyzer.getTypeVariables()));
        int i = 0;
        while (i < this.fParameterInfos.size()) {
            ParameterInfo info = this.fParameterInfos.get(i);
            this.processVariable(result, info.getOldBinding());
            ++i;
        }
        IVariableBinding[] methodLocals = this.fAnalyzer.getMethodLocals();
        int i2 = 0;
        while (i2 < methodLocals.length) {
            this.processVariable(result, methodLocals[i2]);
            ++i2;
        }
        return result.toArray(new ITypeBinding[result.size()]);
    }

    private void processVariable(List<ITypeBinding> result, IVariableBinding variable) {
        if (variable == null) {
            return;
        }
        ITypeBinding binding = variable.getType();
        if (binding != null && binding.isParameterizedType()) {
            ITypeBinding[] typeArgs = binding.getTypeArguments();
            int args = 0;
            while (args < typeArgs.length) {
                ASTNode decl;
                ITypeBinding arg = typeArgs[args];
                if (arg.isTypeVariable() && !result.contains(arg) && (decl = this.fRoot.findDeclaringNode((IBinding)arg)) != null && decl.getParent() instanceof MethodDeclaration) {
                    result.add(arg);
                }
                ++args;
            }
        }
    }

    private Block createMethodBody(ASTNode[] selectedNodes, TextEditGroup substitute, int modifiers) {
        Block result = this.fAST.newBlock();
        ListRewrite statements = this.fRewriter.getListRewrite((ASTNode)result, Block.STATEMENTS_PROPERTY);
        IVariableBinding[] methodLocals = this.fAnalyzer.getMethodLocals();
        int i = 0;
        while (i < methodLocals.length) {
            if (methodLocals[i] != null) {
                result.statements().add(this.createDeclaration(methodLocals[i], null));
            }
            ++i;
        }
        for (ParameterInfo parameter : this.fParameterInfos) {
            if (!parameter.isRenamed()) continue;
            int n = 0;
            while (n < selectedNodes.length) {
                SimpleName[] oldNames = LinkedNodeFinder.findByBinding(selectedNodes[n], (IBinding)parameter.getOldBinding());
                int i2 = 0;
                while (i2 < oldNames.length) {
                    this.fRewriter.replace((ASTNode)oldNames[i2], (ASTNode)this.fAST.newSimpleName(parameter.getNewName()), null);
                    ++i2;
                }
                ++n;
            }
        }
        boolean extractsExpression = this.fAnalyzer.isExpressionSelected();
        ASTNode[] callNodes = this.createCallNodes(null, modifiers);
        ASTNode replacementNode = callNodes.length == 1 ? callNodes[0] : this.fRewriter.createGroupNode(callNodes);
        if (extractsExpression) {
            ITypeBinding binding = this.fAnalyzer.getExpressionBinding();
            if (!(binding == null || binding.isPrimitive() && "void".equals(binding.getName()))) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fRewriter.createMoveTarget((ASTNode)(selectedNodes[0] instanceof ParenthesizedExpression ? ((ParenthesizedExpression)selectedNodes[0]).getExpression() : selectedNodes[0])));
                statements.insertLast((ASTNode)rs, null);
            } else {
                ExpressionStatement st = this.fAST.newExpressionStatement((Expression)this.fRewriter.createMoveTarget(selectedNodes[0]));
                statements.insertLast((ASTNode)st, null);
            }
            this.fRewriter.replace(selectedNodes[0].getParent() instanceof ParenthesizedExpression ? selectedNodes[0].getParent() : selectedNodes[0], replacementNode, substitute);
        } else {
            if (selectedNodes.length == 1) {
                statements.insertLast(this.fRewriter.createMoveTarget(selectedNodes[0]), substitute);
                this.fRewriter.replace(selectedNodes[0], replacementNode, substitute);
            } else {
                ListRewrite source = this.fRewriter.getListRewrite(selectedNodes[0].getParent(), (ChildListPropertyDescriptor)selectedNodes[0].getLocationInParent());
                ASTNode toMove = source.createMoveTarget(selectedNodes[0], selectedNodes[selectedNodes.length - 1], replacementNode, substitute);
                statements.insertLast(toMove, substitute);
            }
            IVariableBinding returnValue = this.fAnalyzer.getReturnValue();
            if (returnValue != null) {
                ReturnStatement rs = this.fAST.newReturnStatement();
                rs.setExpression((Expression)this.fAST.newSimpleName(this.getName(returnValue)));
                statements.insertLast((ASTNode)rs, null);
            }
        }
        return result;
    }

    private String getName(IVariableBinding binding) {
        for (ParameterInfo info : this.fParameterInfos) {
            if (!Bindings.equals((IBinding)binding, (IBinding)info.getOldBinding())) continue;
            return info.getNewName();
        }
        return binding.getName();
    }

    private VariableDeclaration getVariableDeclaration(ParameterInfo parameter) {
        return ASTNodes.findVariableDeclaration(parameter.getOldBinding(), (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
    }

    private VariableDeclarationStatement createDeclaration(IVariableBinding binding, Expression intilizer) {
        VariableDeclaration original = ASTNodes.findVariableDeclaration(binding, (ASTNode)this.fAnalyzer.getEnclosingBodyDeclaration());
        VariableDeclarationFragment fragment = this.fAST.newVariableDeclarationFragment();
        fragment.setName((SimpleName)ASTNode.copySubtree((AST)this.fAST, (ASTNode)original.getName()));
        fragment.setInitializer(intilizer);
        VariableDeclarationStatement result = this.fAST.newVariableDeclarationStatement(fragment);
        result.modifiers().addAll(ASTNode.copySubtrees((AST)this.fAST, ASTNodes.getModifiers(original)));
        result.setType(ASTNodeFactory.newType(this.fAST, original, this.fImportRewriter, new ContextSensitiveImportRewriteContext((ASTNode)original, this.fImportRewriter)));
        return result;
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCUnit;
    }

    private RefactoringStatus initialize(JavaRefactoringArguments arguments) {
        String replace;
        String name;
        String selection = arguments.getAttribute("selection");
        if (selection == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "selection"));
        }
        int offset = -1;
        int length = -1;
        StringTokenizer tokenizer = new StringTokenizer(selection);
        if (tokenizer.hasMoreTokens()) {
            offset = Integer.valueOf(tokenizer.nextToken());
        }
        if (tokenizer.hasMoreTokens()) {
            length = Integer.valueOf(tokenizer.nextToken());
        }
        if (offset < 0 || length < 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_illegal_argument, new Object[]{selection, "selection"}));
        }
        this.fSelectionStart = offset;
        this.fSelectionLength = length;
        String handle = arguments.getAttribute("input");
        if (handle == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
        }
        IJavaElement element = JavaRefactoringDescriptorUtil.handleToElement(arguments.getProject(), handle, false);
        if (element == null || !element.exists() || element.getElementType() != 5) {
            return JavaRefactoringDescriptorUtil.createInputFatalStatus(element, this.getName(), "org.eclipse.jdt.ui.extract.method");
        }
        this.fCUnit = (ICompilationUnit)element;
        String visibility = arguments.getAttribute(ATTRIBUTE_VISIBILITY);
        if (visibility != null && visibility.length() != 0) {
            int flag = 0;
            try {
                flag = Integer.parseInt(visibility);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_VISIBILITY));
            }
            this.fVisibility = flag;
        }
        if ((name = arguments.getAttribute(KEY_NAME)) == null || name.length() == 0) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, KEY_NAME));
        }
        this.fMethodName = name;
        String destination = arguments.getAttribute(ATTRIBUTE_DESTINATION);
        if (destination != null && destination.length() == 0) {
            int index = 0;
            try {
                index = Integer.parseInt(destination);
            }
            catch (NumberFormatException numberFormatException) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_DESTINATION));
            }
            this.fDestinationIndex = index;
        }
        if ((replace = arguments.getAttribute(ATTRIBUTE_REPLACE)) == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_REPLACE));
        }
        this.fReplaceDuplicates = Boolean.valueOf(replace);
        String comments = arguments.getAttribute(ATTRIBUTE_COMMENTS);
        if (comments == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_COMMENTS));
        }
        this.fGenerateJavadoc = Boolean.valueOf(comments);
        String exceptions = arguments.getAttribute(ATTRIBUTE_EXCEPTIONS);
        if (exceptions == null) {
            return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_EXCEPTIONS));
        }
        this.fThrowRuntimeExceptions = Boolean.valueOf(exceptions);
        return new RefactoringStatus();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class UsedNamesCollector
    extends ASTVisitor {
        private Set<String> result = new HashSet<String>();
        private Set<SimpleName> fIgnore = new HashSet<SimpleName>();

        private UsedNamesCollector() {
        }

        public static Set<String> perform(ASTNode[] nodes) {
            UsedNamesCollector collector = new UsedNamesCollector();
            int i = 0;
            while (i < nodes.length) {
                nodes[i].accept((ASTVisitor)collector);
                ++i;
            }
            return collector.result;
        }

        public boolean visit(FieldAccess node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(FieldAccess node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(MethodInvocation node) {
            Expression exp = node.getExpression();
            if (exp != null) {
                this.fIgnore.add(node.getName());
            }
            return true;
        }

        public void endVisit(MethodInvocation node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(QualifiedName node) {
            this.fIgnore.add(node.getName());
            return true;
        }

        public void endVisit(QualifiedName node) {
            this.fIgnore.remove(node.getName());
        }

        public boolean visit(SimpleName node) {
            if (!this.fIgnore.contains(node)) {
                this.result.add(node.getIdentifier());
            }
            return true;
        }

        public boolean visit(TypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public boolean visit(AnnotationTypeDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        public boolean visit(EnumDeclaration node) {
            return this.visitType((AbstractTypeDeclaration)node);
        }

        private boolean visitType(AbstractTypeDeclaration node) {
            this.result.add(node.getName().getIdentifier());
            return false;
        }
    }
}

