/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.outline.impl;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.util.DisplayRunHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutlineTreeState {
    private static final Logger LOG = Logger.getLogger(OutlineTreeState.class);
    private Set<IOutlineNode> expandedNodes;
    private Set<IOutlineNode> selectedNodes;

    public OutlineTreeState(TreeViewer treeViewer) {
        this.expandedNodes = Collections.unmodifiableSet(this.getExpandedNodes(treeViewer));
        this.selectedNodes = Collections.unmodifiableSet(this.getSelectedNodes(treeViewer));
    }

    public OutlineTreeState() {
        this.expandedNodes = Sets.newHashSet();
        this.selectedNodes = Sets.newHashSet();
    }

    protected Set<IOutlineNode> getExpandedNodes(final TreeViewer treeViewer) {
        final HashSet expandedNodes = Sets.newHashSet();
        DisplayRunHelper.runSyncInDisplayThread(new Runnable(){

            public void run() {
                if (!treeViewer.getTree().isDisposed()) {
                    Object[] expandedElements;
                    Object[] objectArray = expandedElements = treeViewer.getExpandedElements();
                    int n = expandedElements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object expandedElement = objectArray[n2];
                        if (!(expandedElement instanceof IOutlineNode)) {
                            LOG.error((Object)("Content outline contains illegal node " + expandedElement));
                        } else {
                            expandedNodes.add((IOutlineNode)expandedElement);
                        }
                        ++n2;
                    }
                }
            }
        });
        return expandedNodes;
    }

    protected Set<IOutlineNode> getSelectedNodes(final TreeViewer treeViewer) {
        DisplayRunHelper.runSyncInDisplayThread(new Runnable(){

            public void run() {
                OutlineTreeState.this.selectedNodes = Sets.newHashSet();
                ISelection selection = treeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    for (Object selectedElement : (IStructuredSelection)selection) {
                        if (!(selectedElement instanceof IOutlineNode)) {
                            LOG.error((Object)("Content outline contains illegal node " + selectedElement));
                            continue;
                        }
                        OutlineTreeState.this.selectedNodes.add((IOutlineNode)selectedElement);
                    }
                }
            }
        });
        return this.selectedNodes;
    }

    public Set<IOutlineNode> getSelectedNodes() {
        return this.selectedNodes;
    }

    public Set<IOutlineNode> getExpandedNodes() {
        return this.expandedNodes;
    }

    public boolean addExpandedNode(IOutlineNode node) {
        if (this.expandedNodes.contains(node)) {
            return false;
        }
        return this.expandedNodes.add(node);
    }

    public boolean addSelectedNode(IOutlineNode node) {
        if (this.selectedNodes.contains(node)) {
            return false;
        }
        return this.selectedNodes.add(node);
    }
}

