/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.occurrences;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.Map;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.actions.AbstractToggleActionContributor;
import org.eclipse.xtext.ui.editor.actions.IActionContributor;
import org.eclipse.xtext.ui.editor.occurrences.Messages;
import org.eclipse.xtext.ui.editor.occurrences.OccurrenceMarker;
import org.eclipse.xtext.ui.internal.XtextPluginImages;

@Singleton
public class MarkOccurrenceActionContributor
extends AbstractToggleActionContributor
implements IActionContributor {
    public static final String EDITOR_MARK_OCCURRENCES = "markOccurrences";
    @Inject
    private Provider<OccurrenceMarker> occurrenceMarkerProvider;
    private Map<XtextEditor, OccurrenceMarker> editor2marker = Maps.newHashMap();

    protected Action getAction() {
        Action action = super.getAction();
        return action;
    }

    public void contributeActions(XtextEditor editor) {
        OccurrenceMarker occurrenceMarker = this.editor2marker.get((Object)editor);
        if (occurrenceMarker == null) {
            editor.setAction(this.getAction().getId(), (IAction)this.getAction());
            IToolBarManager toolBarManager = editor.getEditorSite().getActionBars().getToolBarManager();
            if (toolBarManager.find(this.getAction().getId()) == null) {
                toolBarManager.add((IAction)this.getAction());
            }
            occurrenceMarker = (OccurrenceMarker)this.occurrenceMarkerProvider.get();
            occurrenceMarker.connect(editor, this.isPropertySet());
            this.editor2marker.put(editor, occurrenceMarker);
        }
    }

    public void editorDisposed(XtextEditor editor) {
        OccurrenceMarker occurrenceMarker = this.editor2marker.get((Object)editor);
        if (occurrenceMarker != null) {
            occurrenceMarker.disconnect(editor);
            this.editor2marker.remove((Object)editor);
        }
    }

    public String getPreferenceKey() {
        return EDITOR_MARK_OCCURRENCES;
    }

    protected void stateChanged(boolean newState) {
        for (OccurrenceMarker occurrenceMarker : this.editor2marker.values()) {
            occurrenceMarker.setMarkOccurrences(newState);
        }
    }

    protected void configureAction(Action action) {
        action.setText(Messages.MarkOccurrenceActionContributor_text);
        action.setDescription(Messages.MarkOccurrenceActionContributor_description);
        action.setToolTipText(Messages.MarkOccurrenceActionContributor_toolTipText);
        action.setImageDescriptor(XtextPluginImages.DESC_MARK_OCCURRENCES);
        action.setDisabledImageDescriptor(XtextPluginImages.DESC_MARK_OCCURRENCES_DISABLED);
        this.addPropertyChangeListener();
    }
}

