/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.reports.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.stem.core.common.Identifiable;
import org.eclipse.stem.core.graph.DynamicLabel;
import org.eclipse.stem.core.graph.DynamicNodeLabel;
import org.eclipse.stem.core.graph.Graph;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.graph.NodeLabel;
import org.eclipse.stem.core.model.Decorator;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.RelativeValueProviderAdapterFactory;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryExtendedListener;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProvider;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapter;
import org.eclipse.stem.definitions.adapters.relativevalue.history.RelativeValueHistoryProviderAdapterFactory;
import org.eclipse.stem.diseasemodels.standard.DiseaseModel;
import org.eclipse.stem.diseasemodels.standard.DiseaseModelLabel;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.jobs.simulation.ISimulationListener;
import org.eclipse.stem.jobs.simulation.SimulationEvent;
import org.eclipse.stem.jobs.simulation.SimulationManager;
import org.eclipse.stem.jobs.simulation.SimulationState;
import org.eclipse.stem.populationmodels.standard.StandardPopulationModelLabel;
import org.eclipse.stem.ui.reports.views.ReportControl;
import org.eclipse.stem.ui.reports.views.TimeSeriesCanvas;
import org.eclipse.stem.ui.widgets.DecoratorSelector;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RelativeValueHistoryPlotter
extends ReportControl
implements RelativeValueHistoryExtendedListener,
ISimulationListener {
    TimeSeriesCanvas timeSeriesCanvas;
    DecoratorSelector decoratorSelector;
    List<IItemPropertyDescriptor> selectedProperties;
    boolean plotUpdateScheduled = false;
    private final PropertySieve propertySieve = new PropertySieve(){

        @Override
        public List<ItemPropertyDescriptor> sieve(DynamicLabel dynamicLabel) {
            ArrayList<ItemPropertyDescriptor> retValue = new ArrayList<ItemPropertyDescriptor>();
            RelativeValueProviderAdapter rvp = (RelativeValueProviderAdapter)RelativeValueProviderAdapterFactory.INSTANCE.adapt((Notifier)dynamicLabel, RelativeValueProvider.class);
            if (rvp != null) {
                rvp.setTarget((Notifier)dynamicLabel);
                for (Object element : rvp.getProperties()) {
                    ItemPropertyDescriptor property = (ItemPropertyDescriptor)element;
                    retValue.add(property);
                }
            }
            return retValue;
        }
    };

    public RelativeValueHistoryPlotter(Composite parent) {
        super(parent, 0);
        this.createContents();
    }

    private void createContents() {
        this.setLayout((Layout)new FormLayout());
        this.identifiableTitle = new Label((Composite)this, 0);
        this.timeSeriesCanvas = new TimeSeriesCanvas(this);
        this.decoratorSelector = new DecoratorSelector((Composite)this, 0, true);
        this.removeButton = new Button((Composite)this, 0);
        this.removeButton.setText("remove");
        FormData titleFormData = new FormData();
        this.identifiableTitle.setLayoutData((Object)titleFormData);
        titleFormData.top = new FormAttachment(0, 0);
        titleFormData.left = new FormAttachment(0, 0);
        titleFormData.right = new FormAttachment(100, 0);
        FormData chartFormData = new FormData();
        this.timeSeriesCanvas.setLayoutData(chartFormData);
        chartFormData.top = new FormAttachment((Control)this.identifiableTitle, 0);
        chartFormData.bottom = new FormAttachment((Control)this.decoratorSelector, 0);
        chartFormData.left = new FormAttachment(0, 0);
        chartFormData.right = new FormAttachment(100, 0);
        FormData decoratorSelectorFormData = new FormData();
        decoratorSelectorFormData.bottom = new FormAttachment(100, 0);
        decoratorSelectorFormData.left = new FormAttachment(0, 0);
        decoratorSelectorFormData.right = new FormAttachment(30, 0);
        this.decoratorSelector.setLayoutData((Object)decoratorSelectorFormData);
        FormData removeButtonFormData = new FormData();
        removeButtonFormData.bottom = new FormAttachment(100, 0);
        removeButtonFormData.left = new FormAttachment((Control)this.decoratorSelector, 0);
        removeButtonFormData.right = new FormAttachment(60, 0);
        this.removeButton.setLayoutData((Object)removeButtonFormData);
        this.decoratorSelector.addDecoratorSelectionListener(new DecoratorSelector.DecoratorSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void decoratorSelected(DecoratorSelector.DecoratorSelectionEvent decoratorSelectionEvent) {
                RelativeValueHistoryPlotter.this.selectedDecorator = decoratorSelectionEvent.getDecorator();
                if (RelativeValueHistoryPlotter.this.selectedDecorator != null) {
                    TimeSeriesCanvas timeSeriesCanvas = RelativeValueHistoryPlotter.this.timeSeriesCanvas;
                    synchronized (timeSeriesCanvas) {
                        String selectedPopId = decoratorSelectionEvent.getId();
                        List allLabels = (List)RelativeValueHistoryPlotter.this.decoratorToLabelsMap.get(RelativeValueHistoryPlotter.this.selectedDecorator);
                        if (allLabels != null) {
                            for (DynamicLabel lab : allLabels) {
                                if (lab instanceof DiseaseModelLabel && ((DiseaseModelLabel)lab).getPopulationModelLabel().getPopulationIdentifier().equals(selectedPopId)) {
                                    RelativeValueHistoryPlotter.this.selectedDynamicLabel = lab;
                                    break;
                                }
                                if (!(lab instanceof StandardPopulationModelLabel) || !((StandardPopulationModelLabel)lab).getPopulationIdentifier().equals(selectedPopId)) continue;
                                RelativeValueHistoryPlotter.this.selectedDynamicLabel = lab;
                                break;
                            }
                        }
                        if (RelativeValueHistoryPlotter.this.selectedDynamicLabel != null) {
                            RelativeValueHistoryPlotter.this.switchToRVHP((RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)RelativeValueHistoryPlotter.this.selectedDynamicLabel, RelativeValueHistoryProvider.class));
                        }
                        RelativeValueHistoryPlotter.this.selectedProperties = RelativeValueHistoryPlotter.this.getPropertiesToDisplay(RelativeValueHistoryPlotter.this.selectedDecorator, selectedPopId);
                        RelativeValueHistoryPlotter.this.timeSeriesCanvas.setDataSourceAndRedraw(RelativeValueHistoryPlotter.this.rvhp, RelativeValueHistoryPlotter.this.selectedProperties);
                    }
                }
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RelativeValueHistoryPlotter.this.fireRemoveEvent(RelativeValueHistoryPlotter.this.identifiable);
                RelativeValueHistoryPlotter.this.remove();
            }
        });
    }

    @Override
    public void remove() {
        this.removeListeners.clear();
        this.switchToRVHP(null);
        this.relativeValueHistoryExtended(null);
        this.identifiableTitle.setText("");
        this.decoratorSelector.setDecorators(Collections.EMPTY_LIST);
        this.dispose();
    }

    @Override
    public void setIdentifiable(Identifiable identifiable) {
        if (this.identifiable == identifiable) {
            return;
        }
        this.identifiable = identifiable;
        ArrayList<Decorator> decorators = new ArrayList<Decorator>();
        this.decoratorToLabelsMap = new HashMap();
        this.identifiableTitle.setText(identifiable.getDublinCore().getTitle());
        if (identifiable instanceof Node) {
            Node node = (Node)identifiable;
            for (NodeLabel nodeLabel : node.getLabels()) {
                Decorator decorator;
                if (!(nodeLabel instanceof DynamicNodeLabel)) continue;
                DynamicNodeLabel dynamicNodeLabel = (DynamicNodeLabel)nodeLabel;
                RelativeValueHistoryProviderAdapter rvhp = (RelativeValueHistoryProviderAdapter)RelativeValueHistoryProviderAdapterFactory.INSTANCE.adapt((Notifier)nodeLabel, RelativeValueHistoryProvider.class);
                if (rvhp == null || (decorator = dynamicNodeLabel.getDecorator()) == null) continue;
                if (this.decoratorToLabelsMap.get(decorator) != null) {
                    List list = (List)this.decoratorToLabelsMap.get(decorator);
                    list.add(dynamicNodeLabel);
                } else {
                    ArrayList<DynamicNodeLabel> newList = new ArrayList<DynamicNodeLabel>();
                    newList.add(dynamicNodeLabel);
                    this.decoratorToLabelsMap.put(decorator, newList);
                }
                if (decorators.contains(decorator)) continue;
                decorators.add(decorator);
            }
            if (decorators.size() > 0) {
                ISimulation newSimulation = SimulationManager.getManager().mapGraphToSimulation(this.getGraph(node));
                if (this.simulation != null) {
                    this.simulation.removeSimulationListener((ISimulationListener)this);
                }
                this.simulation = newSimulation;
                if (this.simulation != null) {
                    this.simulation.addSimulationListener((ISimulationListener)this);
                }
            }
        }
        this.decoratorSelector.setDecorators(decorators);
    }

    public void relativeValueHistoryExtended(RelativeValueHistoryProviderAdapter rvhp) {
        if (this.plotUpdateScheduled) {
            return;
        }
        Display display = Display.getDefault();
        if (!display.isDisposed()) {
            try {
                this.plotUpdateScheduled = true;
                display.asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block6: {
                            try {
                                if (RelativeValueHistoryPlotter.this.timeSeriesCanvas.isDisposed()) break block6;
                                TimeSeriesCanvas timeSeriesCanvas = RelativeValueHistoryPlotter.this.timeSeriesCanvas;
                                synchronized (timeSeriesCanvas) {
                                    RelativeValueHistoryPlotter.this.timeSeriesCanvas.draw();
                                }
                            }
                            finally {
                                RelativeValueHistoryPlotter.this.plotUpdateScheduled = false;
                            }
                        }
                    }
                });
            }
            catch (Exception exception) {}
        }
    }

    @Override
    protected void initializeFromSimulation(ISimulation simulation) {
        this.simulationNameLabel.setText(simulation.getName());
        this.decoratorSelector.setSimulation(simulation);
    }

    @Override
    public void refresh2() {
    }

    List<IItemPropertyDescriptor> getPropertiesToDisplay(Decorator decorator, String populationIdentifier) {
        ArrayList<IItemPropertyDescriptor> retValue = new ArrayList<IItemPropertyDescriptor>();
        if (decorator != null && !decorator.getLabelsToUpdate().isEmpty()) {
            if (decorator instanceof DiseaseModel) {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)((DiseaseModel)decorator).createDiseaseModelLabel(populationIdentifier)));
            } else {
                retValue.addAll(this.propertySieve.sieve((DynamicLabel)decorator.getLabelsToUpdate().get(0)));
            }
        }
        return retValue;
    }

    private Graph getGraph(Node node) {
        return (Graph)node.eContainer().eContainer();
    }

    public void simulationChanged(SimulationEvent event) {
        if (event.getSimulationState() == SimulationState.RESET) {
            this.timeSeriesCanvas.resetData();
        }
        if (event.getSimulationState() == SimulationState.STOPPED && this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
            this.simulation = null;
            this.switchToRVHP(null);
            this.relativeValueHistoryExtended(null);
            this.decoratorSelector.setDecorators(Collections.EMPTY_LIST);
            if (!this.isDisposed() && !this.identifiableTitle.isDisposed()) {
                this.identifiableTitle.setText("");
            }
        }
    }

    public void dispose() {
        super.dispose();
        if (this.rvhp != null) {
            this.rvhp.removeExtensionListener((RelativeValueHistoryExtendedListener)this);
        }
        if (this.simulation != null) {
            this.simulation.removeSimulationListener((ISimulationListener)this);
        }
    }

    @Override
    public Identifiable getIdentifiable() {
        return this.identifiable;
    }

    @Override
    public String getControlType() {
        return "IDENTIFIABLE_CONTROL_FACTORY";
    }

    public static interface PropertySieve {
        public List<ItemPropertyDescriptor> sieve(DynamicLabel var1);
    }
}

