/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin.rows;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.editor.IContextPart;
import org.eclipse.pde.internal.ui.editor.contentassist.TypeFieldAssistDisposer;
import org.eclipse.pde.internal.ui.editor.plugin.JavaAttributeValue;
import org.eclipse.pde.internal.ui.editor.plugin.rows.ButtonAttributeRow;
import org.eclipse.pde.internal.ui.util.PDEJavaHelperUI;
import org.eclipse.pde.internal.ui.util.TextUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ClassAttributeRow
extends ButtonAttributeRow {
    private TypeFieldAssistDisposer fTypeFieldAssistDisposer;

    public ClassAttributeRow(IContextPart part, ISchemaAttribute att) {
        super(part, att);
    }

    protected boolean isReferenceModel() {
        return !this.part.getPage().getModel().isEditable();
    }

    protected void openReference() {
        String name = TextUtil.trimNonAlphaChars(this.text.getText()).replace('$', '.');
        if ((name = PDEJavaHelperUI.createClass(name, this.getProject(), this.createJavaAttributeValue(name), true)) != null) {
            this.text.setText(name);
        }
    }

    public void createContents(Composite parent, FormToolkit toolkit, int span) {
        super.createContents(parent, toolkit, span);
        if (this.part.isEditable()) {
            this.fTypeFieldAssistDisposer = PDEJavaHelperUI.addTypeFieldAssistToText(this.text, this.getProject(), 10);
        }
    }

    protected void browse() {
        BusyIndicator.showWhile((Display)this.text.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ClassAttributeRow.this.doOpenSelectionDialog();
            }
        });
    }

    private JavaAttributeValue createJavaAttributeValue(String name) {
        IProject project = this.part.getPage().getPDEEditor().getCommonProject();
        IPluginModelBase model = (IPluginModelBase)this.part.getPage().getModel();
        return new JavaAttributeValue(project, model, this.getAttribute(), name);
    }

    private void doOpenSelectionDialog() {
        String type;
        int index;
        IResource resource = this.getPluginBase().getModel().getUnderlyingResource();
        ISchemaAttribute attr = this.getAttribute();
        String superName = attr != null ? attr.getBasedOn() : null;
        int n = index = superName != null ? superName.indexOf(58) : -1;
        if (index > 0) {
            superName = superName.substring(0, index);
        } else if (index == 0) {
            superName = superName.substring(1);
        }
        String filter = this.text.getText();
        if (filter.length() == 0 && superName != null) {
            filter = "**";
        }
        if ((type = PDEJavaHelperUI.selectType(resource, 512, filter, superName)) != null) {
            this.text.setText(type);
        }
    }

    private IPluginBase getPluginBase() {
        IBaseModel model = this.part.getPage().getPDEEditor().getAggregateModel();
        return ((IPluginModelBase)model).getPluginBase();
    }

    public void dispose() {
        super.dispose();
        if (this.fTypeFieldAssistDisposer != null) {
            this.fTypeFieldAssistDisposer.dispose();
        }
    }
}

