/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class SynchronizeVersionsWizardPage
extends WizardPage {
    public static final int USE_PLUGINS_AT_BUILD = 0;
    public static final int USE_FEATURE = 1;
    public static final int USE_PLUGINS = 2;
    private FeatureEditor fFeatureEditor;
    private Button fUsePluginsAtBuildButton;
    private Button fUseComponentButton;
    private Button fUsePluginsButton;
    private static final String PREFIX = String.valueOf(PDEPlugin.getPluginId()) + ".synchronizeVersions.";
    private static final String PROP_SYNCHRO_MODE = String.valueOf(PREFIX) + "mode";

    public SynchronizeVersionsWizardPage(FeatureEditor featureEditor) {
        super("featureJar");
        this.setTitle(PDEUIMessages.VersionSyncWizard_title);
        this.setDescription(PDEUIMessages.VersionSyncWizard_desc);
        this.fFeatureEditor = featureEditor;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group group = new Group(container, 16);
        GridData gd = new GridData(768);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(PDEUIMessages.VersionSyncWizard_group);
        this.fUsePluginsAtBuildButton = new Button((Composite)group, 16);
        this.fUsePluginsAtBuildButton.setText(PDEUIMessages.VersionSyncWizard_usePluginsAtBuild);
        gd = new GridData(768);
        this.fUsePluginsAtBuildButton.setLayoutData((Object)gd);
        this.fUsePluginsButton = new Button((Composite)group, 16);
        this.fUsePluginsButton.setText(PDEUIMessages.VersionSyncWizard_usePlugins);
        gd = new GridData(768);
        this.fUsePluginsButton.setLayoutData((Object)gd);
        this.fUseComponentButton = new Button((Composite)group, 16);
        this.fUseComponentButton.setText(PDEUIMessages.VersionSyncWizard_useComponent);
        gd = new GridData(768);
        this.fUseComponentButton.setLayoutData((Object)gd);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.loadSettings();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.feature_synchronize_versions");
    }

    private IPluginModelBase findModel(String id) {
        IPluginModelBase[] models = PluginRegistry.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            IPluginModelBase modelBase = models[i];
            if (modelBase != null && id.equals(modelBase.getPluginBase().getId())) {
                return modelBase;
            }
            ++i;
        }
        return null;
    }

    public boolean finish() {
        final int mode = this.saveSettings();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        SynchronizeVersionsWizardPage.this.runOperation(mode, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                        monitor.done();
                    }
                    catch (BadLocationException e) {
                        PDEPlugin.logException(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)PDEPlugin.getActiveWorkbenchWindow(), (IRunnableWithProgress)operation, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void forceVersion(final String targetVersion, IPluginModelBase modelBase, IProgressMonitor monitor) {
        IFile file = (IFile)modelBase.getUnderlyingResource();
        if (file == null) {
            return;
        }
        PDEModelUtility.modifyModel(new ModelModification(file){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    SynchronizeVersionsWizardPage.this.modifyVersion(((IBundlePluginModelBase)model).getBundleModel(), targetVersion);
                } else if (model instanceof IPluginModelBase) {
                    SynchronizeVersionsWizardPage.this.modifyVersion((IPluginModelBase)model, targetVersion);
                }
            }
        }, monitor);
    }

    private void modifyVersion(IBundleModel model, String targetVersion) {
        model.getBundle().setHeader("Bundle-Version", targetVersion);
    }

    private void modifyVersion(IPluginModelBase model, String version) throws CoreException {
        model.getPluginBase().setVersion(version);
    }

    private void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(PROP_SYNCHRO_MODE) != null) {
            int mode = settings.getInt(PROP_SYNCHRO_MODE);
            switch (mode) {
                case 1: {
                    this.fUseComponentButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.fUsePluginsButton.setSelection(true);
                    break;
                }
                default: {
                    this.fUsePluginsAtBuildButton.setSelection(true);
                    break;
                }
            }
        } else {
            this.fUsePluginsAtBuildButton.setSelection(true);
        }
    }

    private void runOperation(int mode, IProgressMonitor monitor) throws CoreException, BadLocationException {
        WorkspaceFeatureModel model = (WorkspaceFeatureModel)this.fFeatureEditor.getAggregateModel();
        IFeature feature = model.getFeature();
        IFeaturePlugin[] plugins = feature.getPlugins();
        int size = plugins.length;
        monitor.beginTask(PDEUIMessages.VersionSyncWizard_synchronizing, size);
        int i = 0;
        while (i < plugins.length) {
            this.synchronizeVersion(mode, feature.getVersion(), plugins[i], monitor);
            ++i;
        }
    }

    private int saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        int mode = 0;
        if (this.fUseComponentButton.getSelection()) {
            mode = 1;
        } else if (this.fUsePluginsButton.getSelection()) {
            mode = 2;
        }
        settings.put(PROP_SYNCHRO_MODE, mode);
        return mode;
    }

    private void synchronizeVersion(int mode, String featureVersion, IFeaturePlugin ref, IProgressMonitor monitor) throws CoreException, BadLocationException {
        String id = ref.getId();
        if (mode == 0) {
            if (!"0.0.0".equals(ref.getVersion())) {
                ref.setVersion("0.0.0");
            }
        } else if (mode == 2) {
            IPluginModelBase modelBase = PluginRegistry.findModel((String)id);
            if (modelBase == null) {
                return;
            }
            String baseVersion = modelBase.getPluginBase().getVersion();
            if (!ref.getVersion().equals(baseVersion)) {
                ref.setVersion(baseVersion);
            }
        } else {
            IPluginModelBase modelBase = this.findModel(id);
            if (modelBase == null) {
                return;
            }
            ref.setVersion(featureVersion);
            String baseVersion = modelBase.getPluginBase().getVersion();
            if (!featureVersion.equals(baseVersion)) {
                this.forceVersion(featureVersion, modelBase, monitor);
            }
        }
        monitor.worked(1);
    }
}

