/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.ui.views.geographic.map;

import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.stem.jobs.simulation.ISimulation;
import org.eclipse.stem.ui.adapters.color.ColorProviderAdapter;
import org.eclipse.stem.ui.views.geographic.GeographicRenderer;
import org.eclipse.stem.ui.views.geographic.map.MapCanvas;
import org.eclipse.stem.ui.views.geographic.map.StemPolygonsList;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class MapRenderer
extends GeographicRenderer
implements ISelectionChangedListener {
    private MapCanvas mapCanvas;
    private MenuManager menuManager;

    public MapRenderer(Composite parent, int style) {
        super(parent, style);
        this.setSize(-1, 100);
        FillLayout layout = new FillLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.setLayout((Layout)layout);
        this.mapCanvas = new MapCanvas(this, 0);
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.mapCanvas.setColorProvider(this.colorProviderAdapter);
        this.pack();
        this.mapCanvas.addSelectionChangedListener(this);
        this.menuManager = this.createContextMenuManager();
        this.mapCanvas.setMenu(this.menuManager.createContextMenu((Control)this));
    }

    @Override
    public void render(StemPolygonsList polygonsToRender, ISimulation simulation) {
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
        this.mapCanvas.render(polygonsToRender, simulation);
    }

    public MapCanvas getCanvas() {
        return this.mapCanvas;
    }

    @Override
    public void reset() {
        super.reset();
        this.mapCanvas.reset();
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.mapCanvas.setGainFactor(this.gainFactor);
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
    }

    @Override
    protected void toggleDrawPolygonBordersChoice() {
        super.toggleDrawPolygonBordersChoice();
        this.mapCanvas.setDrawPolygonBorders(this.drawPolygonBorders);
        this.redraw();
    }

    @Override
    protected void toggleUseLogScaling() {
        super.toggleUseLogScaling();
        this.mapCanvas.setUseLogScaling(this.useLogScaling);
    }

    public MenuManager getMenuManager() {
        return this.menuManager;
    }

    @Override
    public void setColorProviderAdapter(ColorProviderAdapter colorProvider) {
        super.setColorProviderAdapter(colorProvider);
        this.mapCanvas.setColorProvider(colorProvider);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelection(event.getSelection());
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mapCanvas.removeSelectionChangedListener(this);
    }
}

