/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.event;

import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.layout.Block;

public final class RectangleRenderEvent
extends PrimitiveRenderEvent {
    private static final long serialVersionUID = -2020892672024222905L;
    private transient Bounds _bo;
    private transient LineAttributes _lia;
    private transient Fill _ifBackground;

    public RectangleRenderEvent(Object oSource) {
        super(oSource);
    }

    public Bounds getBounds() {
        return this._bo;
    }

    public void setBounds(Bounds bo) {
        this._bo = bo;
    }

    public Fill getBackground() {
        return this._ifBackground;
    }

    public void setBackground(Fill ifBackground) {
        this._ifBackground = ifBackground;
    }

    public LineAttributes getOutline() {
        return this._lia;
    }

    public void setOutline(LineAttributes lia) {
        this._lia = lia;
    }

    public final void updateFrom(Block bl, double dScale) {
        this._lia = bl.getOutline();
        this._ifBackground = bl.getBackground();
        this._bo = goFactory.scaleBounds(bl.getBounds(), dScale);
    }

    public final PrimitiveRenderEvent copy() {
        RectangleRenderEvent rre = new RectangleRenderEvent(this.source);
        if (this._bo != null) {
            rre.setBounds(goFactory.copyOf(this._bo));
        }
        if (this._lia != null) {
            rre.setOutline(goFactory.copyOf(this._lia));
        }
        if (this._ifBackground != null) {
            rre.setBackground(goFactory.copyOf(this._ifBackground));
        }
        return rre;
    }

    public final void draw(IDeviceRenderer idr) throws ChartException {
        idr.drawRectangle(this);
    }

    public final void fill(IDeviceRenderer idr) throws ChartException {
        idr.fillRectangle(this);
    }

    public void reset() {
        this._bo = null;
        this._ifBackground = null;
        this._lia = null;
    }

    public LineAttributes getLineAttributes() {
        return this.getOutline();
    }
}

