/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.core.archive.cache;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.birt.core.archive.cache.CacheList;
import org.eclipse.birt.core.archive.cache.CacheListener;
import org.eclipse.birt.core.archive.cache.Cacheable;
import org.eclipse.birt.core.archive.cache.SystemCacheManager;

public class FileCacheManager {
    protected SystemCacheManager systemCache;
    protected ConcurrentHashMap<Object, Cacheable> caches;
    private int lockedCacheSize;
    protected CacheList freeCaches;
    private int maxCacheSize;
    private CacheListener listener;

    public FileCacheManager() {
        this(null, 0);
    }

    public FileCacheManager(int maxCacheSize) {
        this(null, maxCacheSize);
    }

    public FileCacheManager(SystemCacheManager systemCache, int maxCacheSize) {
        this.systemCache = systemCache;
        this.maxCacheSize = maxCacheSize;
        this.lockedCacheSize = 0;
        this.caches = new ConcurrentHashMap(2);
        this.freeCaches = new CacheList();
    }

    public void setCacheListener(CacheListener listener) {
        this.listener = listener;
    }

    public synchronized void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
        this.adjustFreeCaches();
    }

    public int getUsedCacheSize() {
        return this.lockedCacheSize + this.freeCaches.size();
    }

    public int getTotalUsedCacheSize() {
        return this.caches.size();
    }

    public synchronized void setSystemCacheManager(SystemCacheManager manager) {
        if (this.systemCache != null) {
            throw new IllegalArgumentException("can not set the system cache manger twice");
        }
        this.systemCache = manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void adjustFreeCaches() {
        if (this.freeCaches.size() <= 0) {
            return;
        }
        int releasedCacheSize = this.lockedCacheSize + this.freeCaches.size() - this.maxCacheSize;
        int n = releasedCacheSize = releasedCacheSize > this.freeCaches.size() ? this.freeCaches.size() : releasedCacheSize;
        if (releasedCacheSize <= 0) {
            return;
        }
        Cacheable[] removedCaches = new Cacheable[releasedCacheSize];
        int i = 0;
        while (i < releasedCacheSize) {
            Cacheable freeCache = this.freeCaches.remove();
            if (this.listener != null) {
                this.listener.onCacheRelease(freeCache);
            }
            removedCaches[i] = freeCache;
            ++i;
        }
        if (this.systemCache != null) {
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                Cacheable[] cacheableArray = removedCaches;
                int n2 = removedCaches.length;
                int n3 = 0;
                while (n3 < n2) {
                    Cacheable cache = cacheableArray[n3];
                    this.systemCache.addCache(cache);
                    ++n3;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void clear() {
        if (this.systemCache != null) {
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                this.systemCache.removeCaches(this);
                this.systemCache.increaseUsedCacheSize(-this.lockedCacheSize);
                this.systemCache.increaseUsedCacheSize(-this.freeCaches.size());
            }
        }
        this.caches.clear();
        this.lockedCacheSize = 0;
        this.freeCaches.clear();
    }

    public synchronized void touchAllCaches() {
        if (this.listener != null) {
            this.touchAllCaches(this.listener);
        }
    }

    public synchronized void touchAllCaches(CacheListener listener) {
        assert (listener != null);
        Cacheable[] entries = this.caches.values().toArray(new Cacheable[this.caches.size()]);
        Arrays.sort(entries, new Comparator<Cacheable>(){

            @Override
            public int compare(Cacheable cache0, Cacheable cache1) {
                if (cache0 == null) {
                    if (cache1 == null) {
                        return 0;
                    }
                    return -1;
                }
                if (cache1 == null) {
                    return -1;
                }
                Comparable k0 = cache0.getCacheKey();
                Comparable k1 = cache1.getCacheKey();
                return k0.compareTo(k1);
            }
        });
        Cacheable[] cacheableArray = entries;
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            Cacheable cache = cacheableArray[n2];
            if (cache != null) {
                listener.onCacheRelease(cache);
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void releaseCache(Cacheable cache) {
        assert (cache.getReferenceCount().get() > 0);
        int referenceCount = cache.getReferenceCount().decrementAndGet();
        if (referenceCount > 0) {
            return;
        }
        assert (referenceCount == 0);
        --this.lockedCacheSize;
        if (this.maxCacheSize > 0) {
            this.freeCaches.add(cache);
            this.adjustFreeCaches();
        } else {
            if (this.listener != null) {
                this.listener.onCacheRelease(cache);
            }
            if (this.systemCache == null) {
                this.caches.remove(cache.getCacheKey());
            } else {
                SystemCacheManager systemCacheManager = this.systemCache;
                synchronized (systemCacheManager) {
                    this.systemCache.addCache(cache);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Cacheable getCache(Object cacheKey) {
        Cacheable cache = this.caches.get(cacheKey);
        if (cache == null) {
            return null;
        }
        int referenceCount = cache.getReferenceCount().incrementAndGet();
        if (referenceCount > 1) {
            return cache;
        }
        if (referenceCount == 1) {
            this.freeCaches.remove(cache);
            ++this.lockedCacheSize;
            return cache;
        }
        if (referenceCount == 0) {
            assert (this.systemCache != null);
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                this.systemCache.removeCache(cache);
            }
            ++this.lockedCacheSize;
            cache.getReferenceCount().set(1);
            return cache;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addCache(Cacheable cache) {
        cache.getReferenceCount().set(1);
        Comparable cacheKey = cache.getCacheKey();
        Cacheable oldCache = this.caches.get(cacheKey);
        if (oldCache != null) {
            int referenceCount = oldCache.getReferenceCount().get();
            if (referenceCount >= 1) {
                throw new IllegalStateException("Reference count is not zero");
            }
            if (referenceCount == 0) {
                this.freeCaches.remove(oldCache);
            } else {
                assert (this.systemCache != null);
                SystemCacheManager systemCacheManager = this.systemCache;
                synchronized (systemCacheManager) {
                    this.systemCache.removeCache(oldCache);
                }
            }
        } else if (this.systemCache != null) {
            SystemCacheManager systemCacheManager = this.systemCache;
            synchronized (systemCacheManager) {
                this.systemCache.increaseUsedCacheSize(1);
            }
        }
        this.caches.put(cacheKey, cache);
        ++this.lockedCacheSize;
        if (this.maxCacheSize > 0) {
            this.adjustFreeCaches();
        }
    }
}

