/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.stem.graphsynchronizer.Activator;

public class SpeedTest {
    static boolean SENDER = true;
    static int COMM_PORT = 1111;
    static String remoteHost;
    static int[] LARGE_OBJECT_1GB;
    static int SIZE_OF_INT;

    static {
        SIZE_OF_INT = 4;
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            remoteHost = args[0];
        }
        try {
            if (!SENDER) {
                SpeedTest.setupCommunication();
            } else {
                SpeedTest.speedTest();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setupCommunication() throws IOException {
        ServerSocket serverSocket = new ServerSocket(COMM_PORT);
        SocketListenerJob acceptJob = new SocketListenerJob("Socket listener ", serverSocket);
        acceptJob.schedule();
    }

    private static void speedTest() {
        try {
            LARGE_OBJECT_1GB = new int[0x4000000 / SIZE_OF_INT];
            long now = System.currentTimeMillis();
            InetAddress otherHost = InetAddress.getByName(remoteHost);
            Socket soc = new Socket(otherHost.getHostName(), COMM_PORT);
            ObjectOutputStream oos = new ObjectOutputStream(soc.getOutputStream());
            oos.writeObject(LARGE_OBJECT_1GB);
            ObjectInputStream ois = new ObjectInputStream(soc.getInputStream());
            String mess = (String)ois.readObject();
            if (!mess.equals("OK")) {
                Activator.logInformation("Error received from " + remoteHost + ": " + mess);
            }
            long then = System.currentTimeMillis();
            Activator.logInformation("Total time:" + (then - now));
            ois.close();
            oos.close();
            soc.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static class ConnectionHandler
    extends Job {
        private Socket soc;

        public ConnectionHandler(String n) {
            super(n);
        }

        public ConnectionHandler(String n, Socket s) {
            super(n);
            this.soc = s;
            this.schedule();
        }

        protected IStatus run(IProgressMonitor monitor) {
            ObjectInputStream ois = null;
            String status = "OK";
            try {
                ois = new ObjectInputStream(this.soc.getInputStream());
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            try {
                String xmi = (String)ois.readObject();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(xmi.getBytes());
            }
            catch (Exception e) {
                e.printStackTrace();
                status = "ERROR";
            }
            try {
                ObjectOutputStream oos = new ObjectOutputStream(this.soc.getOutputStream());
                oos.writeObject(status);
                ois.close();
                oos.close();
                this.soc.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    protected static class SocketListenerJob
    extends Job {
        ServerSocket socket;

        public SocketListenerJob(String name) {
            super(name);
        }

        public SocketListenerJob(String name, ServerSocket socket) {
            super(name);
            this.socket = socket;
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                while (true) {
                    Socket s = this.socket.accept();
                    new ConnectionHandler("Accepting connection", s);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                return Status.OK_STATUS;
            }
        }
    }
}

