/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.graphsynchronizer.util;

import java.awt.Rectangle;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stem.geography.centers.CenterReader;
import org.eclipse.stem.geography.centers.PluginCenterReader;
import org.eclipse.stem.geography.names.NameReader;
import org.eclipse.stem.graphsynchronizer.Activator;
import org.osgi.framework.Bundle;

public class GlobalTileGenerator {
    static int NUM_COUNTRIES = -1;
    static String[] countriesToProcess = null;
    static Map<String, Set<String>> countryHighestIdMap = new HashMap<String, Set<String>>();
    static List<File> filtered;
    static File[] retVal;
    List<Tile> tileList = new ArrayList<Tile>();
    static Map<String, Bond> worldBondMap;
    static Map<String, Node> worldNodeMap;
    private static final String URI_TARGET = "resources/data/statistics/";
    static final String CODES_FILE = "countryCodeMap.csv";
    private static URL CODES_FILE_URI;
    static Map<String, String> countryCode2to3;
    static Map<String, String> countryCode3to2;
    static Tile[][] tileMatrix;
    static int xSize;
    static int ySize;
    static int[] dx;
    static int[] dy;
    static int[] linearLatCount;
    static int[] linearLngCount;
    static PartitionRow[] rows;

    static {
        worldBondMap = new HashMap<String, Bond>();
        worldNodeMap = new HashMap<String, Node>();
        CODES_FILE_URI = null;
        countryCode2to3 = new HashMap<String, String>();
        countryCode3to2 = new HashMap<String, String>();
        int[] nArray = new int[8];
        nArray[0] = 1;
        nArray[1] = -1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = -1;
        nArray[7] = -1;
        dx = nArray;
        int[] nArray2 = new int[8];
        nArray2[2] = 1;
        nArray2[3] = -1;
        nArray2[4] = 1;
        nArray2[5] = -1;
        nArray2[6] = -1;
        nArray2[7] = 1;
        dy = nArray2;
        linearLatCount = new int[181];
        linearLngCount = new int[361];
        rows = null;
    }

    public List<Set<String>> getParitionedNodes() {
        ArrayList<Set<String>> result = new ArrayList<Set<String>>();
        PartitionRow[] partitionRowArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            PartitionRow row = partitionRowArray[n2];
            List<Partition> partitionList = row.partitionList;
            for (Partition partition : partitionList) {
                Set<String> nodeIdSet = partition.getAllNodes();
                Activator.logInformation(">>> parition #" + partition.id + " has " + nodeIdSet.size() + " nodeIDs");
                result.add(nodeIdSet);
            }
            ++n2;
        }
        return result;
    }

    public GlobalTileGenerator(int numParitions, HashMap<String, Set<String>> nodeIdMap, Set<String[]> commonBorderIdPairsSet) {
        int period = 2;
        this.init();
        Activator.logInformation("reading world centers...");
        PluginCenterReader cr = new PluginCenterReader();
        countriesToProcess = GlobalTileGenerator.getCountryIDs(nodeIdMap);
        Activator.logInformation("got " + countriesToProcess.length + " country ids");
        countryHighestIdMap = nodeIdMap;
        this.createTiles(period);
        this.assignAllNodes(cr);
        Activator.logInformation("reading world edges");
        this.readWorldBonds(commonBorderIdPairsSet);
        Activator.logInformation("read " + worldBondMap.size() + " world edges and " + worldNodeMap.size() + " nodes");
        this.computeAllEdges();
        rows = this.getPartitions(period, numParitions);
    }

    public void init() {
        Bundle geoBundle = Platform.getBundle((String)"org.eclipse.stem.data.geography");
        Path path2 = new Path("resources/data/statistics/countryCodeMap.csv");
        CODES_FILE_URI = FileLocator.find((Bundle)geoBundle, (IPath)path2, null);
        int i = 0;
        while (i < linearLatCount.length) {
            GlobalTileGenerator.linearLatCount[i] = 0;
            ++i;
        }
        this.mapCodes();
    }

    public static String[] getCountryIDs() {
        Set<String> ids = countryCode3to2.keySet();
        Object[] retVal = ids.toArray(new String[ids.size()]);
        Arrays.sort(retVal);
        return retVal;
    }

    public static String[] getCountryIDs(HashMap<String, Set<String>> countryIdMap) {
        Set<String> ids = countryIdMap.keySet();
        Object[] retVal = ids.toArray(new String[ids.size()]);
        Arrays.sort(retVal);
        return retVal;
    }

    public PartitionRow[] getPartitions(int period, int numPartitions) {
        if (numPartitions == 0) {
            Activator.logInformation("Minimum number of partitions is one, not Zero. Resetting to one");
            numPartitions = 1;
        }
        int numRows = (int)Math.sqrt(numPartitions);
        int targetPartitionSize = worldNodeMap.size() / numPartitions;
        int previousSum = 0;
        Activator.logInformation("calculated target partition size [nodes] is " + targetPartitionSize);
        int colsPerRow = numPartitions / numRows;
        double dColsPerRow = (double)numPartitions / (double)numRows;
        int firstExtra = 0;
        if (dColsPerRow > (double)colsPerRow) {
            firstExtra = 1;
        }
        int targetRowSize = targetPartitionSize * (colsPerRow + firstExtra);
        PartitionRow[] partitionRow = new PartitionRow[numRows];
        int latMin = -90;
        int lngMin = -180;
        int latSum = 0;
        int latMax = 0;
        int i = 0;
        while (i < 180) {
            latMax = i - 90;
            if ((latSum += linearLatCount[i]) >= targetRowSize) {
                int d1 = Math.abs(latSum - targetRowSize);
                int d2 = Math.abs(previousSum - targetRowSize);
                if (d2 >= d1) break;
                --latMax;
                break;
            }
            previousSum = latSum;
            ++i;
        }
        int lngMax = 0;
        int icount = 0;
        Activator.logInformation(" numPartitions = " + numPartitions + "  adding numRows = " + numRows);
        int i2 = 0;
        while (i2 < numRows) {
            int d2;
            int d1;
            partitionRow[i2] = new PartitionRow();
            int partitionsToAdd = colsPerRow;
            if (i2 == 0) {
                partitionsToAdd += firstExtra;
            }
            Activator.logInformation(" row " + i2 + " :  adding " + partitionsToAdd + " partitions");
            linearLngCount = this.getLinearLngCount(latMin, latMax);
            lngMin = -180;
            int lngSum = 0;
            int previousLngSum = 0;
            int jj = lngMin + 180;
            while (jj < 360) {
                lngMax = jj - 180;
                if ((lngSum += linearLngCount[jj]) >= targetPartitionSize) {
                    d1 = Math.abs(lngSum - targetPartitionSize);
                    d2 = Math.abs(previousLngSum - targetRowSize);
                    if (d2 >= d1) break;
                    --lngMax;
                    break;
                }
                previousSum = lngSum;
                ++jj;
            }
            Activator.logInformation("1) latmin = " + latMin + "  latmax= " + latMax);
            int j = 0;
            while (j < partitionsToAdd) {
                Partition p = new Partition(icount, latMin, lngMin, latMax, lngMax);
                ++icount;
                partitionRow[i2].add(p);
                lngMin = lngMax;
                if (j < partitionsToAdd - 1) {
                    lngSum = 0;
                    previousLngSum = 0;
                    int jj2 = lngMin + 181;
                    while (jj2 < 360) {
                        lngMax = jj2 - 180;
                        if ((lngSum += linearLngCount[jj2]) >= targetPartitionSize) {
                            int d12 = Math.abs(lngSum - targetPartitionSize);
                            int d22 = Math.abs(previousLngSum - targetRowSize);
                            if (d22 < d12) {
                                --lngMax;
                            }
                            break;
                        }
                        previousSum = lngSum;
                        ++jj2;
                    }
                } else {
                    lngMax = 180;
                }
                ++j;
            }
            targetRowSize = targetPartitionSize * colsPerRow;
            latMin = latMax;
            if (i2 < numRows - 1) {
                latSum = 0;
                previousSum = 0;
                int ii = latMin + 91;
                while (ii < 180) {
                    latMax = ii - 90;
                    if ((latSum += linearLatCount[ii]) >= targetRowSize) {
                        d1 = Math.abs(latSum - targetRowSize);
                        d2 = Math.abs(previousSum - targetRowSize);
                        if (d2 < d1) {
                            --latMax;
                        }
                        break;
                    }
                    previousSum = latSum;
                    ++ii;
                }
            } else {
                latMax = 90;
            }
            Activator.logInformation("2) latmin = " + latMin + "  latmax= " + latMax);
            ++i2;
        }
        int ix = 0;
        int iLat = -90;
        while (iLat < 90) {
            int iy = 0;
            int iLng = -180;
            while (iLng < 180) {
                Tile tile = tileMatrix[ix][iy];
                boolean added = false;
                int i3 = 0;
                while (i3 < partitionRow.length) {
                    PartitionRow row = partitionRow[i3];
                    for (Partition p : row.partitionList) {
                        if (!(p.latMin <= (double)iLat) || !((double)iLat < p.latMax) || !(p.lngMin <= (double)iLng) || !((double)iLng < p.lngMax)) continue;
                        p.addTile(tile);
                        added = true;
                        break;
                    }
                    if (added) break;
                    ++i3;
                }
                ++iy;
                iLng += period;
            }
            ++ix;
            iLat += period;
        }
        Activator.logInformation("");
        Activator.logInformation("sizes.....");
        int avgSize = 0;
        int[] rowSum = new int[partitionRow.length];
        int i4 = 0;
        while (i4 < partitionRow.length) {
            rowSum[i4] = 0;
            ++i4;
        }
        i4 = 0;
        while (i4 < partitionRow.length) {
            PartitionRow row = partitionRow[i4];
            System.out.print("row(" + i4 + ")  ");
            for (Partition p : row.partitionList) {
                System.out.print(p.getSize() + "  ");
                avgSize += p.getSize();
                int n = i4;
                rowSum[n] = rowSum[n] + p.getSize();
            }
            Activator.logInformation("");
            ++i4;
        }
        Activator.logInformation("target partition size is " + (avgSize /= numPartitions));
        i4 = 0;
        while (i4 < partitionRow.length) {
            Activator.logInformation("row " + i4 + " sum is " + rowSum[i4]);
            ++i4;
        }
        return partitionRow;
    }

    public int[] getLinearLngCount(int latMin, int latMax) {
        int[] linearLngCount = new int[361];
        int i = 0;
        while (i < linearLngCount.length) {
            linearLngCount[i] = 0;
            ++i;
        }
        for (String key : worldNodeMap.keySet()) {
            int idx;
            Node n = worldNodeMap.get(key);
            if (!((double)latMin <= n.lat) || !(n.lat < (double)latMax)) continue;
            int n2 = idx = (int)(n.lng + 180.0);
            linearLngCount[n2] = linearLngCount[n2] + 1;
        }
        return linearLngCount;
    }

    public void createTiles(int period) {
        xSize = 180 / period;
        ySize = 360 / period;
        tileMatrix = new Tile[xSize][ySize];
        int icount = 0;
        int ix = 0;
        int iLat = -90;
        while (iLat < 90) {
            int iy = 0;
            int iLng = -180;
            while (iLng < 180) {
                String id = "tile(" + iLat + "," + iLng + ")";
                Tile t = new Tile(id, iLat, iLng, period);
                this.tileList.add(t);
                GlobalTileGenerator.tileMatrix[ix][iy] = t;
                ++icount;
                ++iy;
                iLng += period;
            }
            ++ix;
            iLat += period;
        }
        Activator.logInformation("tiled world with " + icount + " tiles");
    }

    public void computeAllEdges() {
        int largestEdge = -1;
        int i = 0;
        while (i < xSize) {
            int j = 0;
            while (j < ySize) {
                Tile tile = tileMatrix[i][j];
                for (Node n : tile.nodeSet) {
                    block3: for (Bond b : n.bondSet) {
                        String otherID = b.getOtherID(n.id);
                        Node otherNode = worldNodeMap.get(otherID);
                        if (tile.nodeSet.contains(otherNode)) continue;
                        int nn = 0;
                        while (nn < 8) {
                            Tile neighborTile;
                            int di = i + dx[nn];
                            int dj = j + dy[nn];
                            if (di < 0) {
                                di = xSize - 1;
                            }
                            if (dj < 0) {
                                dj = ySize - 1;
                            }
                            if (di >= xSize) {
                                di = 0;
                            }
                            if (dj >= ySize) {
                                dj = 0;
                            }
                            if ((neighborTile = tileMatrix[di][dj]).nodeSet.contains(otherNode)) {
                                tile.edges[nn].addBondtoEdge(b.bondID);
                                int edgeWeight = tile.edges[nn].getSize();
                                if (edgeWeight <= largestEdge) continue block3;
                                largestEdge = edgeWeight;
                                continue block3;
                            }
                            ++nn;
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
        Activator.logInformation("Largest edge has " + largestEdge + " bonds");
    }

    public static void testCentersRange(CenterReader cr) {
        double latMax = Double.MIN_VALUE;
        double lngMax = Double.MIN_VALUE;
        double latMin = Double.MAX_VALUE;
        double lngMin = Double.MAX_VALUE;
        String[] stringArray = countriesToProcess;
        int n = countriesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            String ctry = stringArray[n2];
            Set<String> idSet = countryHighestIdMap.get(ctry);
            for (String id : idSet) {
                double[] latlng = cr.getLatLong(id);
                double lat = latlng[0];
                double lng = latlng[1];
                if (lat > latMax) {
                    latMax = lat;
                }
                if (lng > lngMax) {
                    lngMax = lng;
                }
                if (lat < latMin) {
                    latMin = lat;
                }
                if (!(lng < lngMin)) continue;
                lngMin = lng;
            }
            ++n2;
        }
        Activator.logInformation("lat range is " + latMin + " to " + latMax);
        Activator.logInformation("lng range is " + lngMin + " to " + lngMax);
    }

    public void assignAllNodes(PluginCenterReader cr) {
        String[] stringArray = countriesToProcess;
        int n = countriesToProcess.length;
        int n2 = 0;
        while (n2 < n) {
            String ctry = stringArray[n2];
            Set<String> idSet = countryHighestIdMap.get(ctry);
            for (String id : idSet) {
                double[] latlng = cr.getLatLong(id);
                if (latlng == null) continue;
                double lat = latlng[0];
                double lng = latlng[1];
                if (lng > 180.0) {
                    lng -= 360.0;
                }
                Node node = new Node(id, lat, lng);
                boolean assigned = false;
                for (Tile tile : this.tileList) {
                    int idx;
                    if (!tile.getBounds2D().contains(node.lat, node.lng)) continue;
                    tile.addNode(node);
                    assigned = true;
                    int n3 = idx = (int)(node.lat + 90.0);
                    linearLatCount[n3] = linearLatCount[n3] + 1;
                    break;
                }
                if (assigned) continue;
                Activator.logInformation("Error, failed to assign " + id + " at " + lat + ", " + lng);
            }
            ++n2;
        }
        int largest = 0;
        for (Tile tile : this.tileList) {
            if (tile.getNumNodes() <= largest) continue;
            largest = tile.getNumNodes();
        }
        Activator.logInformation("assigned all points. largest tile is " + largest);
    }

    public void readIDsByCountryCode() {
        int i = 0;
        while (i < countriesToProcess.length) {
            int lvl;
            String country = countriesToProcess[i];
            Set<Object> countryIDSet = null;
            NameReader nameReader = new NameReader();
            if (countryHighestIdMap.containsKey(country)) {
                countryIDSet = countryHighestIdMap.get(country);
            } else {
                countryIDSet = new HashSet();
                countryHighestIdMap.put(country, countryIDSet);
            }
            Set idSet = nameReader.readNamesByCountryCode(country).keySet();
            Iterator iter = idSet.iterator();
            while (iter != null && iter.hasNext()) {
                String id = (String)iter.next();
                if (id.equalsIgnoreCase(country)) continue;
                countryIDSet.add(id);
            }
            if (countryIDSet.size() == 0) {
                countryIDSet.add(country);
            }
            if ((lvl = this.getHighestAdminLevel(countryIDSet)) >= 1) {
                Set<String> reducedIDSet = this.getHighestAdminSet(countryIDSet, lvl, country);
                countryIDSet = reducedIDSet;
            }
            countryHighestIdMap.put(country, countryIDSet);
            ++i;
        }
    }

    public void readWorldBonds(Set<String[]> idPairsSet) {
        for (String[] idPair : idPairsSet) {
            String id1 = idPair[0];
            String id2 = idPair[1];
            Bond b = new Bond(id1, id2);
            worldBondMap.put(b.bondID, b);
            Node n1 = worldNodeMap.get(id1);
            Node n2 = worldNodeMap.get(id2);
            if (n1 != null) {
                n1.bondSet.add(b);
            }
            if (n2 == null) continue;
            n2.bondSet.add(b);
        }
    }

    public void mapCodes() {
        BufferedReader d = null;
        try {
            try {
                String record;
                d = new BufferedReader(new InputStreamReader(CODES_FILE_URI.openStream()));
                while ((record = d.readLine()) != null) {
                    StringTokenizer st = new StringTokenizer(record);
                    String name = st.nextToken(",");
                    String twoLetter = st.nextToken(",");
                    String threeLetter = st.nextToken(",");
                    countryCode2to3.put(twoLetter, threeLetter);
                    countryCode3to2.put(threeLetter, twoLetter);
                }
            }
            catch (IOException e) {
                Activator.logInformation(" IOException error!" + e.getMessage());
                try {
                    d.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                d.close();
            }
            catch (Exception exception) {}
        }
    }

    public Set<String> getHighestAdminSet(Set<String> allIdSet, int maxAdmin, String threeLetterCode) {
        HashSet<String> leveledIDList = new HashSet<String>();
        for (String stemid : allIdSet) {
            int lvl = this.getAdminLevel(stemid);
            if (maxAdmin >= 1 && lvl == maxAdmin) {
                leveledIDList.add(stemid);
            }
            if (maxAdmin != 0 || lvl != maxAdmin) continue;
            leveledIDList.add(threeLetterCode);
        }
        return leveledIDList;
    }

    public int getAdminLevel(String stemid) {
        String[] splitID = stemid.split("-");
        if (splitID.length == 4) {
            return 3;
        }
        if (splitID.length == 3) {
            return 2;
        }
        if (splitID.length == 2) {
            return 1;
        }
        return splitID.length - 1;
    }

    public int getHighestAdminLevel(Set<String> allIdSet) {
        int maxAdmin = 0;
        for (String stemid : allIdSet) {
            int lvl = this.getAdminLevel(stemid);
            if (lvl >= maxAdmin) {
                maxAdmin = lvl;
            }
            if (stemid.indexOf("US-") != 0) continue;
            return 2;
        }
        return maxAdmin;
    }

    public static File[] filterAndSortFiles(File[] files) {
        filtered = new ArrayList<File>();
        int i = 0;
        while (i < files.length) {
            String name = files[i].getName();
            if (name.indexOf("_names.properties") >= 1) {
                filtered.add(files[i]);
            }
            ++i;
        }
        retVal = new File[filtered.size()];
        i = 0;
        while (i < filtered.size()) {
            GlobalTileGenerator.retVal[i] = filtered.get(i);
            ++i;
        }
        Arrays.sort(retVal);
        return retVal;
    }

    public class Bond {
        String bondID;
        String id1;
        String id2;

        public Bond(String node1, String node2) {
            Object[] temp = new String[]{node1, node2};
            Arrays.sort(temp);
            this.bondID = String.valueOf(temp[0]) + "_" + (String)temp[1];
            this.id1 = temp[0];
            this.id2 = temp[1];
        }

        public String getOtherID(String nodeID) {
            if (this.id1.equalsIgnoreCase(nodeID)) {
                return this.id2;
            }
            return this.id1;
        }
    }

    public class Edge {
        Set<String> bondSet = new HashSet<String>();
        int index;

        public Edge(int idx) {
            this.index = idx;
        }

        public void addBondtoEdge(String bondID) {
            this.bondSet.add(bondID);
        }

        public int getSize() {
            return this.bondSet.size();
        }
    }

    public class Node {
        double lat;
        double lng;
        String id;
        Set<Bond> bondSet = new HashSet<Bond>();

        public Node(String id, double lat, double lng) {
            this.id = id;
            this.lat = lat;
            this.lng = lng;
            worldNodeMap.put(id, this);
        }
    }

    public class Partition {
        double latMin;
        double lngMin;
        double latMax;
        double lngMax;
        int id;
        private Set<Tile> tileSet = new HashSet<Tile>();
        int size = 0;

        public Partition(int id, int latMin, int lngMin, int latMax, int lngMax) {
            this.id = id;
            this.latMin = latMin;
            this.lngMin = lngMin;
            this.latMax = latMax;
            this.lngMax = lngMax;
        }

        public int getSize() {
            return this.size;
        }

        public void addTile(Tile t) {
            if (t.numNodes > 0) {
                this.tileSet.add(t);
                this.size += t.numNodes;
            }
        }

        public Set<String> getAllNodes() {
            HashSet<String> nodeIdSet = new HashSet<String>();
            for (Tile tile : this.tileSet) {
                for (Node node : tile.nodeSet) {
                    nodeIdSet.add(node.id);
                }
            }
            return nodeIdSet;
        }
    }

    public class PartitionRow {
        List<Partition> partitionList = new ArrayList<Partition>();

        public void add(Partition p) {
            this.partitionList.add(p);
        }
    }

    public class Tile
    extends Rectangle {
        private Set<Node> nodeSet;
        String id;
        int numNodes;
        Edge[] edges;

        public Tile(String id, int x, int y, int period) {
            super(x, y, period, period);
            this.nodeSet = new HashSet<Node>();
            this.numNodes = 0;
            this.edges = new Edge[8];
            this.id = id;
            int i = 0;
            while (i < 8) {
                this.edges[i] = new Edge(i);
                ++i;
            }
        }

        public void addNode(Node n) {
            this.nodeSet.add(n);
            ++this.numNodes;
        }

        public int getNumNodes() {
            return this.numNodes;
        }
    }
}

