/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stem.model.ctdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.stem.core.graph.Label;
import org.eclipse.stem.core.graph.LabelValue;
import org.eclipse.stem.core.graph.Node;
import org.eclipse.stem.core.model.STEMTime;
import org.eclipse.stem.model.metamodel.Compartment;
import org.eclipse.stem.model.metamodel.CompartmentGroup;
import org.eclipse.stem.model.metamodel.Model;
import org.eclipse.stem.model.metamodel.ModelParam;

public class CTDLUtils {
    private static final Map<String, Class<?>> GLOBAL_USER_VARS = new HashMap();
    private static final Map<String, Class<?>> GLOBAL_SYSTEM_VARS = new HashMap();
    public static List<String> classTypeNames;

    static {
        GLOBAL_USER_VARS.put("timeDelta", Long.TYPE);
        GLOBAL_USER_VARS.put("t", Double.TYPE);
        GLOBAL_SYSTEM_VARS.put("time", STEMTime.class);
        GLOBAL_SYSTEM_VARS.put("label", Label.class);
        GLOBAL_SYSTEM_VARS.put("labelValue", LabelValue.class);
        GLOBAL_SYSTEM_VARS.put("node", Node.class);
        classTypeNames = Arrays.asList("double", "int", "float", "long", "short", "java.lang.Double", "java.lang.Integer", "java.lang.Float", "java.lang.Long", "java.lang.Short");
    }

    public static Class<?> getTypeForGlobalVariable(String name) {
        Class<?> type = GLOBAL_USER_VARS.get(name);
        if (type == null) {
            type = GLOBAL_SYSTEM_VARS.get(name);
        }
        return type;
    }

    public static Map<String, Class<?>> getGlobalUserVariables() {
        return Collections.unmodifiableMap(GLOBAL_USER_VARS);
    }

    public static Map<String, Class<?>> getGlobalSystemVariables() {
        return Collections.unmodifiableMap(GLOBAL_SYSTEM_VARS);
    }

    public static String getNormalizedTypeNameForClass(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        if (CTDLUtils.isNumber(clazz)) {
            return "number";
        }
        if (clazz == String.class) {
            return "string";
        }
        return clazz.getName();
    }

    public static String getNormalizedTypeNameForClass(String className) {
        if (className == null) {
            return null;
        }
        if (CTDLUtils.isNumber(className)) {
            return "number";
        }
        if (String.class.getName().equals(className)) {
            return "string";
        }
        return className;
    }

    public static boolean isNumber(String className) {
        return classTypeNames.contains(className);
    }

    public static boolean isNumber(Class<?> clazz) {
        return clazz == Double.TYPE || clazz == Double.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Float.TYPE || clazz == Float.class || clazz == Long.TYPE || clazz == Long.class || clazz == Short.TYPE || clazz == Short.class;
    }

    public static List<Compartment> getAllCompartmentsForGroup(CompartmentGroup cg) {
        ArrayList<Compartment> compartments = new ArrayList<Compartment>();
        if (cg != null) {
            compartments.addAll(CTDLUtils.getAllCompartmentsForGroup(cg.getParentGroup()));
            compartments.addAll((Collection<Compartment>)cg.getCompartments());
        }
        return compartments;
    }

    public static List<Compartment> getAllCompartmentsForModel(Model model) {
        return CTDLUtils.getAllCompartmentsForGroup(model.getCompartments());
    }

    public static List<ModelParam> getAllParametersForModel(Model model) {
        ArrayList<ModelParam> params = new ArrayList<ModelParam>();
        if (model != null) {
            params.addAll(CTDLUtils.getAllParametersForModel(model.getParentModel()));
            params.addAll((Collection<ModelParam>)model.getParameters());
        }
        return params;
    }

    public static String ucfirst(String str) {
        if (str.length() > 0 && Character.isLowerCase(str.codePointAt(0))) {
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(Character.toUpperCase(str.codePointAt(0)));
            sb.append(str.substring(1));
            return sb.toString();
        }
        return str;
    }

    public static String lcfirst(String str) {
        if (str.length() > 0 && Character.isUpperCase(str.codePointAt(0))) {
            StringBuilder sb = new StringBuilder();
            sb.appendCodePoint(Character.toLowerCase(str.codePointAt(0)));
            sb.append(str.substring(1));
            return sb.toString();
        }
        return str;
    }
}

