/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.xtext.common.types.access.impl.IndexedJvmTypeAccess;
import org.eclipse.xtext.common.types.access.jdt.IJavaProjectProvider;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.ui.containers.JavaProjectsState;
import org.eclipse.xtext.ui.containers.WorkspaceProjectsState;

public class JdtIndexedJvmTypeAccess
extends IndexedJvmTypeAccess {
    @Inject
    private IJavaProjectProvider javaProjectProvider;
    @Inject
    private JavaProjectsState javaProjectsState;
    @Inject
    private WorkspaceProjectsState plainProjectsState;

    protected EObject findAccessibleType(String fragment, ResourceSet resourceSet, Iterator<IEObjectDescription> fromIndex) throws IndexedJvmTypeAccess.UnknownNestedTypeException {
        IJavaProject javaProject = this.javaProjectProvider.getJavaProject(resourceSet);
        ArrayList allVisibleContainerHandles = Lists.newArrayList((Iterable)this.javaProjectsState.getVisibleContainerHandles(javaProject.getHandleIdentifier()));
        allVisibleContainerHandles.addAll(this.plainProjectsState.getVisibleContainerHandles(javaProject.getElementName()));
        List visibleContainerHandles = allVisibleContainerHandles;
        IEObjectDescription bestDescription = null;
        while (fromIndex.hasNext() && !visibleContainerHandles.isEmpty()) {
            IEObjectDescription description = fromIndex.next();
            URI trimFragment = description.getEObjectURI().trimFragment();
            String handle = this.javaProjectsState.getContainerHandle(trimFragment);
            int idx = visibleContainerHandles.indexOf(handle);
            if (idx < 0) continue;
            bestDescription = description;
            visibleContainerHandles = allVisibleContainerHandles.subList(0, idx);
        }
        if (bestDescription != null) {
            return this.getAccessibleType(bestDescription, fragment, resourceSet);
        }
        return null;
    }
}

