/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.testutils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.osgi.framework.Bundle;

public class TestFileAccessor {
    private static final String INPUT_DIR = "resources/input";
    private static final String BUNDLE_RESOURCE_SCHEME = "bundleresource";
    private static final String BUNDLE_ENTRY_SCHEME = "bundleentry";
    private Plugin targetPlugin;
    private File workingDirectory;

    public static String readAsString(IFile file) throws CoreException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(file.getContents());){
            String string = TestFileAccessor.readAsString(inputStream);
            return string;
        }
    }

    public static String readAsString(File file) throws CoreException, IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(file));){
            String string = TestFileAccessor.readAsString(inputStream);
            return string;
        }
    }

    private static String readAsString(InputStream inputStream) throws CoreException, IOException {
        int bufferLength;
        byte[] buffer = new byte[1024];
        StringBuilder content = new StringBuilder();
        while ((bufferLength = inputStream.read(buffer)) > -1) {
            content.append(new String(buffer, 0, bufferLength));
        }
        return content.toString();
    }

    public static void copyInputStreamToFile(InputStream in, File targetFile) throws IOException {
        FileOutputStream out = new FileOutputStream(targetFile);
        try {
            int len;
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        catch (Throwable throwable) {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (in != null) {
                in.close();
            }
            if (out != null) {
                ((OutputStream)out).close();
            }
        }
        catch (IOException iOException) {}
    }

    public TestFileAccessor(Plugin targetPlugin, File workingDirectory) {
        Assert.isNotNull((Object)targetPlugin);
        Assert.isNotNull((Object)workingDirectory);
        this.targetPlugin = targetPlugin;
        this.workingDirectory = workingDirectory;
        workingDirectory.mkdirs();
    }

    public TestFileAccessor(Plugin targetPlugin) {
        this(targetPlugin, new File("."));
    }

    public Plugin getTargetPlugin() {
        return this.targetPlugin;
    }

    protected IPath getInputFilePath(String inputFileName) {
        return new Path("resources/input/" + inputFileName);
    }

    public java.net.URI getInputFileURI(String inputFileName) throws URISyntaxException, IOException {
        return this.getInputFileURI(inputFileName, false);
    }

    public java.net.URI getInputFileURI(String inputFileName, boolean fileScheme) throws URISyntaxException, IOException {
        IPath inputFilePath = this.getInputFilePath(inputFileName);
        URL url = FileLocator.find((Bundle)this.targetPlugin.getBundle(), (IPath)inputFilePath, null);
        if (url == null) {
            throw new FileNotFoundException(inputFileName);
        }
        if (fileScheme) {
            url = FileLocator.toFileURL((URL)url);
        }
        String path = url.getPath();
        String os = Platform.getOS();
        if (os.contains("win")) {
            path = path.replaceAll("\\s", "%20");
        }
        return new URL(url.getProtocol(), null, path).toURI();
    }

    public InputStream openInputFileInputStream(String inputFileName) throws IOException {
        IPath inputFilePath = this.getInputFilePath(inputFileName);
        return FileLocator.openStream((Bundle)this.targetPlugin.getBundle(), (IPath)inputFilePath, (boolean)false);
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public File createWorkingFile(String workingFileName) {
        return new File(this.workingDirectory, workingFileName);
    }

    public java.net.URI getWorkingFileURI(String workingFileName) {
        return this.createWorkingFile(workingFileName).toURI();
    }

    public InputStream openWorkingFileInputStream(String workingFileName) throws FileNotFoundException {
        return new FileInputStream(this.createWorkingFile(workingFileName));
    }

    public OutputStream openWorkingFileOutputStream(String workingFileName, boolean append) throws FileNotFoundException {
        return new FileOutputStream(this.createWorkingFile(workingFileName), append);
    }

    public File createWorkingCopyOfInputFile(String inputFileName) throws IOException {
        InputStream in = this.openInputFileInputStream(inputFileName);
        File workingCopyOfInputFile = this.createWorkingFile(inputFileName);
        TestFileAccessor.copyInputStreamToFile(in, workingCopyOfInputFile);
        return workingCopyOfInputFile;
    }

    public URI convertToEMFURI(java.net.URI uri) {
        if (BUNDLE_RESOURCE_SCHEME.equals(uri.getScheme()) || BUNDLE_ENTRY_SCHEME.equals(uri.getScheme())) {
            return URI.createPlatformPluginURI((String)(this.targetPlugin + uri.getPath()), (boolean)true);
        }
        return URI.createURI((String)uri.toString(), (boolean)true);
    }
}

