/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.util;

import com.google.common.base.Objects;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class URIExtensions {
    public static final String URI_SEGMENT_SEPARATOR = "/";
    public static final String URI_AUTHORITY_SEPARATOR = "//";
    public static final String URI_QUERY_SEPARATOR = "?";
    public static final String URI_FRAGMENT_SEPARATOR = "#";

    public static boolean isActual(URI uri) {
        boolean _hasFragment;
        boolean _hasQuery;
        boolean _hasTrailingPathSeparator;
        boolean _hasAuthority;
        boolean _hasDevice;
        Assert.isNotNull((Object)uri);
        boolean _or = false;
        boolean _or_1 = false;
        boolean _or_2 = false;
        boolean _or_3 = false;
        boolean _or_4 = false;
        boolean _or_5 = false;
        String _scheme = uri.scheme();
        boolean _isNullOrEmpty = StringExtensions.isNullOrEmpty((String)_scheme);
        boolean _not = !_isNullOrEmpty;
        _or_5 = _not ? true : (_hasDevice = uri.hasDevice());
        _or_4 = _or_5 ? true : (_hasAuthority = uri.hasAuthority());
        if (_or_4) {
            _or_3 = true;
        } else {
            int _segmentCount;
            boolean _greaterThan;
            boolean _and = false;
            boolean _hasPath = uri.hasPath();
            _and = !_hasPath ? false : (_greaterThan = (_segmentCount = uri.segmentCount()) > 1);
            _or_3 = _and;
        }
        _or_2 = _or_3 ? true : (_hasTrailingPathSeparator = uri.hasTrailingPathSeparator());
        _or_1 = _or_2 ? true : (_hasQuery = uri.hasQuery());
        _or = _or_1 ? true : (_hasFragment = uri.hasFragment());
        return _or;
    }

    public static URI getFragment(URI uri) {
        Assert.isNotNull((Object)uri);
        boolean _hasFragment = uri.hasFragment();
        if (_hasFragment) {
            String fragment = uri.fragment();
            boolean _startsWith = fragment.startsWith(URI_AUTHORITY_SEPARATOR);
            if (_startsWith) {
                int _length;
                boolean _greaterThan;
                int queryIdx = fragment.indexOf(URI_QUERY_SEPARATOR);
                String _xifexpression = null;
                _xifexpression = queryIdx != -1 ? fragment.substring(0, queryIdx) : fragment;
                String path = _xifexpression;
                String _xifexpression_1 = null;
                boolean _and = false;
                _and = queryIdx == -1 ? false : (_greaterThan = (_length = fragment.length()) > queryIdx + 1);
                if (_and) {
                    int _length_1 = fragment.length();
                    _xifexpression_1 = fragment.substring(queryIdx + 1, _length_1);
                } else {
                    _xifexpression_1 = null;
                }
                String query = _xifexpression_1;
                String[] _split = path.split(URI_SEGMENT_SEPARATOR);
                return URI.createHierarchicalURI((String[])_split, (String)query, null);
            }
            return URI.createURI((String)fragment, (boolean)true);
        }
        return null;
    }

    public static URI substituteFragment(URI uri, URI fragment) {
        boolean _notEquals;
        Assert.isNotNull((Object)uri);
        URI result = uri.trimFragment();
        boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
        if (_notEquals) {
            URI _appendFragment;
            String _string = fragment.toString();
            result = _appendFragment = result.appendFragment(_string);
        }
        return result;
    }

    public static URI asPrefix(URI uri) {
        boolean _not;
        URI _trimFragment;
        Assert.isNotNull((Object)uri);
        URI result = uri.trimQuery();
        result = _trimFragment = result.trimFragment();
        boolean _hasTrailingPathSeparator = result.hasTrailingPathSeparator();
        boolean bl = _not = !_hasTrailingPathSeparator;
        if (_not) {
            URI _appendSegment;
            result = _appendSegment = result.appendSegment("");
        }
        return result;
    }

    public static URI replaceLastSegment(URI uri, String oldLastSegment, String newLastSegment) {
        Assert.isNotNull((Object)uri);
        int _segmentCount = uri.segmentCount();
        boolean _greaterThan = _segmentCount > 0;
        Assert.isLegal((boolean)_greaterThan);
        String _lastSegment = uri.lastSegment();
        boolean _equals = _lastSegment.equals(oldLastSegment);
        if (_equals) {
            URI _trimSegments = uri.trimSegments(1);
            return _trimSegments.appendSegment(newLastSegment);
        }
        return null;
    }

    public static URI replaceBaseURI(URI uri, URI oldBaseURI, URI newBaseURI) {
        boolean _hasFragment_2;
        boolean _hasFragment_1;
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)oldBaseURI);
        Assert.isNotNull((Object)newBaseURI);
        boolean _and = false;
        boolean _and_1 = false;
        boolean _hasFragment = uri.hasFragment();
        _and_1 = !_hasFragment ? false : (_hasFragment_1 = oldBaseURI.hasFragment());
        _and = !_and_1 ? false : (_hasFragment_2 = newBaseURI.hasFragment());
        if (_and) {
            URI _trimFragment_1;
            URI _trimFragment = uri.trimFragment();
            boolean _equals = _trimFragment.equals(_trimFragment_1 = oldBaseURI.trimFragment());
            if (_equals) {
                boolean _notEquals;
                URI _fragment_2;
                URI _asPrefix_1;
                URI _fragment_1;
                URI _asPrefix;
                URI _fragment = URIExtensions.getFragment(uri);
                URI fragment = _fragment.replacePrefix(_asPrefix = URIExtensions.asPrefix(_fragment_1 = URIExtensions.getFragment(oldBaseURI)), _asPrefix_1 = URIExtensions.asPrefix(_fragment_2 = URIExtensions.getFragment(newBaseURI)));
                boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
                if (_notEquals) {
                    return URIExtensions.substituteFragment(newBaseURI, fragment);
                }
            }
        } else {
            URI _asPrefix_2 = URIExtensions.asPrefix(oldBaseURI);
            URI _asPrefix_3 = URIExtensions.asPrefix(newBaseURI);
            return uri.replacePrefix(_asPrefix_2, _asPrefix_3);
        }
        return null;
    }

    public static URI replaceLastFragmentSegment(URI uri, String oldLastFragmentSegment, String newLastFragmentSegment) {
        boolean _notEquals;
        Assert.isNotNull((Object)uri);
        URI fragment = URIExtensions.getFragment(uri);
        boolean bl = _notEquals = !Objects.equal((Object)fragment, null);
        if (_notEquals) {
            boolean _notEquals_1;
            URI _replaceLastSegment = URIExtensions.replaceLastSegment(fragment, oldLastFragmentSegment, newLastFragmentSegment);
            boolean bl2 = _notEquals_1 = !Objects.equal((Object)(fragment = _replaceLastSegment), null);
            if (_notEquals_1) {
                return URIExtensions.substituteFragment(uri, fragment);
            }
        }
        return null;
    }
}

