/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.components;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.mwe.core.WorkflowComponentWithID;
import org.eclipse.emf.mwe.core.WorkflowContext;
import org.eclipse.emf.mwe.core.issues.Issues;
import org.eclipse.emf.mwe.core.issues.IssuesImpl;
import org.eclipse.emf.mwe.core.issues.MWEDiagnostic;
import org.eclipse.emf.mwe.core.lib.AbstractWorkflowComponent2;
import org.eclipse.emf.mwe.core.lib.Mwe2Bridge;
import org.eclipse.emf.mwe.core.monitor.NullProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitor;
import org.eclipse.emf.mwe.core.monitor.ProgressMonitorAdapter;
import org.eclipse.emf.mwe2.runtime.workflow.IWorkflowContext;
import org.eclipse.sphinx.emf.mwe.dynamic.components.IWorkspaceWorkflowComponent;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.Activator;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractWorkspaceWorkflowComponent
extends AbstractWorkflowComponent2
implements IWorkspaceWorkflowComponent {
    private final ISchedulingRule rule;
    private Mwe2Bridge bridge;

    public AbstractWorkspaceWorkflowComponent() {
        this(null);
    }

    public AbstractWorkspaceWorkflowComponent(ISchedulingRule rule) {
        this.rule = rule;
    }

    @Override
    public ISchedulingRule getRule() {
        return this.rule;
    }

    protected Mwe2Bridge getBridge() {
        if (this.bridge == null) {
            this.bridge = new WorkspaceMwe2Bridge((WorkflowComponentWithID)this);
        }
        return this.bridge;
    }

    protected static class WorkspaceMwe2Bridge
    extends Mwe2Bridge {
        private final WorkflowComponentWithID delegate;

        public WorkspaceMwe2Bridge(WorkflowComponentWithID delegate) {
            super(delegate);
            this.delegate = delegate;
        }

        public void invoke(final IWorkflowContext ctx) {
            IssuesImpl issues = new IssuesImpl();
            Object monitorAsObject = ctx.get("progressMonitor");
            ProgressMonitorAdapter monitor = monitorAsObject instanceof IProgressMonitor ? new ProgressMonitorAdapter((IProgressMonitor)monitorAsObject) : new NullProgressMonitor();
            this.delegate.invoke(new WorkflowContext(){

                public void set(String slotName, Object value) {
                    ctx.put(slotName, value);
                }

                public String[] getSlotNames() {
                    return ctx.getSlotNames().toArray(new String[ctx.getSlotNames().size()]);
                }

                public Object get(String slotName) {
                    return ctx.get(slotName);
                }
            }, (ProgressMonitor)monitor, (Issues)issues);
            this.handleIssues(issues);
        }

        protected void handleIssues(IssuesImpl issues) {
            MWEDiagnostic diag;
            MWEDiagnostic[] mWEDiagnosticArray = issues.getErrors();
            int n = mWEDiagnosticArray.length;
            int n2 = 0;
            while (n2 < n) {
                diag = mWEDiagnosticArray[n2];
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)diag.toString());
                ++n2;
            }
            mWEDiagnosticArray = issues.getWarnings();
            n = mWEDiagnosticArray.length;
            n2 = 0;
            while (n2 < n) {
                diag = mWEDiagnosticArray[n2];
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)diag.toString());
                ++n2;
            }
            mWEDiagnosticArray = issues.getInfos();
            n = mWEDiagnosticArray.length;
            n2 = 0;
            while (n2 < n) {
                diag = mWEDiagnosticArray[n2];
                PlatformLogUtil.logAsInfo((Plugin)Activator.getPlugin(), (Object)diag.toString());
                ++n2;
            }
        }
    }
}

