/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.check;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sphinx.emf.check.Check;
import org.eclipse.sphinx.emf.check.CheckValidationMode;
import org.eclipse.sphinx.emf.check.CheckValidatorRegistry;
import org.eclipse.sphinx.emf.check.CheckValidatorState;
import org.eclipse.sphinx.emf.check.ICheckValidator;
import org.eclipse.sphinx.emf.check.catalog.Catalog;
import org.eclipse.sphinx.emf.check.catalog.Severity;
import org.eclipse.sphinx.emf.check.internal.Activator;
import org.eclipse.sphinx.emf.check.internal.CheckMethodWrapper;
import org.eclipse.sphinx.emf.check.util.DiagnosticLocation;
import org.eclipse.sphinx.emf.check.util.ExtendedEObjectValidator;
import org.eclipse.sphinx.emf.check.util.SourceLocation;
import org.eclipse.sphinx.emf.util.IWrapper;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public abstract class AbstractCheckValidator
implements ICheckValidator {
    private int NO_INDEX = -1;
    private boolean initialized = false;
    private final ThreadLocal<CheckValidatorState> state = new ThreadLocal();
    private ExtendedEObjectValidator extendedEObjectValidator = new ExtendedEObjectValidator();
    private Map<Class<?>, List<CheckMethodWrapper>> collectedModelObjectTypeToCheckMethodsMap = new HashMap();
    private Map<Class<?>, List<CheckMethodWrapper>> actualModelObjectTypeToCheckMethodsMap = new HashMap();

    protected Class<?> getModelObjectType(EObject eObject) {
        Class<?> parameterType = this.getMethodWrapperType(eObject);
        if (parameterType != null) {
            return parameterType;
        }
        Assert.isNotNull((Object)eObject);
        return eObject.eClass().getInstanceClass();
    }

    @Deprecated
    protected Class<?> getMethodWrapperType(EObject eObject) {
        return null;
    }

    protected void setCurrentObject(CheckValidatorState state, Object object) {
        Assert.isNotNull((Object)state);
        state.currentObject = object;
    }

    protected synchronized void initCheckMethods() {
        if (!this.initialized) {
            this.initialized = true;
            HashSet visitedValidatorTypes = new HashSet();
            this.initCheckMethods(this, this.getClass(), visitedValidatorTypes);
        }
    }

    private void initCheckMethods(ICheckValidator validator, Class<? extends ICheckValidator> validatorType, Collection<Class<?>> visitedValidatorTypes) {
        Method[] methods;
        Assert.isNotNull(validatorType);
        Assert.isNotNull(visitedValidatorTypes);
        if (!visitedValidatorTypes.add(validatorType)) {
            return;
        }
        if (validator == null) {
            try {
                validator = validatorType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
                return;
            }
        }
        Method[] methodArray = methods = validatorType.getDeclaredMethods();
        int n = methods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            Check annotation = method.getAnnotation(Check.class);
            if (annotation != null && method.getParameterTypes().length == 1) {
                this.addCheckMethod(validator, method);
            }
            ++n2;
        }
        Class<? extends ICheckValidator> superClass = validatorType.getSuperclass();
        if (superClass != null && ICheckValidator.class.isAssignableFrom(superClass)) {
            this.initCheckMethods(validator, superClass, visitedValidatorTypes);
        }
    }

    protected void addCheckMethod(ICheckValidator validator, Method method) {
        Class<?> modelObjectType = method.getParameterTypes()[0];
        List<CheckMethodWrapper> value = this.collectedModelObjectTypeToCheckMethodsMap.get(modelObjectType);
        if (value == null) {
            value = new ArrayList<CheckMethodWrapper>();
            this.collectedModelObjectTypeToCheckMethodsMap.put(modelObjectType, value);
        }
        value.add(this.createCheckMethodWrapper(validator, method));
    }

    protected CheckMethodWrapper createCheckMethodWrapper(ICheckValidator validator, Method method) {
        return new CheckMethodWrapper(validator, method);
    }

    protected boolean isIntrinsicCategorySelected(Set<String> selectedCategories) {
        Assert.isNotNull(selectedCategories);
        for (String categoryId : selectedCategories) {
            if (!categoryId.equals("org.eclipse.sphinx.emf.check.categories.intrinsic")) continue;
            return true;
        }
        return false;
    }

    public boolean validate(EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate(eObject.eClass(), eObject, diagnostics, context);
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        Set<String> selectedCategories = this.getCategoriesFromContext(context);
        this.initCheckMethods();
        CheckValidationMode mode = CheckValidationMode.getFromContext(context);
        CheckValidatorState state = new CheckValidatorState();
        state.chain = diagnostics;
        this.setCurrentObject(state, eObject);
        state.checkValidationMode = mode;
        state.context = context;
        if (this.isIntrinsicCategorySelected(selectedCategories)) {
            this.extendedEObjectValidator.validate(eObject.eClass().getClassifierID(), eObject, diagnostics, context);
        }
        for (CheckMethodWrapper method : this.getCheckMethodsForModelObjectType(this.getModelObjectType(eObject))) {
            try {
                method.invoke(state, selectedCategories);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
        return !state.hasErrors;
    }

    protected List<CheckMethodWrapper> getCheckMethodsForModelObjectType(Class<?> modelObjectType) {
        List<CheckMethodWrapper> actualCheckMethodsForModelObjectType = this.actualModelObjectTypeToCheckMethodsMap.get(modelObjectType);
        if (actualCheckMethodsForModelObjectType == null) {
            actualCheckMethodsForModelObjectType = new ArrayList<CheckMethodWrapper>();
            for (Class<?> collectedModelObjectType : this.collectedModelObjectTypeToCheckMethodsMap.keySet()) {
                if (!collectedModelObjectType.isAssignableFrom(modelObjectType)) continue;
                actualCheckMethodsForModelObjectType.addAll((Collection<CheckMethodWrapper>)this.collectedModelObjectTypeToCheckMethodsMap.get(collectedModelObjectType));
            }
            this.actualModelObjectTypeToCheckMethodsMap.put(modelObjectType, actualCheckMethodsForModelObjectType);
        }
        return actualCheckMethodsForModelObjectType;
    }

    protected Set<String> getCategoriesFromContext(Map<Object, Object> context) {
        Object categories;
        if (context != null && (categories = context.get("CATEGORIES")) instanceof Set) {
            Set castedCategories = (Set)categories;
            return castedCategories;
        }
        return Collections.emptySet();
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    protected void issue(Object object, EStructuralFeature feature, Object ... arguments) {
        if (object instanceof IWrapper) {
            Object eObject = ((IWrapper)object).getTarget();
            this.issue(eObject, feature, this.NO_INDEX, arguments);
        } else if (object instanceof EObject) {
            this.issue((EObject)object, feature, this.NO_INDEX, arguments);
        } else {
            throw new UnsupportedOperationException("Could not recognize type of " + object.toString());
        }
    }

    protected void issue(EObject object, EStructuralFeature feature, Object ... arguments) {
        this.issue(object, feature, this.NO_INDEX, arguments);
    }

    protected void issue(EObject object, EStructuralFeature feature, int index, Object ... arguments) {
        String constraint = this.getState().get().constraint;
        Catalog checkCatalog = this.getCheckCatalog();
        if (checkCatalog == null) {
            return;
        }
        String severityMessage = MessageFormat.format(checkCatalog.getMessage(constraint), arguments);
        Severity severity = checkCatalog.getSeverity(constraint);
        switch (severity) {
            case ERROR: {
                this.error(severityMessage, object, feature, index);
                break;
            }
            case WARNING: {
                this.warning(severityMessage, object, feature, index);
                break;
            }
            case INFO: {
                this.info(severityMessage, object, feature, index);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + severity);
            }
        }
    }

    protected void error(String message, EObject object, EStructuralFeature feature) {
        this.error(message, object, feature, this.NO_INDEX);
    }

    protected void error(String message, EObject object, EStructuralFeature feature, int index) {
        this.error(message, object, feature, index, this.createIssueData(object, feature, index));
    }

    protected void error(String message, EObject object, EStructuralFeature feature, int index, Object[] issueData) {
        this.getState().get().hasErrors = true;
        if (!this.containsDiagnosticLocation(issueData)) {
            this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, this.addDiagnosticLocation(object, feature, index, issueData)));
        } else {
            this.getState().get().chain.add(this.createDiagnostic(Severity.ERROR, message, issueData));
        }
    }

    protected void warning(String message, EObject object, EStructuralFeature feature) {
        this.warning(message, object, feature, this.NO_INDEX);
    }

    protected void warning(String message, EObject object, EStructuralFeature feature, int index) {
        this.warning(message, object, feature, index, this.createIssueData(object, feature, index));
    }

    protected void warning(String message, EObject object, EStructuralFeature feature, int index, Object[] issueData) {
        if (!this.containsDiagnosticLocation(issueData)) {
            this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, this.addDiagnosticLocation(object, feature, index, issueData)));
        } else {
            this.getState().get().chain.add(this.createDiagnostic(Severity.WARNING, message, issueData));
        }
    }

    protected void info(String message, EObject object, EStructuralFeature feature) {
        this.info(message, object, feature, this.NO_INDEX);
    }

    protected void info(String message, EObject object, EStructuralFeature feature, int index) {
        this.info(message, object, feature, index, this.createIssueData(object, feature, index));
    }

    protected void info(String message, EObject object, EStructuralFeature feature, int index, Object[] issueData) {
        if (!this.containsDiagnosticLocation(issueData)) {
            this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, this.addDiagnosticLocation(object, feature, index, issueData)));
        } else {
            this.getState().get().chain.add(this.createDiagnostic(Severity.INFO, message, issueData));
        }
    }

    protected Object[] addDiagnosticLocation(EObject object, EStructuralFeature feature, int index, Object[] issueData) {
        Object[] result = Arrays.copyOf(issueData, issueData.length + 1);
        result[issueData.length] = new DiagnosticLocation(object, feature, index);
        return result;
    }

    protected boolean containsDiagnosticLocation(Object[] issueData) {
        Object[] objectArray = issueData;
        int n = issueData.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (obj instanceof DiagnosticLocation) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected Object[] createIssueData(EObject object, EStructuralFeature feature, int index) {
        Object[] data = new Object[]{new DiagnosticLocation(object, feature, index), new SourceLocation(this.getClass(), this.getState().get().currentMethod, this.getState().get().constraint)};
        return data;
    }

    protected Diagnostic createDiagnostic(Severity severity, String message, Object[] issueData) {
        int diagnosticSeverity = this.toDiagnosticSeverity(severity);
        BasicDiagnostic result = new BasicDiagnostic(diagnosticSeverity, this.getClass().getName(), 0, message, issueData);
        return result;
    }

    protected int toDiagnosticSeverity(Severity severity) {
        int diagnosticSeverity = -1;
        switch (severity) {
            case ERROR: {
                diagnosticSeverity = 4;
                break;
            }
            case WARNING: {
                diagnosticSeverity = 2;
                break;
            }
            case INFO: {
                diagnosticSeverity = 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknow severity " + severity);
            }
        }
        return diagnosticSeverity;
    }

    @Override
    public ThreadLocal<CheckValidatorState> getState() {
        return this.state;
    }

    public Catalog getCheckCatalog() {
        return CheckValidatorRegistry.INSTANCE.getCheckCatalog(this);
    }

    protected static class CheckValidatorStateAccess {
        private ICheckValidator validator;

        private CheckValidatorStateAccess(ICheckValidator validator) {
            this.validator = validator;
        }

        public CheckValidatorState getState() {
            CheckValidatorState result = this.validator.getState().get();
            if (result == null) {
                result = new CheckValidatorState();
                this.validator.getState().set(result);
            }
            return result;
        }
    }
}

