/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.properties;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.celleditor.FeatureEditorDialog;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceAdapterFactory;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.PatternFilter;

public class ProxyURIFeatureEditorDialog
extends FeatureEditorDialog {
    protected EStructuralFeature feature;
    protected List<?> currentValues;

    public ProxyURIFeatureEditorDialog(Shell parent, ILabelProvider labelProvider, EObject owner, EStructuralFeature feature, String displayName, List<?> choiceOfValues, boolean multiLine, boolean sortChoices) {
        super(parent, labelProvider, (Object)owner, feature.getEType(), (List)owner.eGet(feature), displayName, choiceOfValues, multiLine, sortChoices);
        this.feature = feature;
        this.currentValues = (List)owner.eGet(feature);
    }

    protected Control createDialogArea(Composite parent) {
        Text choiceText;
        TableViewer choiceTableViewer;
        Table choiceTable;
        Composite contents = new Composite(parent, 0);
        GridLayout compositeLayout = new GridLayout();
        compositeLayout.marginHeight = this.convertVerticalDLUsToPixels(7);
        compositeLayout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        compositeLayout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        compositeLayout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        contents.setLayout((Layout)compositeLayout);
        contents.setLayoutData((Object)new GridData(1808));
        ProxyURIFeatureEditorDialog.applyDialogFont((Control)contents);
        GridLayout contentsGridLayout = (GridLayout)contents.getLayout();
        contentsGridLayout.numColumns = 3;
        GridData contentsGridData = (GridData)contents.getLayoutData();
        contentsGridData.horizontalAlignment = 4;
        contentsGridData.verticalAlignment = 4;
        Text patternText = null;
        if (this.choiceOfValues != null) {
            Group filterGroupComposite = new Group(contents, 0);
            filterGroupComposite.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_pattern_group"));
            filterGroupComposite.setLayout((Layout)new GridLayout(2, false));
            filterGroupComposite.setLayoutData((Object)new GridData(4, -1, true, false, 3, 1));
            Label label = new Label((Composite)filterGroupComposite, 0);
            label.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_pattern_label"));
            patternText = new Text((Composite)filterGroupComposite, 2048);
            patternText.setLayoutData((Object)new GridData(768));
        }
        Composite choiceComposite = new Composite(contents, 0);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalAlignment = 0x1000008;
        choiceComposite.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        data.horizontalAlignment = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        choiceComposite.setLayout((Layout)layout);
        Label choiceLabel = new Label(choiceComposite, 0);
        choiceLabel.setText(this.choiceOfValues == null ? EMFEditUIPlugin.INSTANCE.getString("_UI_Value_label") : EMFEditUIPlugin.INSTANCE.getString("_UI_Choices_label"));
        GridData choiceLabelGridData = new GridData();
        choiceLabelGridData.verticalAlignment = 4;
        choiceLabelGridData.horizontalAlignment = 4;
        choiceLabel.setLayoutData((Object)choiceLabelGridData);
        Table table = choiceTable = this.choiceOfValues == null ? null : new Table(choiceComposite, 2050);
        if (choiceTable != null) {
            GridData choiceTableGridData = new GridData();
            choiceTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
            choiceTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
            choiceTableGridData.verticalAlignment = 4;
            choiceTableGridData.horizontalAlignment = 4;
            choiceTableGridData.grabExcessHorizontalSpace = true;
            choiceTableGridData.grabExcessVerticalSpace = true;
            choiceTable.setLayoutData((Object)choiceTableGridData);
        }
        TableViewer tableViewer = choiceTableViewer = this.choiceOfValues == null ? null : new TableViewer(choiceTable);
        if (choiceTableViewer != null) {
            choiceTableViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)new AdapterFactoryImpl()));
            choiceTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            final PatternFilter filter = new PatternFilter(){

                protected boolean isParentMatch(Viewer viewer, Object element) {
                    return viewer instanceof AbstractTreeViewer && super.isParentMatch(viewer, element);
                }
            };
            choiceTableViewer.addFilter((ViewerFilter)filter);
            assert (patternText != null);
            patternText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    filter.setPattern(((Text)e.widget).getText());
                    choiceTableViewer.refresh();
                }
            });
            choiceTableViewer.setInput((Object)new ItemProvider((Collection)this.choiceOfValues));
        }
        int style = this.multiLine ? 2818 : 2050;
        Text text = choiceText = this.choiceOfValues == null ? new Text(choiceComposite, style) : null;
        if (choiceText != null) {
            GridData choiceTextGridData = new GridData();
            choiceTextGridData.widthHint = Display.getCurrent().getBounds().width / 5;
            choiceTextGridData.verticalAlignment = 1;
            choiceTextGridData.horizontalAlignment = 4;
            choiceTextGridData.grabExcessHorizontalSpace = true;
            if (this.multiLine) {
                choiceTextGridData.verticalAlignment = 4;
                choiceTextGridData.grabExcessVerticalSpace = true;
            }
            choiceText.setLayoutData((Object)choiceTextGridData);
        }
        Composite controlButtons = new Composite(contents, 0);
        GridData controlButtonsGridData = new GridData();
        controlButtonsGridData.verticalAlignment = 4;
        controlButtonsGridData.horizontalAlignment = 4;
        controlButtons.setLayoutData((Object)controlButtonsGridData);
        GridLayout controlsButtonGridLayout = new GridLayout();
        controlButtons.setLayout((Layout)controlsButtonGridLayout);
        new Label(controlButtons, 0);
        final Button addButton = new Button(controlButtons, 8);
        addButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Add_label"));
        GridData addButtonGridData = new GridData();
        addButtonGridData.verticalAlignment = 4;
        addButtonGridData.horizontalAlignment = 4;
        addButton.setLayoutData((Object)addButtonGridData);
        final Button removeButton = new Button(controlButtons, 8);
        removeButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Remove_label"));
        GridData removeButtonGridData = new GridData();
        removeButtonGridData.verticalAlignment = 4;
        removeButtonGridData.horizontalAlignment = 4;
        removeButton.setLayoutData((Object)removeButtonGridData);
        Label spaceLabel = new Label(controlButtons, 0);
        GridData spaceLabelGridData = new GridData();
        spaceLabelGridData.verticalSpan = 2;
        spaceLabel.setLayoutData((Object)spaceLabelGridData);
        Button upButton = new Button(controlButtons, 8);
        upButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Up_label"));
        GridData upButtonGridData = new GridData();
        upButtonGridData.verticalAlignment = 4;
        upButtonGridData.horizontalAlignment = 4;
        upButton.setLayoutData((Object)upButtonGridData);
        Button downButton = new Button(controlButtons, 8);
        downButton.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Down_label"));
        GridData downButtonGridData = new GridData();
        downButtonGridData.verticalAlignment = 4;
        downButtonGridData.horizontalAlignment = 4;
        downButton.setLayoutData((Object)downButtonGridData);
        Composite featureComposite = new Composite(contents, 0);
        GridData data2 = new GridData(4, 4, true, true);
        data2.horizontalAlignment = 0x1000008;
        featureComposite.setLayoutData((Object)data2);
        GridLayout layout2 = new GridLayout();
        data2.horizontalAlignment = 4;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        layout2.numColumns = 1;
        featureComposite.setLayout((Layout)layout2);
        Label featureLabel = new Label(featureComposite, 0);
        featureLabel.setText(EMFEditUIPlugin.INSTANCE.getString("_UI_Feature_label"));
        GridData featureLabelGridData = new GridData();
        featureLabelGridData.horizontalSpan = 2;
        featureLabelGridData.horizontalAlignment = 4;
        featureLabelGridData.verticalAlignment = 4;
        featureLabel.setLayoutData((Object)featureLabelGridData);
        Table featureTable = new Table(featureComposite, 2050);
        GridData featureTableGridData = new GridData();
        featureTableGridData.widthHint = Display.getCurrent().getBounds().width / 5;
        featureTableGridData.heightHint = Display.getCurrent().getBounds().height / 3;
        featureTableGridData.verticalAlignment = 4;
        featureTableGridData.horizontalAlignment = 4;
        featureTableGridData.grabExcessHorizontalSpace = true;
        featureTableGridData.grabExcessVerticalSpace = true;
        featureTable.setLayoutData((Object)featureTableGridData);
        final TableViewer featureTableViewer = new TableViewer(featureTable);
        featureTableViewer.setContentProvider(this.contentProvider);
        featureTableViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        featureTableViewer.setInput((Object)this.values);
        if (!this.values.getChildren().isEmpty()) {
            featureTableViewer.setSelection((ISelection)new StructuredSelection(this.values.getChildren().get(0)));
        }
        if (choiceTableViewer != null) {
            choiceTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (addButton.isEnabled()) {
                        addButton.notifyListeners(13, null);
                    }
                }
            });
            featureTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    if (removeButton.isEnabled()) {
                        removeButton.notifyListeners(13, null);
                    }
                }
            });
        }
        if (choiceText != null) {
            choiceText.addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (!(ProxyURIFeatureEditorDialog.this.multiLine || event.character != '\r' && event.character != '\n')) {
                        try {
                            Object value = EcoreUtil.createFromString((EDataType)((EDataType)ProxyURIFeatureEditorDialog.this.eClassifier), (String)choiceText.getText());
                            ProxyURIFeatureEditorDialog.this.values.getChildren().add(value);
                            choiceText.setText("");
                            featureTableViewer.setSelection((ISelection)new StructuredSelection(value));
                            event.doit = false;
                        }
                        catch (RuntimeException runtimeException) {}
                    } else if (event.character == '\u001b') {
                        choiceText.setText("");
                        event.doit = false;
                    }
                }
            });
        }
        upButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int minIndex = 0;
                for (Object value : selection) {
                    int index = ProxyURIFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ProxyURIFeatureEditorDialog.this.values.getChildren().move(Math.max(index - 1, minIndex++), value);
                }
            }
        });
        downButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                int maxIndex = ProxyURIFeatureEditorDialog.this.values.getChildren().size() - selection.size();
                for (Object value : selection) {
                    int index = ProxyURIFeatureEditorDialog.this.values.getChildren().indexOf(value);
                    ProxyURIFeatureEditorDialog.this.values.getChildren().move(Math.min(index + 1, maxIndex++), value);
                }
            }
        });
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (choiceTableViewer != null) {
                    IStructuredSelection selection = (IStructuredSelection)choiceTableViewer.getSelection();
                    for (Object value : selection) {
                        if (ProxyURIFeatureEditorDialog.this.values.getChildren().contains(value)) continue;
                        ProxyURIFeatureEditorDialog.this.values.getChildren().add(value);
                    }
                    featureTableViewer.setSelection((ISelection)selection);
                } else if (choiceText != null) {
                    try {
                        Object value = EcoreUtil.createFromString((EDataType)((EDataType)ProxyURIFeatureEditorDialog.this.eClassifier), (String)choiceText.getText());
                        if (!ProxyURIFeatureEditorDialog.this.values.getChildren().contains(value)) {
                            ProxyURIFeatureEditorDialog.this.values.getChildren().add(value);
                            choiceText.setText("");
                        }
                        featureTableViewer.setSelection((ISelection)new StructuredSelection(value));
                    }
                    catch (RuntimeException runtimeException) {}
                }
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                Object firstValue = null;
                for (Object value : selection) {
                    if (firstValue == null) {
                        firstValue = value;
                    }
                    ProxyURIFeatureEditorDialog.this.values.getChildren().remove(value);
                }
                if (!ProxyURIFeatureEditorDialog.this.values.getChildren().isEmpty()) {
                    featureTableViewer.setSelection((ISelection)new StructuredSelection(ProxyURIFeatureEditorDialog.this.values.getChildren().get(0)));
                }
                if (choiceTableViewer != null) {
                    choiceTableViewer.setSelection((ISelection)selection);
                } else if (choiceText != null && firstValue != null) {
                    String value = EcoreUtil.convertToString((EDataType)((EDataType)ProxyURIFeatureEditorDialog.this.eClassifier), firstValue);
                    choiceText.setText(value);
                }
            }
        });
        final Label proxyURILabel = new Label(featureComposite, 0);
        proxyURILabel.setText(Messages.label_editProxyURI);
        proxyURILabel.setLayoutData((Object)new GridData());
        final Text proxyURIText = new Text(featureComposite, 2048);
        GridData proxyURITextGridData = new GridData();
        proxyURITextGridData.horizontalAlignment = 4;
        proxyURITextGridData.grabExcessHorizontalSpace = true;
        proxyURIText.setLayoutData((Object)proxyURITextGridData);
        final Text proxyURIErrorText = new Text(featureComposite, 0);
        proxyURIErrorText.setEditable(false);
        GridData proxyURIErrorTextGridData = new GridData();
        proxyURIErrorTextGridData.horizontalAlignment = 4;
        proxyURIErrorTextGridData.grabExcessHorizontalSpace = true;
        proxyURIErrorText.setLayoutData((Object)proxyURIErrorTextGridData);
        proxyURIText.setVisible(false);
        proxyURILabel.setVisible(false);
        proxyURIErrorText.setVisible(false);
        proxyURIText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InternalEObject oldValue;
                Object selected;
                Diagnostic diagnostic;
                EObject eObject;
                ExtendedResource extendedResource;
                proxyURIErrorText.setText("");
                if (ProxyURIFeatureEditorDialog.this.object instanceof EObject && (extendedResource = ExtendedResourceAdapterFactory.INSTANCE.adapt((Notifier)(eObject = (EObject)ProxyURIFeatureEditorDialog.this.object).eResource())) != null && !Diagnostic.OK_INSTANCE.equals(diagnostic = extendedResource.validateURI(proxyURIText.getText()))) {
                    proxyURIErrorText.setText(diagnostic.getMessage());
                    return;
                }
                IStructuredSelection selection = (IStructuredSelection)featureTableViewer.getSelection();
                if (selection != null && (selected = selection.getFirstElement()) instanceof EObject && (oldValue = (InternalEObject)selected).eIsProxy()) {
                    URI oldProxyURI = oldValue.eProxyURI();
                    URI newProxyURI = URI.createURI((String)proxyURIText.getText());
                    if (!newProxyURI.equals(oldProxyURI)) {
                        EFactory factory = oldValue.eClass().getEPackage().getEFactoryInstance();
                        EObject newValueProxy = factory.create(oldValue.eClass());
                        ((InternalEObject)newValueProxy).eSetProxyURI(newProxyURI);
                        EObject newValue = EcoreUtil.resolve((EObject)newValueProxy, (EObject)((EObject)ProxyURIFeatureEditorDialog.this.object));
                        if (newValue == newValueProxy) {
                            ProxyURIFeatureEditorDialog.this.values.getChildren().remove((Object)oldValue);
                            ProxyURIFeatureEditorDialog.this.values.getChildren().add((Object)newValue);
                            featureTableViewer.refresh();
                        } else if (!ProxyURIFeatureEditorDialog.this.values.getChildren().contains((Object)newValue)) {
                            ProxyURIFeatureEditorDialog.this.values.getChildren().remove((Object)oldValue);
                            ProxyURIFeatureEditorDialog.this.values.getChildren().add((Object)newValue);
                            featureTableViewer.refresh();
                        } else {
                            proxyURIErrorText.setText(Messages.message_proxyURIMustNotReferenceAnAlreadyExistingListElement);
                        }
                    }
                }
            }
        });
        featureTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    if (selection.size() == 1) {
                        Object firstElement = selection.getFirstElement();
                        if (firstElement instanceof EObject) {
                            InternalEObject value = (InternalEObject)firstElement;
                            proxyURILabel.setVisible(value.eIsProxy());
                            if (value.eIsProxy()) {
                                proxyURIText.setText(value.eProxyURI().toString());
                            }
                            proxyURIText.setVisible(value.eIsProxy());
                            proxyURIErrorText.setVisible(value.eIsProxy());
                            if (!value.eIsProxy()) {
                                proxyURIErrorText.setText("");
                            }
                        }
                    } else {
                        proxyURIText.setVisible(false);
                        proxyURILabel.setVisible(false);
                        proxyURIErrorText.setVisible(false);
                        proxyURIErrorText.setText("");
                    }
                }
            }
        });
        choiceTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                proxyURIText.setVisible(false);
                proxyURILabel.setVisible(false);
                proxyURIErrorText.setVisible(false);
                proxyURIErrorText.setText("");
            }
        });
        return contents;
    }
}

