/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.ui.groups;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.fields.IFieldListener;
import org.eclipse.sphinx.platform.ui.fields.SelectionButtonField;
import org.eclipse.sphinx.platform.ui.fields.StringButtonField;
import org.eclipse.sphinx.platform.ui.fields.adapters.IButtonAdapter;
import org.eclipse.sphinx.platform.ui.groups.AbstractGroup;
import org.eclipse.sphinx.platform.ui.preferences.IPropertyPageIdProvider;
import org.eclipse.sphinx.xtendxpand.outlet.ExtendedOutlet;
import org.eclipse.sphinx.xtendxpand.preferences.OutletsPreference;
import org.eclipse.sphinx.xtendxpand.ui.internal.messages.Messages;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.PreferencesUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputGroup
extends AbstractGroup {
    protected SelectionButtonField useDefaultPathButtonField;
    protected StringButtonField outputPathField;
    protected ExtendedOutlet defaultOutlet;
    protected OutletsPreference outletsPreference;
    protected EObject modelObject;

    public OutputGroup(String groupName, EObject modelObject, OutletsPreference outletsPreference, ExtendedOutlet defaultOutlet) {
        this(groupName, modelObject, outletsPreference, defaultOutlet, null);
    }

    public OutputGroup(String groupName, EObject modelObject, OutletsPreference outletsPreference, ExtendedOutlet defaultOutlet, IDialogSettings dialogSettings) {
        super(groupName, dialogSettings);
        this.groupName = groupName;
        this.modelObject = modelObject;
        this.outletsPreference = outletsPreference;
        this.defaultOutlet = defaultOutlet;
    }

    protected void doCreateContent(final Composite parent, int numColumns) {
        parent.setLayout((Layout)new GridLayout(numColumns, false));
        if (this.outletsPreference != null) {
            Link link = this.createLink(parent, Messages.label_configureProjectSpecificSettings);
            link.setLayoutData((Object)new GridData(3, 3, true, true));
        } else {
            IContainer defaultOutletContainer;
            this.useDefaultPathButtonField = new SelectionButtonField(32);
            this.useDefaultPathButtonField.setLabelText(Messages.label_useDefaultPath);
            this.useDefaultPathButtonField.fillIntoGrid(parent, numColumns);
            this.useDefaultPathButtonField.setSelection(true);
            this.useDefaultPathButtonField.addFieldListener(new IFieldListener(){

                public void dialogFieldChanged(IField field) {
                    OutputGroup.this.updateEnableState(!OutputGroup.this.useDefaultPathButtonField.isSelected());
                }
            });
            this.outputPathField = new StringButtonField(new IButtonAdapter(){

                public void changeControlPressed(IField field) {
                    ContainerSelectionDialog dialog = new ContainerSelectionDialog(parent.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), true, "");
                    if (dialog.open() == 0) {
                        Object[] result = dialog.getResult();
                        if (result.length == 0) {
                            return;
                        }
                        IPath path = (IPath)result[0];
                        OutputGroup.this.outputPathField.setText(path.makeRelative().toString());
                    }
                }
            });
            this.outputPathField.setLabelText(Messages.label_path);
            this.outputPathField.setButtonLabel(Messages.label_browse);
            if (this.defaultOutlet != null && (defaultOutletContainer = this.defaultOutlet.getContainer()) != null) {
                this.outputPathField.setText(defaultOutletContainer.getFullPath().makeRelative().toString());
            }
            this.outputPathField.fillIntoGrid(parent, numColumns);
            this.outputPathField.addFieldListener(new IFieldListener(){

                public void dialogFieldChanged(IField field) {
                    OutputGroup.this.notifyGroupChanged((IField)OutputGroup.this.outputPathField);
                }
            });
            this.updateEnableState(!this.useDefaultPathButtonField.isSelected());
        }
    }

    protected Link createLink(final Composite composite, String text) {
        Link link = new Link(composite, 0);
        link.setFont(composite.getFont());
        link.setText("<A>" + text + "</A>");
        link.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OutputGroup.this.doLinkActivated(composite.getShell(), (Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                OutputGroup.this.doLinkActivated(composite.getShell(), (Link)e.widget);
            }
        });
        return link;
    }

    protected void doLinkActivated(Shell shell, Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put("AbstractPreferenceAndPropertyPage.nolink", Boolean.TRUE);
        IFile file = EcorePlatformUtil.getFile((EObject)this.modelObject);
        if (file != null) {
            this.openProjectProperties(shell, file.getProject(), data);
        }
    }

    protected void openProjectProperties(Shell shell, IProject project, Object data) {
        String outletsPropertyPageId;
        IPropertyPageIdProvider provider;
        if (this.outletsPreference != null && (provider = (IPropertyPageIdProvider)Platform.getAdapterManager().loadAdapter((Object)this.outletsPreference, IPropertyPageIdProvider.class.getName())) != null && (outletsPropertyPageId = provider.getPropertyPageId()) != null) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)project, (String)outletsPropertyPageId, (String[])new String[]{outletsPropertyPageId}, (Object)data);
            dialog.open();
        }
    }

    protected void updateEnableState(boolean enabled) {
        this.outputPathField.setEnabled(enabled);
        if (!enabled) {
            if (this.defaultOutlet != null) {
                IContainer defaultOutletContainer = this.defaultOutlet.getContainer();
                if (defaultOutletContainer != null) {
                    this.outputPathField.setText(defaultOutletContainer.getFullPath().makeRelative().toString());
                }
            } else {
                this.outputPathField.setText("");
            }
        }
    }

    public SelectionButtonField getUseDefaultPathButtonField() {
        return this.useDefaultPathButtonField;
    }

    public StringButtonField getOutputPathField() {
        return this.outputPathField;
    }

    public Collection<ExtendedOutlet> getOutlets() {
        IFile file;
        if (this.outletsPreference != null && (file = EcorePlatformUtil.getFile((EObject)this.modelObject)) != null && file.getProject() != null) {
            return (Collection)this.outletsPreference.get(file.getProject());
        }
        IContainer defaultOutletContainer = this.getContainer(this.outputPathField.getText());
        if (defaultOutletContainer != null) {
            this.defaultOutlet = new ExtendedOutlet(defaultOutletContainer);
            return Collections.singletonList(this.defaultOutlet);
        }
        return Collections.emptyList();
    }

    protected IContainer getContainer(String fullPath) {
        if (fullPath != null && fullPath.length() > 0) {
            Path path = new Path(fullPath);
            path.makeAbsolute();
            if (path.segmentCount() == 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
            }
            return ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        }
        return null;
    }

    public boolean isGroupComplete() {
        if (this.outletsPreference == null && this.useDefaultPathButtonField != null && !this.useDefaultPathButtonField.isSelected()) {
            return this.getContainer(this.outputPathField.getText()) != null;
        }
        return super.isGroupComplete();
    }
}

