/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicRenameAction
extends BaseSelectionListenerAction {
    private static final String NAME = "name";
    private static final String ID = "id";
    private TreeViewer viewer;
    private Map<EClass, NameAttributeInfo> nameAttributeCache = new WeakHashMap<EClass, NameAttributeInfo>();
    private Composite textEditorParent;
    private Text textEditor;
    private TreeEditor treeEditor;
    private boolean saving;

    public BasicRenameAction() {
        super(Messages.menuItem_rename);
    }

    public BasicRenameAction(String text) {
        super(text);
    }

    public BasicRenameAction(TreeViewer viewer) {
        super(Messages.menuItem_rename);
        this.viewer = viewer;
    }

    public BasicRenameAction(String text, TreeViewer viewer) {
        super(text);
        this.viewer = viewer;
    }

    public void run() {
        Object object;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() == 1 && (object = AdapterFactoryEditingDomain.unwrap((Object)selection.getFirstElement())) instanceof EObject) {
            EObject target = (EObject)object;
            if (this.viewer == null) {
                String oldName = this.getOldName(target);
                if (oldName == null) {
                    oldName = "";
                }
                String newName = oldName;
                newName = this.changeNameDialog(ExtendedPlatformUI.getActiveShell(), oldName);
                if (!oldName.equals(newName)) {
                    this.execRename(target, newName);
                }
            } else {
                this.inlineEditor(target);
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof EObject && this.hasNameAttribute((EObject)selected)) {
                return true;
            }
            if (selected instanceof IWrapperItemProvider) {
                Object unwrap = AdapterFactoryEditingDomain.unwrap((Object)selected);
                return this.updateSelection((IStructuredSelection)new StructuredSelection(unwrap));
            }
        }
        return false;
    }

    protected String getOldName(EObject object) {
        if (this.hasNameAttribute(object)) {
            Object nameAttributeValue = object.eGet((EStructuralFeature)this.getNameAttribute(object));
            return nameAttributeValue.toString();
        }
        return "";
    }

    protected EAttribute getNameAttribute(EObject object) {
        ArrayList<EClass> eTypes = new ArrayList<EClass>();
        eTypes.add(object.eClass());
        eTypes.addAll((Collection<EClass>)object.eClass().getEAllSuperTypes());
        for (EClass eType : eTypes) {
            NameAttributeInfo info;
            if (!this.nameAttributeCache.containsKey(eType) || (info = this.nameAttributeCache.get(eType)).isFallback()) continue;
            return info.getEAttribute();
        }
        NameAttributeInfo info = this.getNameAttribute((List<EAttribute>)object.eClass().getEAllAttributes());
        if (info != null) {
            if (!this.nameAttributeCache.containsKey(info.getEAttribute().getEContainingClass())) {
                this.nameAttributeCache.put(info.getEAttribute().getEContainingClass(), info);
            }
            return info.getEAttribute();
        }
        return null;
    }

    protected NameAttributeInfo getNameAttribute(List<EAttribute> nameAttributeCandidates) {
        EAttribute nameAttribute = null;
        boolean isFallback = true;
        for (EAttribute attribute : nameAttributeCandidates) {
            String attributeName = attribute.getName();
            if (attributeName == null) continue;
            if (attributeName.equalsIgnoreCase(NAME)) {
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.equalsIgnoreCase(ID)) {
                if (nameAttribute != null && nameAttribute.getName().toLowerCase().endsWith(NAME)) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.toLowerCase().endsWith(NAME)) {
                if (nameAttribute != null && (nameAttribute.getName().toLowerCase().endsWith(NAME) || nameAttribute.getName().equalsIgnoreCase(ID))) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (attributeName.toLowerCase().indexOf(NAME) != -1) {
                if (nameAttribute != null && (nameAttribute.getName().toLowerCase().indexOf(NAME) != -1 || nameAttribute.getName().equalsIgnoreCase(ID))) continue;
                nameAttribute = attribute;
                isFallback = false;
                continue;
            }
            if (nameAttribute != null) continue;
            nameAttribute = attribute;
        }
        return nameAttribute != null ? new NameAttributeInfo(nameAttribute, isFallback) : null;
    }

    protected boolean hasNameAttribute(EObject object) {
        return this.getNameAttribute(object) != null;
    }

    protected void execRename(EObject objectToRename, String newName) {
        EFactory attributeValueFactory;
        Object attributeValue;
        EAttribute attribute;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)objectToRename);
        Command command = editingDomain.createCommand(SetCommand.class, new CommandParameter((Object)objectToRename, (Object)(attribute = this.getNameAttribute(objectToRename)), attributeValue = (attributeValueFactory = attribute.getEType().getEPackage().getEFactoryInstance()).createFromString((EDataType)attribute.getEType(), newName)));
        if (command.canExecute()) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    protected String changeNameDialog(Shell shell, String oldName) {
        InputDialog dialog = new InputDialog(shell, Messages.label_renameDialogTitle, Messages.label_renameDialogMessage, oldName, null);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return oldName;
    }

    protected void inlineEditor(EObject object) {
        String oldName;
        if (this.textEditorParent == null) {
            this.createTextEditor(object);
        }
        if ((oldName = this.getOldName(object)) != null) {
            this.textEditor.setText(oldName);
        }
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = 1;
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    protected void createTextEditor(final EObject objectToRename) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = BasicRenameAction.this.textEditor.getSize();
                Point parentSize = BasicRenameAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.viewer.getTree().getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = BasicRenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = BasicRenameAction.this.textEditorParent.getSize();
                BasicRenameAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                BasicRenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        BasicRenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        BasicRenameAction.this.saveChangesAndDispose(objectToRename);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                BasicRenameAction.this.saveChangesAndDispose(objectToRename);
            }
        });
    }

    protected void disposeTextWidget() {
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            if (this.treeEditor != null) {
                this.treeEditor.dispose();
                this.treeEditor = null;
            }
        }
    }

    protected void saveChangesAndDispose(EObject object) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        final EObject inlinedObject = object;
        final String newName = this.textEditor.getText();
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    String oldName = BasicRenameAction.this.getOldName(inlinedObject);
                    if (oldName == null) {
                        oldName = "";
                    }
                    if (!oldName.equals(newName)) {
                        BasicRenameAction.this.execRename(inlinedObject, newName);
                        if (BasicRenameAction.this.viewer != null) {
                            BasicRenameAction.this.viewer.refresh((Object)inlinedObject, true);
                        }
                    }
                    BasicRenameAction.this.disposeTextWidget();
                    if (BasicRenameAction.this.viewer != null) {
                        BasicRenameAction.this.viewer.refresh((Object)inlinedObject, true);
                    }
                }
                finally {
                    BasicRenameAction.this.saving = false;
                }
            }
        };
        ExtendedPlatformUI.getDisplay().asyncExec(runnable);
    }

    protected EAttribute cacheAttribute(NameAttributeInfo nameAttribute) {
        if (!this.nameAttributeCache.containsKey(nameAttribute.getEAttribute().getEContainingClass())) {
            this.nameAttributeCache.put(nameAttribute.getEAttribute().getEContainingClass(), nameAttribute);
        }
        return nameAttribute.getEAttribute();
    }

    protected Composite createParent() {
        Tree tree = this.viewer.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor = new TreeEditor(tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private class NameAttributeInfo {
        private WeakReference<EAttribute> eAttribute;
        private boolean isFallback;

        public NameAttributeInfo(EAttribute attr, boolean isFallback) {
            Assert.isNotNull((Object)attr);
            this.eAttribute = new WeakReference<EAttribute>(attr);
            this.isFallback = isFallback;
        }

        public EAttribute getEAttribute() {
            return (EAttribute)this.eAttribute.get();
        }

        public boolean isFallback() {
            return this.isFallback;
        }
    }
}

