/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.headless;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sphinx.emf.mwe.dynamic.headless.IWorkflowRunnerCLIConstants;
import org.eclipse.sphinx.emf.mwe.dynamic.operations.BasicWorkflowRunnerOperation;
import org.eclipse.sphinx.emf.mwe.dynamic.util.WorkflowRunnerHelper;
import org.eclipse.sphinx.platform.cli.AbstractCLIApplication;
import org.eclipse.sphinx.platform.cli.ICommonCLIConstants;

public class BasicWorkflowRunnerApplication
extends AbstractCLIApplication {
    protected WorkflowRunnerHelper helper = new WorkflowRunnerHelper();

    protected String getCommandLineSyntax() {
        return String.format(ICommonCLIConstants.COMMAND_LINE_SYNTAX_FORMAT_WITH_WORKSPACE, IWorkflowRunnerCLIConstants.APPLICATION_NAME);
    }

    protected void defineOptions() {
        super.defineOptions();
        OptionBuilder.isRequired();
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)IWorkflowRunnerCLIConstants.OPTION_WORKFLOW_ARG_NAME);
        OptionBuilder.withDescription((String)IWorkflowRunnerCLIConstants.OPTION_WORKFLOW_DESCRIPTION);
        this.addOption(OptionBuilder.create((String)"workflow"));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)IWorkflowRunnerCLIConstants.OPTION_MODEL_ARG_NAME);
        OptionBuilder.withDescription((String)IWorkflowRunnerCLIConstants.OPTION_MODEL_DESCRIPTION);
        this.addOption(OptionBuilder.create((String)"model"));
        this.addOption(new Option("skipSave", IWorkflowRunnerCLIConstants.OPTION_SKIP_SAVE_DESCRIPTION));
    }

    protected Object interrogate() throws Throwable {
        super.interrogate();
        CommandLine commandLine = this.getCommandLine();
        String workflowOptionValue = commandLine.getOptionValue("workflow");
        String modelOptionValue = commandLine.getOptionValue("model");
        boolean skipSaveOption = commandLine.hasOption("skipSave");
        Object workflow = this.helper.toWorkflowObject(workflowOptionValue);
        BasicWorkflowRunnerOperation operation = this.createWorkflowRunnerOperation(workflow);
        URI modelURI = this.helper.toModelURIObject(modelOptionValue);
        if (modelURI != null) {
            operation.getModelURIs().add(modelURI);
        }
        operation.setAutoSave(!skipSaveOption);
        operation.run(this.createProgressMonitor());
        return ERROR_NO;
    }

    protected BasicWorkflowRunnerOperation createWorkflowRunnerOperation(Object workflow) {
        return new BasicWorkflowRunnerOperation(IWorkflowRunnerCLIConstants.APPLICATION_NAME, workflow);
    }

    protected IProgressMonitor createProgressMonitor() {
        return new NullProgressMonitor();
    }
}

