/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.internal.referentialintegrity;

import java.util.WeakHashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;

public class IntermittentRemoveTracker
extends WeakHashMap<EObject, URI> {
    protected static final int MAX_INTERMITTENT_REMOVE_DEFAULT_INTERVAL = 1000;
    private long maxIntermittentRemoveInterval = 1000L;
    private long lastDecreteRemoveTime = System.currentTimeMillis();

    public long getMaxIntermittentRemoveInterval() {
        return this.maxIntermittentRemoveInterval;
    }

    public void setMaxIntermittentRemoveInterval(long maxIntermittentRemoveInterval) {
        this.maxIntermittentRemoveInterval = maxIntermittentRemoveInterval;
    }

    protected void updateLastDiscreteRemoveTime() {
        this.lastDecreteRemoveTime = System.currentTimeMillis();
    }

    protected boolean isIntermittentRemoveInProgress() {
        return System.currentTimeMillis() - this.lastDecreteRemoveTime > this.maxIntermittentRemoveInterval;
    }

    @Override
    public URI put(EObject eObject, URI oldURI) {
        this.updateLastDiscreteRemoveTime();
        return super.put(eObject, oldURI);
    }

    public void clearObsoleteEntries() {
        if (this.isIntermittentRemoveInProgress()) {
            this.clear();
        }
    }
}

