/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.ui.actions;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.ui.util.RetrieveNameAttributeHelper;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.BaseSelectionListenerAction;

public class BasicRenameAction
extends BaseSelectionListenerAction {
    private RetrieveNameAttributeHelper helper = new RetrieveNameAttributeHelper();
    private TreeViewer viewer;
    private Composite textEditorParent;
    private Text textEditor;
    private TreeEditor treeEditor;
    private boolean saving;

    public BasicRenameAction() {
        super(Messages.action_rename_label);
    }

    public BasicRenameAction(String text) {
        super(text);
    }

    public BasicRenameAction(TreeViewer viewer) {
        this(Messages.action_rename_label);
        this.viewer = viewer;
    }

    public BasicRenameAction(String text, TreeViewer viewer) {
        this(text);
        this.viewer = viewer;
    }

    public void run() {
        Object object;
        IStructuredSelection selection = this.getStructuredSelection();
        if (selection.size() == 1 && (object = AdapterFactoryEditingDomain.unwrap((Object)selection.getFirstElement())) instanceof EObject) {
            EObject target = (EObject)object;
            if (this.viewer == null) {
                String oldName = this.getOldName(target);
                if (oldName == null) {
                    oldName = "";
                }
                String newName = oldName;
                newName = this.changeNameDialog(ExtendedPlatformUI.getActiveShell(), oldName);
                if (!oldName.equals(newName)) {
                    this.execRename(target, newName);
                }
            } else {
                this.inlineEditor(target);
            }
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        if (selection.size() == 1) {
            Object selected = selection.getFirstElement();
            if (selected instanceof EObject && this.helper.hasNameAttribute((EObject)selected)) {
                return true;
            }
            if (selected instanceof IWrapperItemProvider) {
                Object unwrap = AdapterFactoryEditingDomain.unwrap((Object)selected);
                return this.updateSelection((IStructuredSelection)new StructuredSelection(unwrap));
            }
        }
        return false;
    }

    protected String getOldName(EObject object) {
        if (this.helper.hasNameAttribute(object)) {
            Object nameAttributeValue = object.eGet((EStructuralFeature)this.helper.getNameAttribute(object));
            return nameAttributeValue.toString();
        }
        return "";
    }

    protected void execRename(EObject objectToRename, String newName) {
        EFactory attributeValueFactory;
        Object attributeValue;
        EAttribute attribute;
        TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)objectToRename);
        Command command = editingDomain.createCommand(SetCommand.class, new CommandParameter((Object)objectToRename, (Object)(attribute = this.helper.getNameAttribute(objectToRename)), attributeValue = (attributeValueFactory = attribute.getEType().getEPackage().getEFactoryInstance()).createFromString((EDataType)attribute.getEType(), newName)));
        if (command.canExecute()) {
            editingDomain.getCommandStack().execute(command);
        }
    }

    protected String changeNameDialog(Shell shell, String oldName) {
        InputDialog dialog = new InputDialog(shell, Messages.dialog_rename_title, Messages.dialog_rename_message, oldName, null);
        dialog.setBlockOnOpen(true);
        int result = dialog.open();
        if (result == 0) {
            return dialog.getValue();
        }
        return oldName;
    }

    protected void inlineEditor(EObject object) {
        String oldName;
        if (this.textEditorParent == null) {
            this.createTextEditor(object);
        }
        if ((oldName = this.getOldName(object)) != null) {
            this.textEditor.setText(oldName);
        }
        this.textEditorParent.setVisible(true);
        Point textSize = this.textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this.textEditorParent.getSize();
        int inset = 1;
        this.textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this.textEditorParent.redraw();
        this.textEditor.selectAll();
        this.textEditor.setFocus();
    }

    protected void createTextEditor(final EObject objectToRename) {
        this.textEditorParent = this.createParent();
        this.textEditorParent.setVisible(false);
        boolean inset = true;
        this.textEditorParent.addListener(9, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = BasicRenameAction.this.textEditor.getSize();
                Point parentSize = BasicRenameAction.this.textEditorParent.getSize();
                e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
            }
        });
        this.textEditor = new Text(this.textEditorParent, 0);
        this.textEditor.setFont(this.viewer.getTree().getFont());
        this.textEditorParent.setBackground(this.textEditor.getBackground());
        this.textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = BasicRenameAction.this.textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = BasicRenameAction.this.textEditorParent.getSize();
                BasicRenameAction.this.textEditor.setBounds(2, 1, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2);
                BasicRenameAction.this.textEditorParent.redraw();
            }
        });
        this.textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        BasicRenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        BasicRenameAction.this.saveChangesAndDispose(objectToRename);
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this.textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                BasicRenameAction.this.saveChangesAndDispose(objectToRename);
            }
        });
    }

    protected void disposeTextWidget() {
        if (this.textEditorParent != null) {
            this.textEditorParent.dispose();
            this.textEditorParent = null;
            this.textEditor = null;
            if (this.treeEditor != null) {
                this.treeEditor.dispose();
                this.treeEditor = null;
            }
        }
    }

    protected void saveChangesAndDispose(EObject object) {
        if (this.saving) {
            return;
        }
        this.saving = true;
        final EObject inlinedObject = object;
        final String newName = this.textEditor.getText();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    String oldName = BasicRenameAction.this.getOldName(inlinedObject);
                    if (oldName == null) {
                        oldName = "";
                    }
                    if (!oldName.equals(newName)) {
                        BasicRenameAction.this.execRename(inlinedObject, newName);
                        if (BasicRenameAction.this.viewer != null) {
                            BasicRenameAction.this.viewer.refresh((Object)inlinedObject, true);
                        }
                    }
                    BasicRenameAction.this.disposeTextWidget();
                    if (BasicRenameAction.this.viewer != null) {
                        BasicRenameAction.this.viewer.refresh((Object)inlinedObject, true);
                    }
                }
                finally {
                    BasicRenameAction.this.saving = false;
                }
            }
        };
        ExtendedPlatformUI.getDisplay().asyncExec(runnable);
    }

    protected Composite createParent() {
        Tree tree = this.viewer.getTree();
        Composite result = new Composite((Composite)tree, 0);
        TreeItem[] selectedItems = tree.getSelection();
        this.treeEditor = new TreeEditor(tree);
        this.treeEditor.horizontalAlignment = 16384;
        this.treeEditor.grabHorizontal = true;
        this.treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }
}

