/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.map.internal;

import java.io.FileReader;
import java.io.IOException;
import java.util.Properties;
import org.eclipse.smarthome.core.transform.AbstractFileTransformationService;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(immediate=true, service={TransformationService.class}, property={"smarthome.transform=MAP"})
public class MapTransformationService
extends AbstractFileTransformationService<Properties> {
    private final Logger logger = LoggerFactory.getLogger(MapTransformationService.class);

    protected String internalTransform(Properties properties, String source) throws TransformationException {
        String target = properties.getProperty(source);
        if (target == null && (target = properties.getProperty("")) == null) {
            throw new TransformationException("Target value not found in map for '" + source + "'");
        }
        this.logger.debug("Transformation resulted in '{}'", (Object)target);
        return target;
    }

    protected Properties internalLoadTransform(String filename) throws TransformationException {
        Properties result = new Properties();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (FileReader reader = new FileReader(filename);){
                result.load(reader);
                return result;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new TransformationException("An error occurred while opening file.", (Throwable)e);
        }
    }
}

