/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.exec.internal;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.eclipse.smarthome.io.net.exec.ExecUtil;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, property={"smarthome.transform=EXEC"})
public class ExecTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(ExecTransformationService.class);

    public @Nullable String transform(String commandLine, String source) throws TransformationException {
        if (commandLine == null || source == null) {
            throw new TransformationException("the given parameters 'commandLine' and 'source' must not be null");
        }
        this.logger.debug("about to transform '{}' by the commandline '{}'", (Object)source, (Object)commandLine);
        long startTime = System.currentTimeMillis();
        String formattedCommandLine = String.format(commandLine, source);
        String result = ExecUtil.executeCommandLineAndWaitResponse((String)formattedCommandLine, (int)5000);
        this.logger.trace("command line execution elapsed {} ms", (Object)(System.currentTimeMillis() - startTime));
        return result;
    }
}

