/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.defaultscope.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.smarthome.core.thing.Thing;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.thing.ThingUID;
import org.eclipse.smarthome.core.thing.binding.ThingActions;
import org.eclipse.smarthome.core.thing.binding.ThingActionsScope;
import org.eclipse.smarthome.core.thing.binding.ThingHandler;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

public class ScriptThingActions {
    private static final Map<String, ThingActions> thingActionsMap = new HashMap<String, ThingActions>();
    private ThingRegistry thingRegistry;

    ScriptThingActions(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    public void dispose() {
        this.thingRegistry = null;
    }

    public ThingActions get(String scope, String thingUid) {
        ThingHandler handler;
        ThingUID uid = new ThingUID(thingUid);
        Thing thing = this.thingRegistry.get(uid);
        if (thing != null && (handler = thing.getHandler()) != null) {
            ThingActions thingActions = thingActionsMap.get(ScriptThingActions.getKey(scope, thingUid));
            return thingActions;
        }
        return null;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, cardinality=ReferenceCardinality.MULTIPLE)
    void addThingActions(ThingActions thingActions) {
        String key = ScriptThingActions.getKey(thingActions);
        thingActionsMap.put(key, thingActions);
    }

    void removeThingActions(ThingActions thingActions) {
        String key = ScriptThingActions.getKey(thingActions);
        thingActionsMap.remove(key);
    }

    private static String getKey(ThingActions thingActions) {
        String scope = ScriptThingActions.getScope(thingActions);
        String thingUID = ScriptThingActions.getThingUID(thingActions);
        return ScriptThingActions.getKey(scope, thingUID);
    }

    private static String getKey(String scope, String thingUID) {
        return String.valueOf(scope) + "-" + thingUID;
    }

    private static String getThingUID(ThingActions actions) {
        return actions.getThingHandler().getThing().getUID().getAsString();
    }

    private static String getScope(ThingActions actions) {
        ThingActionsScope scopeAnnotation = actions.getClass().getAnnotation(ThingActionsScope.class);
        return scopeAnnotation.name();
    }
}

