/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.transform.regex.internal;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.smarthome.core.transform.TransformationException;
import org.eclipse.smarthome.core.transform.TransformationService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegExTransformationService
implements TransformationService {
    private final Logger logger = LoggerFactory.getLogger(RegExTransformationService.class);
    private static final Pattern substPattern = Pattern.compile("^s/(.*?[^\\\\])/(.*?[^\\\\])/(.*)$");

    public String transform(String regExpression, String source) throws TransformationException {
        Matcher matcher;
        if (regExpression == null || source == null) {
            throw new TransformationException("the given parameters 'regex' and 'source' must not be null");
        }
        this.logger.debug("about to transform '{}' by the function '{}'", (Object)source, (Object)regExpression);
        String result = "";
        Matcher substMatcher = substPattern.matcher(regExpression);
        if (substMatcher.matches()) {
            this.logger.debug("Using substitution form of regex transformation");
            String regex = substMatcher.group(1);
            String substitution = substMatcher.group(2);
            String options = substMatcher.group(3);
            result = options.equals("g") ? source.trim().replaceAll(regex, substitution) : source.trim().replaceFirst(regex, substitution);
            if (result != null) {
                return result;
            }
        }
        if (!(matcher = Pattern.compile("^" + regExpression + "$", 32).matcher(source.trim())).matches()) {
            this.logger.debug("the given regex '^{}$' doesn't match the given content '{}' -> couldn't compute transformation", (Object)regExpression, (Object)source);
            return null;
        }
        matcher.reset();
        while (matcher.find()) {
            if (matcher.groupCount() == 0) {
                this.logger.info("the given regular expression '^{}$' doesn't contain a group. No content will be extracted and returned!", (Object)regExpression);
                continue;
            }
            result = matcher.group(1);
            if (matcher.groupCount() <= 1) continue;
            this.logger.debug("the given regular expression '^{}$' contains more than one group. Only the first group will be returned!", (Object)regExpression);
        }
        return result;
    }
}

