/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.storage.mapdb.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapterFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.smarthome.core.storage.DeletableStorage;
import org.eclipse.smarthome.storage.mapdb.internal.PropertiesTypeAdapterFactory;
import org.mapdb.DB;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class MapDbStorage<T>
implements DeletableStorage<T> {
    private static final String TYPE_SEPARATOR = "@@@";
    private final Logger logger = LoggerFactory.getLogger(MapDbStorage.class);
    private final String name;
    private final DB db;
    private final ClassLoader classLoader;
    private Map<String, String> map;
    private transient Gson mapper;

    public MapDbStorage(DB db, String name, ClassLoader classLoader) {
        this.name = name;
        this.db = db;
        this.classLoader = classLoader;
        this.map = db.createTreeMap(name).makeOrGet();
        this.mapper = new GsonBuilder().registerTypeAdapterFactory((TypeAdapterFactory)new PropertiesTypeAdapterFactory()).create();
    }

    public void delete() {
        this.map = Collections.emptyMap();
        this.db.delete(this.name);
    }

    public @Nullable T put(String key, @Nullable T value) {
        if (value == null) {
            return this.remove(key);
        }
        String previousValue = this.map.put(key, this.serialize(value));
        this.db.commit();
        return this.deserialize(previousValue);
    }

    public @Nullable T remove(String key) {
        String removedElement = this.map.remove(key);
        this.db.commit();
        return this.deserialize(removedElement);
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public @Nullable T get(String key) {
        return this.deserialize(this.map.get(key));
    }

    public Collection<String> getKeys() {
        return new HashSet<String>(this.map.keySet());
    }

    public Collection<@Nullable T> getValues() {
        ArrayList<@Nullable T> values = new ArrayList<T>();
        for (String key : this.getKeys()) {
            values.add(this.get(key));
        }
        return values;
    }

    private String serialize(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Cannot serialize NULL");
        }
        String valueTypeName = value.getClass().getName();
        String valueAsString = this.mapper.toJson(value);
        String concatValue = String.valueOf(valueTypeName) + TYPE_SEPARATOR + valueAsString;
        this.logger.trace("serialized value '{}' to MapDB", (Object)concatValue);
        return concatValue;
    }

    public @Nullable T deserialize(@Nullable String json) {
        if (json == null) {
            return null;
        }
        String[] concatValue = json.split(TYPE_SEPARATOR);
        String valueTypeName = concatValue[0];
        String valueAsString = concatValue[1];
        Object value = null;
        try {
            Class<?> loadedValueType = null;
            loadedValueType = this.classLoader == null ? Class.forName(valueTypeName) : this.classLoader.loadClass(valueTypeName);
            value = this.mapper.fromJson(valueAsString, loadedValueType);
            this.logger.trace("deserialized value '{}' from MapDB", value);
        }
        catch (Exception e) {
            this.logger.warn("Couldn't deserialize value '{}'. Root cause is: {}", (Object)json, (Object)e.getMessage());
        }
        return (T)value;
    }
}

