/**
 * Copyright (c) 2014,2017 Contributors to the Eclipse Foundation
 * 
 * See the NOTICE file(s) distributed with this work for additional
 * information regarding copyright ownership.
 * 
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0
 * 
 * SPDX-License-Identifier: EPL-2.0
 */
package org.eclipse.smarthome.model.script;

import com.google.inject.Binder;
import com.google.inject.name.Names;
import org.eclipse.smarthome.model.script.AbstractScriptRuntimeModule;
import org.eclipse.smarthome.model.script.interpreter.ScriptInterpreter;
import org.eclipse.smarthome.model.script.scoping.ActionClassLoader;
import org.eclipse.smarthome.model.script.scoping.ScriptImplicitlyImportedTypes;
import org.eclipse.smarthome.model.script.scoping.ScriptImportSectionNamespaceScopeProvider;
import org.eclipse.xtext.common.types.access.IJvmTypeProvider;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeProviderFactory;
import org.eclipse.xtext.common.types.access.reflect.ReflectionTypeScopeProvider;
import org.eclipse.xtext.common.types.xtext.AbstractTypeScopeProvider;
import org.eclipse.xtext.generator.IGenerator;
import org.eclipse.xtext.linking.lazy.LazyURIEncoder;
import org.eclipse.xtext.scoping.IScopeProvider;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.xbase.interpreter.IExpressionInterpreter;
import org.eclipse.xtext.xbase.scoping.batch.ImplicitlyImportedFeatures;

/**
 * Use this class to register components to be used at runtime / without the Equinox extension registry.
 * @author Oliver Libutzki - Initial contribution
 */
@SuppressWarnings("restriction")
public class ScriptRuntimeModule extends AbstractScriptRuntimeModule {
  public Class<? extends ImplicitlyImportedFeatures> bindImplicitlyImportedTypes() {
    return ScriptImplicitlyImportedTypes.class;
  }
  
  @Override
  public Class<? extends IExpressionInterpreter> bindIExpressionInterpreter() {
    return ScriptInterpreter.class;
  }
  
  @Override
  public Class<? extends IGenerator> bindIGenerator() {
    return IGenerator.NullGenerator.class;
  }
  
  @Override
  public void configureIScopeProviderDelegate(final Binder binder) {
    binder.<IScopeProvider>bind(IScopeProvider.class).annotatedWith(Names.named(AbstractDeclarativeScopeProvider.NAMED_DELEGATE)).to(
      ScriptImportSectionNamespaceScopeProvider.class);
  }
  
  @Override
  public Class<? extends IJvmTypeProvider.Factory> bindIJvmTypeProvider$Factory() {
    return ReflectionTypeProviderFactory.class;
  }
  
  @Override
  public Class<? extends AbstractTypeScopeProvider> bindAbstractTypeScopeProvider() {
    return ReflectionTypeScopeProvider.class;
  }
  
  @Override
  public ClassLoader bindClassLoaderToInstance() {
    ClassLoader _bindClassLoaderToInstance = super.bindClassLoaderToInstance();
    return new ActionClassLoader(_bindClassLoaderToInstance);
  }
  
  @Override
  public void configureUseIndexFragmentsForLazyLinking(final Binder binder) {
    binder.<Boolean>bind(Boolean.TYPE).annotatedWith(Names.named(LazyURIEncoder.USE_INDEXED_FRAGMENTS_BINDING)).toInstance(
      Boolean.FALSE);
  }
}
