/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.io.console.internal.extension;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.smarthome.core.common.registry.Identifiable;
import org.eclipse.smarthome.core.items.GenericItem;
import org.eclipse.smarthome.core.items.Item;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.items.ManagedItemProvider;
import org.eclipse.smarthome.io.console.Console;
import org.eclipse.smarthome.io.console.extensions.AbstractConsoleCommandExtension;

public class ItemConsoleCommandExtension
extends AbstractConsoleCommandExtension {
    private static final String SUBCMD_LIST = "list";
    private static final String SUBCMD_CLEAR = "clear";
    private static final String SUBCMD_REMOVE = "remove";
    private static final String SUBCMD_ADDTAG = "addTag";
    private static final String SUBCMD_RMTAG = "rmTag";
    private ItemRegistry itemRegistry;
    private ManagedItemProvider managedItemProvider;

    public ItemConsoleCommandExtension() {
        super("items", "Access the item registry.");
    }

    @Override
    public List<String> getUsages() {
        return Arrays.asList(this.buildCommandUsage("list [<pattern>]", "lists names and types of all items (matching the pattern, if given)"), this.buildCommandUsage(SUBCMD_CLEAR, "removes all items"), this.buildCommandUsage("remove <itemName>", "removes the given item"), this.buildCommandUsage("addTag <itemName> <tag>", "adds a tag to the given item"), this.buildCommandUsage("rmTag <itemName> <tag>", "removes a tag from the given item"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void execute(String[] args, Console console) {
        block22: {
            String subCommand;
            if (args.length <= 0) break block22;
            switch (subCommand = args[0]) {
                case "list": {
                    this.listItems(console, args.length < 2 ? "*" : args[1]);
                    return;
                }
                case "clear": {
                    this.removeItems(console, this.itemRegistry.getAll());
                    return;
                }
                case "remove": {
                    if (args.length > 1) {
                        String name = args[1];
                        Item item = (Item)this.itemRegistry.get((Object)name);
                        this.removeItems(console, Collections.singleton(item));
                        return;
                    }
                    console.println("Specify the name of the item to remove: " + this.getCommand() + " " + SUBCMD_REMOVE + " <itemName>");
                    return;
                }
                case "addTag": {
                    if (args.length > 2) {
                        Item item = (Item)this.itemRegistry.get((Object)args[1]);
                        if (!(item instanceof GenericItem)) return;
                        GenericItem gItem = (GenericItem)item;
                        this.handleTags(arg_0 -> ((GenericItem)gItem).addTag(arg_0), args[2], gItem, console);
                        return;
                    }
                    console.println("Specify the name of the item and the tag: " + this.getCommand() + " " + SUBCMD_ADDTAG + " <itemName> <tag>");
                    return;
                }
                case "rmTag": {
                    if (args.length > 2) {
                        Item item = (Item)this.itemRegistry.get((Object)args[1]);
                        if (!(item instanceof GenericItem)) return;
                        GenericItem gItem = (GenericItem)item;
                        this.handleTags(arg_0 -> ((GenericItem)gItem).removeTag(arg_0), args[2], gItem, console);
                        return;
                    }
                    console.println("Specify the name of the item and the tag: " + this.getCommand() + " " + SUBCMD_RMTAG + " <itemName> <tag>");
                    return;
                }
                default: {
                    console.println("Unknown command '" + subCommand + "'");
                    this.printUsage(console);
                    return;
                }
            }
        }
        this.printUsage(console);
    }

    private <T> void handleTags(Consumer<T> func, T tag, GenericItem gItem, Console console) {
        if (this.managedItemProvider.get((Object)gItem.getName()) != null) {
            func.accept(tag);
            Item oldItem = (Item)this.itemRegistry.update((Identifiable)gItem);
            if (oldItem != null) {
                console.println("Successfully changed tag " + tag + " on item " + gItem.getName());
            }
        } else {
            console.println("Error: Cannot change tag " + tag + " on item " + gItem.getName() + " because this item does not belong to a ManagedProvider");
        }
    }

    private void removeItems(Console console, Collection<Item> items) {
        int count = items.size();
        for (Item item : items) {
            this.itemRegistry.remove((Object)item.getName());
        }
        console.println(String.valueOf(count) + " item(s) removed successfully.");
    }

    private void listItems(Console console, String pattern) {
        Collection items = this.itemRegistry.getItems(pattern);
        if (items.size() > 0) {
            for (Item item : items) {
                console.println(item.toString());
            }
        } else {
            console.println("No item found for this pattern.");
        }
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void setManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = managedItemProvider;
    }

    protected void unsetManagedItemProvider(ManagedItemProvider managedItemProvider) {
        this.managedItemProvider = null;
    }
}

