/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.ui.basic.internal.render;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.types.State;
import org.eclipse.smarthome.model.sitemap.Widget;
import org.eclipse.smarthome.ui.basic.internal.WebAppActivator;
import org.eclipse.smarthome.ui.basic.internal.WebAppConfig;
import org.eclipse.smarthome.ui.basic.render.RenderException;
import org.eclipse.smarthome.ui.basic.render.WidgetRenderer;
import org.eclipse.smarthome.ui.items.ItemUIRegistry;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWidgetRenderer
implements WidgetRenderer {
    private final Logger logger = LoggerFactory.getLogger(AbstractWidgetRenderer.class);
    protected ItemUIRegistry itemUIRegistry;
    protected WebAppConfig config;
    protected static final String SNIPPET_EXT = ".html";
    protected static final String SNIPPET_LOCATION = "snippets/";
    protected static final Map<String, String> snippetCache = new HashMap<String, String>();

    public void setItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = itemUIRegistry;
    }

    public void unsetItemUIRegistry(ItemUIRegistry itemUIRegistry) {
        this.itemUIRegistry = null;
    }

    public ItemUIRegistry getItemUIRegistry() {
        return this.itemUIRegistry;
    }

    protected void activate(ComponentContext context) {
    }

    protected void deactivate(ComponentContext context) {
    }

    protected synchronized String getSnippet(String elementType) throws RenderException {
        String snippet = snippetCache.get(elementType = elementType.toLowerCase());
        if (snippet == null) {
            String snippetLocation = SNIPPET_LOCATION + elementType + SNIPPET_EXT;
            URL entry = WebAppActivator.getContext().getBundle().getEntry(snippetLocation);
            if (entry != null) {
                try {
                    snippet = IOUtils.toString((InputStream)entry.openStream());
                    snippetCache.put(elementType, snippet);
                }
                catch (IOException e) {
                    this.logger.warn("Cannot load snippet for element type '{}'", (Object)elementType, (Object)e);
                }
            } else {
                throw new RenderException("Cannot find a snippet for element type '" + elementType + "'");
            }
        }
        return snippet;
    }

    public String getLabel(Widget w) {
        String label = this.itemUIRegistry.getLabel(w);
        int index = label.indexOf(91);
        if (index != -1) {
            label = label.substring(0, index);
        }
        return this.escapeHtml(label);
    }

    public String getValue(Widget w) {
        String label = this.itemUIRegistry.getLabel(w);
        int index = label.indexOf(91);
        if (index != -1) {
            return this.escapeHtml(label.substring(index + 1, label.length() - 1));
        }
        return "";
    }

    protected String escapeURL(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            this.logger.warn("Cannot escape string '{}'. Returning unmodified string.", (Object)string);
            return string;
        }
    }

    protected String processColor(Widget w, String snippet) {
        String style = "";
        String color = "";
        color = this.itemUIRegistry.getLabelColor(w);
        if (color != null) {
            style = "style=\"color:" + color + "\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%labelstyle%", (String)style);
        style = "";
        color = this.itemUIRegistry.getValueColor(w);
        if (color != null) {
            style = "style=\"color:" + color + "\"";
        }
        snippet = StringUtils.replace((String)snippet, (String)"%valuestyle%", (String)style);
        return snippet;
    }

    protected String getCategory(Widget w) {
        String category = this.escapeURL(this.itemUIRegistry.getCategory(w));
        return category;
    }

    protected String getState(Widget w) {
        State state = this.itemUIRegistry.getState(w);
        if (state != null) {
            return this.escapeURL(state.toString());
        }
        return "NULL";
    }

    protected String escapeHtml(String s) {
        return StringEscapeUtils.escapeHtml((String)s);
    }

    @Override
    public void setConfig(WebAppConfig config) {
        this.config = config;
    }
}

