/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.internal.actions;

import java.util.Iterator;
import org.eclipse.smarthome.model.script.actions.Timer;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.joda.time.base.AbstractInstant;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;
import org.quartz.impl.StdSchedulerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimerImpl
implements Timer {
    private static final Logger logger = LoggerFactory.getLogger(TimerImpl.class);
    public static Scheduler scheduler;
    private JobKey jobKey;
    private TriggerKey triggerKey;
    private AbstractInstant startTime;
    private boolean cancelled = false;
    private boolean terminated = false;

    static {
        try {
            scheduler = StdSchedulerFactory.getDefaultScheduler();
        }
        catch (SchedulerException e) {
            logger.error("initializing scheduler throws exception", (Throwable)e);
        }
    }

    public TimerImpl(JobKey jobKey, TriggerKey triggerKey, AbstractInstant startTime) {
        this.jobKey = jobKey;
        this.triggerKey = triggerKey;
        this.startTime = startTime;
    }

    @Override
    public boolean cancel() {
        try {
            boolean result = scheduler.deleteJob(this.jobKey);
            if (result) {
                this.cancelled = true;
            }
        }
        catch (SchedulerException e) {
            logger.warn("An error occured while cancelling the job '{}': {}", (Object[])new String[]{this.jobKey.toString(), e.getMessage()});
        }
        return this.cancelled;
    }

    @Override
    public boolean reschedule(AbstractInstant newTime) {
        try {
            Trigger trigger = TriggerBuilder.newTrigger().startAt(newTime.toDate()).build();
            scheduler.rescheduleJob(this.triggerKey, trigger);
            this.triggerKey = trigger.getKey();
            this.cancelled = false;
            this.terminated = false;
            return true;
        }
        catch (SchedulerException e) {
            logger.warn("An error occured while rescheduling the job '{}': {}", (Object[])new String[]{this.jobKey.toString(), e.getMessage()});
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isRunning() {
        try {
            JobExecutionContext context;
            Iterator iterator = scheduler.getCurrentlyExecutingJobs().iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(context = (JobExecutionContext)iterator.next()).getJobDetail().getKey().equals((Object)this.jobKey));
            return true;
        }
        catch (SchedulerException e) {
            logger.debug("An error occured getting currently running jobs: {}", (Object)e.getMessage());
            return DateTime.now().isAfter((ReadableInstant)this.startTime) && !this.terminated;
        }
    }

    @Override
    public boolean hasTerminated() {
        return this.terminated;
    }

    public void setTerminated(boolean terminated) {
        this.terminated = terminated;
    }
}

