/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.model.script.actions;

import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.core.scriptengine.Script;
import org.eclipse.smarthome.core.scriptengine.ScriptEngine;
import org.eclipse.smarthome.core.scriptengine.ScriptExecutionException;
import org.eclipse.smarthome.model.core.ModelRepository;
import org.eclipse.smarthome.model.script.actions.Timer;
import org.eclipse.smarthome.model.script.internal.ScriptActivator;
import org.eclipse.smarthome.model.script.internal.actions.TimerExecutionJob;
import org.eclipse.smarthome.model.script.internal.actions.TimerImpl;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.joda.time.base.AbstractInstant;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptExecution {
    private static final Logger logger = LoggerFactory.getLogger(ScriptExecution.class);

    public static Object callScript(String scriptName) throws ScriptExecutionException {
        ModelRepository repo = (ModelRepository)ScriptActivator.modelRepositoryTracker.getService();
        if (repo != null) {
            XExpression expr;
            String scriptNameWithExt = scriptName;
            if (!StringUtils.endsWith((String)scriptName, (String)"script")) {
                scriptNameWithExt = String.valueOf(scriptName) + "." + "script";
            }
            if ((expr = (XExpression)repo.getModel(scriptNameWithExt)) != null) {
                ScriptEngine scriptEngine = (ScriptEngine)ScriptActivator.scriptEngineTracker.getService();
                if (scriptEngine != null) {
                    Script script = scriptEngine.newScriptFromXExpression(expr);
                    return script.execute();
                }
                throw new ScriptExecutionException("Script engine is not available.");
            }
            throw new ScriptExecutionException("Script '" + scriptName + "' cannot be found.");
        }
        throw new ScriptExecutionException("Model repository is not available.");
    }

    public static Timer createTimer(AbstractInstant instant, Procedures.Procedure0 closure) {
        JobKey jobKey = new JobKey(String.valueOf(instant.toString()) + ": " + closure.toString());
        Trigger trigger = TriggerBuilder.newTrigger().startAt(instant.toDate()).build();
        TimerImpl timer = new TimerImpl(jobKey, trigger.getKey(), instant);
        try {
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("procedure", (Object)closure);
            dataMap.put("timer", (Object)timer);
            JobDetail job = JobBuilder.newJob(TimerExecutionJob.class).withIdentity(jobKey).usingJobData(dataMap).build();
            TimerImpl.scheduler.scheduleJob(job, trigger);
            logger.debug("Scheduled code for execution at {}", (Object)instant.toString());
            return timer;
        }
        catch (SchedulerException e) {
            logger.error("Failed to schedule code for execution.", (Throwable)e);
            return null;
        }
    }
}

