/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.binding.bluetooth;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.smarthome.binding.bluetooth.BluetoothDescriptor;
import org.eclipse.smarthome.binding.bluetooth.BluetoothService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BluetoothCharacteristic {
    public static final int FORMAT_UINT8 = 17;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_FLOAT = 52;
    public static final int PROPERTY_BROADCAST = 1;
    public static final int PROPERTY_READ = 2;
    public static final int PROPERTY_WRITE_NO_RESPONSE = 4;
    public static final int PROPERTY_WRITE = 8;
    public static final int PROPERTY_NOTIFY = 16;
    public static final int PROPERTY_INDICATE = 32;
    public static final int PROPERTY_SIGNED_WRITE = 64;
    public static final int PROPERTY_EXTENDED_PROPS = 128;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    public static final int WRITE_TYPE_DEFAULT = 2;
    public static final int WRITE_TYPE_NO_RESPONSE = 1;
    public static final int WRITE_TYPE_SIGNED = 4;
    private final Logger logger = LoggerFactory.getLogger(BluetoothCharacteristic.class);
    protected UUID uuid;
    protected int handle;
    protected Map<UUID, BluetoothDescriptor> gattDescriptors = new HashMap<UUID, BluetoothDescriptor>();
    protected int instance;
    protected int properties;
    protected int permissions;
    protected int writeType;
    protected int[] value = new int[0];
    protected BluetoothService service;

    public BluetoothCharacteristic(UUID uuid, int handle) {
        this.uuid = uuid;
        this.handle = handle;
    }

    public boolean addDescriptor(BluetoothDescriptor descriptor) {
        if (this.gattDescriptors.get(descriptor.getUuid()) != null) {
            return false;
        }
        this.gattDescriptors.put(descriptor.getUuid(), descriptor);
        return true;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public int getInstanceId() {
        return this.instance;
    }

    public int getProperties() {
        return this.properties;
    }

    public int getPermissions() {
        return this.permissions;
    }

    public int getWriteType() {
        return this.writeType;
    }

    public void setWriteType(int writeType) {
        this.writeType = writeType;
    }

    public BluetoothService getService() {
        return this.service;
    }

    public int getHandle() {
        return this.handle;
    }

    public void setService(BluetoothService service) {
        this.service = service;
    }

    public List<BluetoothDescriptor> getDescriptors() {
        return new ArrayList<BluetoothDescriptor>(this.gattDescriptors.values());
    }

    public BluetoothDescriptor getDescriptor(UUID uuid) {
        return this.gattDescriptors.get(uuid);
    }

    public int[] getValue() {
        return this.value;
    }

    public byte[] getByteValue() {
        byte[] byteValue = new byte[this.value.length];
        int cnt = 0;
        while (cnt < this.value.length) {
            byteValue[cnt] = (byte)(this.value[cnt] & 0xFF);
            ++cnt;
        }
        return byteValue;
    }

    public Integer getIntValue(int formatType, int offset) {
        if (offset + this.getTypeLen(formatType) > this.value.length) {
            return null;
        }
        switch (formatType) {
            case 17: {
                return this.unsignedByteToInt(this.value[offset]);
            }
            case 18: {
                return this.unsignedBytesToInt(this.value[offset], this.value[offset + 1]);
            }
            case 20: {
                return this.unsignedBytesToInt(this.value[offset], this.value[offset + 1], this.value[offset + 2], this.value[offset + 3]);
            }
            case 33: {
                return this.unsignedToSigned(this.unsignedByteToInt(this.value[offset]), 8);
            }
            case 34: {
                return this.unsignedToSigned(this.unsignedBytesToInt(this.value[offset], this.value[offset + 1]), 16);
            }
            case 36: {
                return this.unsignedToSigned(this.unsignedBytesToInt(this.value[offset], this.value[offset + 1], this.value[offset + 2], this.value[offset + 3]), 32);
            }
        }
        this.logger.error("Unknown format type {} - no int value can be provided for it.", (Object)formatType);
        return null;
    }

    public Float getFloatValue(int formatType, int offset) {
        if (offset + this.getTypeLen(formatType) > this.value.length) {
            return null;
        }
        switch (formatType) {
            case 50: {
                return Float.valueOf(this.bytesToFloat(this.value[offset], this.value[offset + 1]));
            }
            case 52: {
                return Float.valueOf(this.bytesToFloat(this.value[offset], this.value[offset + 1], this.value[offset + 2], this.value[offset + 3]));
            }
        }
        this.logger.error("Unknown format type {} - no float value can be provided for it.", (Object)formatType);
        return null;
    }

    public String getStringValue(int offset) {
        if (this.value == null || offset > this.value.length) {
            return null;
        }
        byte[] strBytes = new byte[this.value.length - offset];
        int i = 0;
        while (i < this.value.length - offset) {
            strBytes[i] = (byte)this.value[offset + i];
            ++i;
        }
        return new String(strBytes, StandardCharsets.UTF_8);
    }

    public boolean setValue(int[] value) {
        this.value = value;
        return true;
    }

    public boolean setValue(int value, int formatType, int offset) {
        int len = offset + this.getTypeLen(formatType);
        if (this.value == null) {
            this.value = new int[len];
        }
        if (len > this.value.length) {
            return false;
        }
        int val = value;
        switch (formatType) {
            case 33: {
                val = this.intToSignedBits(value, 8);
            }
            case 17: {
                this.value[offset] = (byte)(val & 0xFF);
                break;
            }
            case 34: {
                val = this.intToSignedBits(value, 16);
            }
            case 18: {
                this.value[offset] = (byte)(val & 0xFF);
                this.value[offset + 1] = (byte)(val >> 8 & 0xFF);
                break;
            }
            case 36: {
                val = this.intToSignedBits(value, 32);
            }
            case 20: {
                this.value[offset] = (byte)(val & 0xFF);
                this.value[offset + 1] = (byte)(val >> 8 & 0xFF);
                this.value[offset + 2] = (byte)(val >> 16 & 0xFF);
                this.value[offset + 2] = (byte)(val >> 24 & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValue(int mantissa, int exponent, int formatType, int offset) {
        int len = offset + this.getTypeLen(formatType);
        if (this.value == null) {
            this.value = new int[len];
        }
        if (len > this.value.length) {
            return false;
        }
        switch (formatType) {
            case 50: {
                int m = this.intToSignedBits(mantissa, 12);
                int exp = this.intToSignedBits(exponent, 4);
                this.value[offset] = (byte)(m & 0xFF);
                this.value[offset + 1] = (byte)(m >> 8 & 0xF);
                int n = offset + 1;
                this.value[n] = this.value[n] + (byte)((exp & 0xF) << 4);
                break;
            }
            case 52: {
                int m = this.intToSignedBits(mantissa, 24);
                int exp = this.intToSignedBits(exponent, 8);
                this.value[offset] = (byte)(m & 0xFF);
                this.value[offset + 1] = (byte)(m >> 8 & 0xFF);
                this.value[offset + 2] = (byte)(m >> 16 & 0xFF);
                int n = offset + 2;
                this.value[n] = this.value[n] + (byte)(exp & 0xFF);
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public boolean setValue(byte[] value) {
        this.value = new int[value.length];
        int cnt = 0;
        byte[] byArray = value;
        int n = value.length;
        int n2 = 0;
        while (n2 < n) {
            int val = byArray[n2];
            this.value[cnt++] = val;
            ++n2;
        }
        return true;
    }

    public boolean setValue(String value) {
        this.value = new int[value.getBytes().length];
        int cnt = 0;
        byte[] byArray = value.getBytes();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            int val = byArray[n2];
            this.value[cnt++] = val;
            ++n2;
        }
        return true;
    }

    private int getTypeLen(int formatType) {
        return formatType & 0xF;
    }

    private int unsignedByteToInt(int value) {
        return value & 0xFF;
    }

    private int unsignedBytesToInt(int value1, int value2) {
        return value1 + (value2 << 8);
    }

    private int unsignedBytesToInt(int value1, int value2, int value3, int value4) {
        return value1 + (value2 << 8) + (value3 << 16) + (value4 << 24);
    }

    private float bytesToFloat(int value1, int value2) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(value1) + ((this.unsignedByteToInt(value2) & 0xF) << 8), 12);
        int exponent = this.unsignedToSigned(this.unsignedByteToInt(value2) >> 4, 4);
        return (float)((double)mantissa * Math.pow(10.0, exponent));
    }

    private float bytesToFloat(int value1, int value2, int value3, int value4) {
        int mantissa = this.unsignedToSigned(this.unsignedByteToInt(value1) + (this.unsignedByteToInt(value2) << 8) + (this.unsignedByteToInt(value3) << 16), 24);
        return (float)((double)mantissa * Math.pow(10.0, value4));
    }

    private int unsignedToSigned(int unsigned, int size) {
        if ((unsigned & 1 << size - 1) != 0) {
            return -1 * ((1 << size - 1) - (unsigned & (1 << size - 1) - 1));
        }
        return unsigned;
    }

    private int intToSignedBits(int i, int size) {
        if (i < 0) {
            return (1 << size - 1) + (i & (1 << size - 1) - 1);
        }
        return i;
    }

    public GattCharacteristic getGattCharacteristic() {
        return GattCharacteristic.getCharacteristic(this.uuid);
    }

    public static enum GattCharacteristic {
        ALERT_CATEGORY_ID(10819L),
        ALERT_CATEGORY_ID_BIT_MASK(10818L),
        ALERT_LEVEL(10758L),
        ALERT_NOTIFICATION_CONTROL_POINT(10820L),
        ALERT_STATUS(10815L),
        APPEARANCE(10753L),
        BATTERY_LEVEL(10777L),
        BLOOD_PRESSURE_FEATURE(10825L),
        BLOOD_PRESSURE_MEASUREMENT(10805L),
        BODY_SENSOR_LOCATION(10808L),
        BOOT_KEYOBARD_INPUT_REPORT(10786L),
        BOOT_KEYOBARD_OUTPUT_REPORT(10802L),
        BOOT_MOUSE_INPUT_REPORT(10803L),
        CSC_FEATURE(10844L),
        CSC_MEASUREMENT(10843L),
        CURRENT_TIME(10795L),
        CYCLING_POWER_CONTROL_POINT(10854L),
        CYCLING_POWER_FEATURE(10853L),
        CYCLING_POWER_MEASUREMENT(10851L),
        CYCLING_POWER_VECTOR(10852L),
        DATE_TIME(10760L),
        DAY_DATE_TIME(10762L),
        DAY_OF_WEEK(10761L),
        DEVICE_NAME(10752L),
        DST_OFFSET(10765L),
        EXACT_TIME_256(10764L),
        FIRMWARE_REVISION_STRING(10790L),
        GLUCOSE_FEATURE(10833L),
        GLUCOSE_MEASUREMENT(10776L),
        GLUCOSE_MEASUREMENT_CONTROL(10804L),
        HARDWARE_REVISION_STRING(10791L),
        HEART_RATE_CONTROL_POINT(10809L),
        HEART_RATE_MEASUREMENT(10807L),
        HID_CONTROL_POINT(10828L),
        HID_INFORMATION(10826L),
        IEEE11073_20601_REGULATORY_CERTIFICATION_DATA_LIST(10794L),
        INTERMEDIATE_CUFF_PRESSURE(10806L),
        INTERMEDIATE_TEMPERATURE(10782L),
        LN_CONTROL_POINT(10859L),
        LN_FEATURE(10858L),
        LOCAL_TIME_INFORMATION(10767L),
        LOCATION_AND_SPEED(10855L),
        MANUFACTURER_NAME_STRING(10793L),
        MEASUREMENT_INTERVAL(10785L),
        MODEL_NUMBER_STRING(10788L),
        NAVIGATION(10856L),
        NEW_ALERT(10822L),
        PERIPERAL_PREFFERED_CONNECTION_PARAMETERS(10756L),
        PERIPHERAL_PRIVACY_FLAG(10754L),
        PN_PID(10832L),
        POSITION_QUALITY(10857L),
        PROTOCOL_MODE(10830L),
        RECONNECTION_ADDRESS(10755L),
        RECORD_ACCESS_CONTROL_POINT(10834L),
        REFERENCE_TIME_INFORMATION(10772L),
        REPORT(10829L),
        REPORT_MAP(10827L),
        RINGER_CONTROL_POINT(10816L),
        RINGER_SETTING(10817L),
        RSC_FEATURE(10836L),
        RSC_MEASUREMENT(10835L),
        SC_CONTROL_POINT(10837L),
        SCAN_INTERVAL_WINDOW(10831L),
        SCAN_REFRESH(10801L),
        SENSOR_LOCATION(10845L),
        SERIAL_NUMBER_STRING(10789L),
        SERVICE_CHANGED(10757L),
        SOFTWARE_REVISION_STRING(10792L),
        SUPPORTED_NEW_ALERT_CATEGORY(10823L),
        SUPPORTED_UNREAD_ALERT_CATEGORY(10824L),
        SYSTEM_ID(10787L),
        TEMPERATURE_MEASUREMENT(10780L),
        TEMPERATURE_TYPE(10781L),
        TIME_ACCURACY(10770L),
        TIME_SOURCE(10771L),
        TIME_UPDATE_CONTROL_POINT(10774L),
        TIME_UPDATE_STATE(10775L),
        TIME_WITH_DST(10769L),
        TIME_ZONE(10766L),
        TX_POWER_LEVEL(10759L),
        UNREAD_ALERT_STATUS(10821L),
        AGGREGATE_INPUT(10842L),
        ANALOG_INPUT(10840L),
        ANALOG_OUTPUT(10841L),
        DIGITAL_INPUT(10838L),
        DIGITAL_OUTPUT(10839L),
        EXACT_TIME_100(10763L),
        NETWORK_AVAILABILITY(10814L),
        SCIENTIFIC_TEMPERATURE_IN_CELSIUS(10812L),
        SECONDARY_TIME_ZONE(10768L),
        STRING(10813L),
        TEMPERATURE_IN_CELSIUS(10783L),
        TEMPERATURE_IN_FAHRENHEIT(10784L),
        TIME_BROADCAST(10773L),
        BATTERY_LEVEL_STATE(10779L),
        BATTERY_POWER_STATE(10778L),
        PULSE_OXIMETRY_CONTINUOUS_MEASUREMENT(10847L),
        PULSE_OXIMETRY_CONTROL_POINT(10850L),
        PULSE_OXIMETRY_FEATURES(10849L),
        PULSE_OXIMETRY_PULSATILE_EVENT(10848L),
        PULSE_OXIMETRY_SPOT_CHECK_MEASUREMENT(10846L),
        RECORD_ACCESS_CONTROL_POINT_TESTVERSION(10834L),
        REMOVABLE(10810L),
        SERVICE_REQUIRED(10811L);

        private static Map<UUID, GattCharacteristic> uuidToServiceMapping;
        private UUID uuid;

        private GattCharacteristic(long key) {
            this.uuid = new UUID(key << 32 | 0x1000L, -9223371485494954757L);
        }

        private static void initMapping() {
            uuidToServiceMapping = new HashMap<UUID, GattCharacteristic>();
            GattCharacteristic[] gattCharacteristicArray = GattCharacteristic.values();
            int n = gattCharacteristicArray.length;
            int n2 = 0;
            while (n2 < n) {
                GattCharacteristic s = gattCharacteristicArray[n2];
                uuidToServiceMapping.put(s.uuid, s);
                ++n2;
            }
        }

        public static GattCharacteristic getCharacteristic(UUID uuid) {
            if (uuidToServiceMapping == null) {
                GattCharacteristic.initMapping();
            }
            return uuidToServiceMapping.get(uuid);
        }

        public UUID getUUID() {
            return this.uuid;
        }
    }
}

