/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.internal;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.smarthome.automation.module.script.ScriptEngineContainer;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;
import org.eclipse.smarthome.automation.module.script.internal.ScriptExtensionManager;

@NonNullByDefault
public class ScriptExtensionManagerWrapper {
    private ScriptEngineContainer container;
    private ScriptExtensionManager manager;

    public ScriptExtensionManagerWrapper(ScriptExtensionManager manager, ScriptEngineContainer container) {
        this.manager = manager;
        this.container = container;
    }

    public void addScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.manager.addExtension(provider);
    }

    public void removeScriptExtensionProvider(ScriptExtensionProvider provider) {
        this.manager.removeExtension(provider);
    }

    public List<String> getTypes() {
        return this.manager.getTypes();
    }

    public List<String> getPresets() {
        return this.manager.getPresets();
    }

    public Object get(String type) {
        return this.manager.get(type, this.container.getIdentifier());
    }

    public List<String> getDefaultPresets() {
        return this.manager.getDefaultPresets();
    }

    public void importPreset(String preset) {
        this.manager.importPreset(preset, this.container.getFactory(), this.container.getScriptEngine(), this.container.getIdentifier());
    }
}

