/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.shared;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.UUID;
import org.eclipse.smarthome.automation.Action;
import org.eclipse.smarthome.automation.Condition;
import org.eclipse.smarthome.automation.Rule;
import org.eclipse.smarthome.automation.Trigger;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedCustomModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedCustomModuleTypeProvider;
import org.eclipse.smarthome.automation.module.script.rulesupport.internal.ScriptedPrivateModuleHandlerFactory;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.RuleSupportRuleRegistryDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.ScriptedHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleActionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleConditionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleRuleActionHandler;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleRuleActionHandlerDelegate;
import org.eclipse.smarthome.automation.module.script.rulesupport.shared.simple.SimpleTriggerHandler;
import org.eclipse.smarthome.automation.type.ActionType;
import org.eclipse.smarthome.automation.type.ConditionType;
import org.eclipse.smarthome.automation.type.ModuleType;
import org.eclipse.smarthome.automation.type.TriggerType;
import org.eclipse.smarthome.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedAutomationManager {
    private static final Logger logger = LoggerFactory.getLogger(ScriptedAutomationManager.class);
    private RuleSupportRuleRegistryDelegate ruleRegistryDelegate;
    private HashSet<String> modules = new HashSet();
    private HashSet<String> moduleHandlers = new HashSet();
    private HashSet<String> privateHandlers = new HashSet();
    private ScriptedCustomModuleHandlerFactory scriptedCustomModuleHandlerFactory;
    private ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider;
    private ScriptedPrivateModuleHandlerFactory scriptedPrivateModuleHandlerFactory;

    public ScriptedAutomationManager(RuleSupportRuleRegistryDelegate ruleRegistryDelegate, ScriptedCustomModuleHandlerFactory scriptedCustomModuleHandlerFactory, ScriptedCustomModuleTypeProvider scriptedCustomModuleTypeProvider, ScriptedPrivateModuleHandlerFactory scriptedPrivateModuleHandlerFactory) {
        this.ruleRegistryDelegate = ruleRegistryDelegate;
        this.scriptedCustomModuleHandlerFactory = scriptedCustomModuleHandlerFactory;
        this.scriptedCustomModuleTypeProvider = scriptedCustomModuleTypeProvider;
        this.scriptedPrivateModuleHandlerFactory = scriptedPrivateModuleHandlerFactory;
    }

    public void removeModuleType(String UID) {
        if (this.modules.remove(UID)) {
            this.scriptedCustomModuleTypeProvider.removeModuleType(UID);
            this.removeHandler(UID);
        }
    }

    public void removeHandler(String typeUID) {
        if (this.moduleHandlers.remove(typeUID)) {
            this.scriptedCustomModuleHandlerFactory.removeModuleHandler(typeUID);
        }
    }

    public void removePrivateHandler(String privId) {
        if (this.privateHandlers.remove(privId)) {
            this.scriptedPrivateModuleHandlerFactory.removeHandler(privId);
        }
    }

    public void removeAll() {
        logger.info("removeAll added handlers");
        HashSet<String> types = new HashSet<String>(this.modules);
        for (String moduleType : types) {
            this.removeModuleType(moduleType);
        }
        HashSet<String> moduleHandlers = new HashSet<String>(this.moduleHandlers);
        for (String uid : moduleHandlers) {
            this.removeHandler(uid);
        }
        HashSet<String> privateHandlers = new HashSet<String>(this.privateHandlers);
        for (String privId : privateHandlers) {
            this.removePrivateHandler(privId);
        }
        this.ruleRegistryDelegate.removeAllAddedByScript();
    }

    public Rule addRule(Rule element) {
        Condition toAdd;
        Rule rule = element.getUID() == null ? new Rule(this.generateUID()) : new Rule(element.getUID());
        String name = element.getName();
        if ((name == null || name.isEmpty()) && (name = element.getClass().getSimpleName()).contains("$")) {
            name = name.substring(0, name.indexOf(36));
        }
        rule.setName(name);
        rule.setDescription(element.getDescription());
        rule.setTags(element.getTags());
        int moduleIndex = 1;
        try {
            ArrayList<Condition> conditions = new ArrayList<Condition>();
            Iterator iterator = element.getConditions().iterator();
            while (iterator.hasNext()) {
                Condition cond;
                toAdd = cond = (Condition)iterator.next();
                if (cond.getId() == null || cond.getId().isEmpty()) {
                    toAdd = new Condition(Integer.toString(moduleIndex++), cond.getTypeUID(), cond.getConfiguration(), cond.getInputs());
                }
                conditions.add(toAdd);
            }
            rule.setConditions(conditions);
        }
        catch (Exception exception) {}
        try {
            ArrayList<Condition> triggers = new ArrayList<Condition>();
            for (Trigger trigger : element.getTriggers()) {
                toAdd = trigger;
                if (trigger.getId() == null || trigger.getId().isEmpty()) {
                    toAdd = new Trigger(Integer.toString(moduleIndex++), trigger.getTypeUID(), trigger.getConfiguration());
                }
                triggers.add(toAdd);
            }
            rule.setTriggers(triggers);
        }
        catch (Exception exception) {}
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(element.getActions());
        if (element instanceof SimpleRuleActionHandler) {
            String privId = this.addPrivateActionHandler(new SimpleRuleActionHandlerDelegate((SimpleRuleActionHandler)element));
            Action scriptedAction = new Action(Integer.toString(moduleIndex++), "jsr223.ScriptedAction", new Configuration(), null);
            scriptedAction.getConfiguration().put("privId", (Object)privId);
            actions.add(scriptedAction);
        }
        rule.setActions(actions);
        this.ruleRegistryDelegate.add(rule);
        return rule;
    }

    private String generateUID() {
        return UUID.randomUUID().toString();
    }

    public void addConditionType(ConditionType condititonType) {
        this.modules.add(condititonType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)condititonType);
    }

    public void addConditionHandler(String uid, ScriptedHandler conditionHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, conditionHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateConditionHandler(SimpleConditionHandler conditionHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(conditionHandler);
        this.privateHandlers.add(uid);
        return uid;
    }

    public void addActionType(ActionType actionType) {
        this.modules.add(actionType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)actionType);
    }

    public void addActionHandler(String uid, ScriptedHandler actionHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, actionHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateActionHandler(SimpleActionHandler actionHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(actionHandler);
        this.privateHandlers.add(uid);
        return uid;
    }

    public void addTriggerType(TriggerType triggerType) {
        this.modules.add(triggerType.getUID());
        this.scriptedCustomModuleTypeProvider.addModuleType((ModuleType)triggerType);
    }

    public void addTriggerHandler(String uid, ScriptedHandler triggerHandler) {
        this.moduleHandlers.add(uid);
        this.scriptedCustomModuleHandlerFactory.addModuleHandler(uid, triggerHandler);
        this.scriptedCustomModuleTypeProvider.updateModuleHandler(uid);
    }

    public String addPrivateTriggerHandler(SimpleTriggerHandler triggerHandler) {
        String uid = this.scriptedPrivateModuleHandlerFactory.addHandler(triggerHandler);
        this.privateHandlers.add(uid);
        return uid;
    }
}

