/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.rulesupport.internal.loader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.eclipse.smarthome.automation.module.script.ScriptEngineContainer;
import org.eclipse.smarthome.automation.module.script.ScriptEngineManager;
import org.eclipse.smarthome.config.core.ConfigConstants;
import org.eclipse.smarthome.core.service.AbstractWatchService;

public class ScriptFileWatcher
extends AbstractWatchService {
    private static final String FILE_DIRECTORY = "automation" + File.separator + "jsr223";
    private static final long INITIAL_DELAY = 25L;
    private static final long RECHECK_INTERVAL = 20L;
    private long earliestStart = System.currentTimeMillis() + 25000L;
    private ScriptEngineManager manager;
    ScheduledExecutorService scheduler;
    private Map<String, Set<URL>> urlsByScriptExtension = new ConcurrentHashMap<String, Set<URL>>();
    private Set<URL> loaded = new HashSet<URL>();

    public ScriptFileWatcher() {
        super(String.valueOf(ConfigConstants.getConfigFolder()) + File.separator + FILE_DIRECTORY);
    }

    public void setScriptEngineManager(ScriptEngineManager manager) {
        this.manager = manager;
    }

    public void activate() {
        super.activate();
        this.importResources(new File(this.pathToWatch));
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleWithFixedDelay(this::checkFiles, 25L, 20L, TimeUnit.SECONDS);
    }

    public void deactivate() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
            this.scheduler = null;
        }
        super.deactivate();
    }

    private void importResources(File file) {
        block6: {
            if (!file.exists()) break block6;
            File[] files = file.listFiles();
            if (files != null) {
                File[] fileArray = files;
                int n = files.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    if (!f.isHidden()) {
                        this.importResources(f);
                    }
                    ++n2;
                }
            } else {
                try {
                    URL url = file.toURI().toURL();
                    this.importFile(url);
                }
                catch (MalformedURLException e) {
                    this.logger.debug("Can't create a URL", (Throwable)e);
                }
            }
        }
    }

    protected boolean watchSubDirectories() {
        return true;
    }

    protected WatchEvent.Kind<?>[] getWatchEventKinds(Path subDir) {
        return new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    }

    protected void processWatchEvent(WatchEvent<?> event, WatchEvent.Kind<?> kind, Path path) {
        File file = path.toFile();
        if (!file.isHidden()) {
            try {
                URL fileUrl = file.toURI().toURL();
                if (kind.equals(StandardWatchEventKinds.ENTRY_DELETE)) {
                    this.removeFile(fileUrl);
                }
                if (file.canRead() && (kind.equals(StandardWatchEventKinds.ENTRY_CREATE) || kind.equals(StandardWatchEventKinds.ENTRY_MODIFY))) {
                    this.importFile(fileUrl);
                }
            }
            catch (MalformedURLException e) {
                this.logger.error("malformed", (Throwable)e);
            }
        }
    }

    private void removeFile(URL url) {
        this.dequeueUrl(url);
        this.manager.removeEngine(this.getScriptIdentifier(url));
        this.loaded.remove(url);
    }

    private synchronized void importFile(URL url) {
        String scriptType;
        String fileName = this.getFileName(url);
        if (this.loaded.contains(url)) {
            this.removeFile(url);
        }
        if ((scriptType = this.getScriptType(url)) != null) {
            if (System.currentTimeMillis() < this.earliestStart) {
                this.enqueueUrl(url, scriptType);
            } else if (this.manager.isSupported(scriptType)) {
                try {
                    Throwable throwable = null;
                    Object var5_7 = null;
                    try (InputStreamReader reader = new InputStreamReader(new BufferedInputStream(url.openStream()));){
                        this.logger.info("Loading script '{}'", (Object)fileName);
                        ScriptEngineContainer container = this.manager.createScriptEngine(scriptType, this.getScriptIdentifier(url));
                        if (container != null) {
                            this.manager.loadScript(container.getIdentifier(), reader);
                            this.loaded.add(url);
                            this.logger.debug("Script loaded: {}", (Object)fileName);
                        } else {
                            this.logger.error("Script loading error, ignoring file: {}", (Object)fileName);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    this.logger.error("Failed to load file '{}': {}", (Object)url.getFile(), (Object)e.getMessage());
                }
            } else {
                this.enqueueUrl(url, scriptType);
                this.logger.info("ScriptEngine for {} not available", (Object)scriptType);
            }
        }
    }

    private String getFileName(URL url) {
        String parentPath;
        String fileName = url.getFile();
        if (fileName.contains(parentPath = FILE_DIRECTORY.replace('\\', '/'))) {
            fileName = fileName.substring(fileName.lastIndexOf(parentPath) + parentPath.length() + 1);
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enqueueUrl(URL url, String scriptType) {
        Map<String, Set<URL>> map = this.urlsByScriptExtension;
        synchronized (map) {
            Set<URL> set = this.urlsByScriptExtension.get(scriptType);
            if (set == null) {
                set = new HashSet<URL>();
                this.urlsByScriptExtension.put(scriptType, set);
            }
            set.add(url);
            this.logger.debug("in queue: {}", this.urlsByScriptExtension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueUrl(URL url) {
        String scriptType = this.getScriptType(url);
        if (scriptType != null) {
            Map<String, Set<URL>> map = this.urlsByScriptExtension;
            synchronized (map) {
                Set<URL> set = this.urlsByScriptExtension.get(scriptType);
                if (set != null) {
                    set.remove(url);
                    if (set.isEmpty()) {
                        this.urlsByScriptExtension.remove(scriptType);
                    }
                }
                this.logger.debug("in queue: {}", this.urlsByScriptExtension);
            }
        }
    }

    private String getScriptType(URL url) {
        String fileName = url.getPath();
        int idx = fileName.lastIndexOf(".");
        if (idx == -1) {
            return null;
        }
        String fileExtension = fileName.substring(idx + 1);
        if (fileExtension.equals("txt") || fileExtension.endsWith("~") || fileExtension.endsWith("swp")) {
            return null;
        }
        return fileExtension;
    }

    private String getScriptIdentifier(URL url) {
        return url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFiles() {
        TreeSet<URL> reimportUrls = new TreeSet<URL>(new Comparator<URL>(){

            @Override
            public int compare(URL o1, URL o2) {
                String f1 = o1.getPath();
                String f2 = o2.getPath();
                return String.CASE_INSENSITIVE_ORDER.compare(f1, f2);
            }
        });
        Map<String, Set<URL>> map = this.urlsByScriptExtension;
        synchronized (map) {
            HashSet<String> newlySupported = new HashSet<String>();
            for (String key : this.urlsByScriptExtension.keySet()) {
                if (!this.manager.isSupported(key)) continue;
                newlySupported.add(key);
            }
            for (String key : newlySupported) {
                reimportUrls.addAll((Collection<URL>)this.urlsByScriptExtension.remove(key));
            }
        }
        for (URL url : reimportUrls) {
            this.importFile(url);
        }
    }
}

