/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.smarthome.automation.module.script.defaultscope.internal;

import java.io.File;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.smarthome.automation.RuleRegistry;
import org.eclipse.smarthome.automation.module.script.ScriptExtensionProvider;
import org.eclipse.smarthome.automation.module.script.defaultscope.internal.ItemRegistryDelegate;
import org.eclipse.smarthome.automation.module.script.defaultscope.internal.ScriptBusEvent;
import org.eclipse.smarthome.core.events.EventPublisher;
import org.eclipse.smarthome.core.items.ItemRegistry;
import org.eclipse.smarthome.core.library.types.DateTimeType;
import org.eclipse.smarthome.core.library.types.DecimalType;
import org.eclipse.smarthome.core.library.types.HSBType;
import org.eclipse.smarthome.core.library.types.IncreaseDecreaseType;
import org.eclipse.smarthome.core.library.types.OnOffType;
import org.eclipse.smarthome.core.library.types.OpenClosedType;
import org.eclipse.smarthome.core.library.types.PercentType;
import org.eclipse.smarthome.core.library.types.PointType;
import org.eclipse.smarthome.core.library.types.StopMoveType;
import org.eclipse.smarthome.core.library.types.StringType;
import org.eclipse.smarthome.core.library.types.UpDownType;
import org.eclipse.smarthome.core.thing.ThingRegistry;
import org.eclipse.smarthome.core.types.Command;
import org.eclipse.smarthome.core.types.State;
import org.joda.time.DateTime;
import org.joda.time.LocalTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScriptScopeProvider
implements ScriptExtensionProvider {
    private final Logger logger = LoggerFactory.getLogger(DefaultScriptScopeProvider.class);
    private Map<String, Object> elements;
    private ItemRegistry itemRegistry;
    private ThingRegistry thingRegistry;
    private EventPublisher eventPublisher;
    private ScriptBusEvent busEvent;
    private RuleRegistry ruleRegistry;

    protected void setRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = ruleRegistry;
    }

    protected void unsetRuleRegistry(RuleRegistry ruleRegistry) {
        this.ruleRegistry = null;
    }

    protected void setThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = thingRegistry;
    }

    protected void unsetThingRegistry(ThingRegistry thingRegistry) {
        this.thingRegistry = null;
    }

    protected void setItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = itemRegistry;
    }

    protected void unsetItemRegistry(ItemRegistry itemRegistry) {
        this.itemRegistry = null;
    }

    protected void setEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = eventPublisher;
    }

    protected void unsetEventPublisher(EventPublisher eventPublisher) {
        this.eventPublisher = null;
    }

    protected void activate() {
        this.busEvent = new ScriptBusEvent(this.itemRegistry, this.eventPublisher);
        this.elements = new HashMap<String, Object>();
        this.elements.put("State", State.class);
        this.elements.put("Command", Command.class);
        try {
            this.elements.put("DateTime", DateTime.class);
            this.elements.put("LocalTime", LocalTime.class);
        }
        catch (NoClassDefFoundError e) {
            this.logger.debug("Jodatime not present, therefore no support for Date/Time in scripts");
        }
        this.elements.put("StringUtils", StringUtils.class);
        this.elements.put("URLEncoder", URLEncoder.class);
        this.elements.put("FileUtils", FileUtils.class);
        this.elements.put("FilenameUtils", FilenameUtils.class);
        this.elements.put("File", File.class);
        this.elements.put("IncreaseDecreaseType", IncreaseDecreaseType.class);
        this.elements.put("DECREASE", IncreaseDecreaseType.DECREASE);
        this.elements.put("INCREASE", IncreaseDecreaseType.INCREASE);
        this.elements.put("OnOffType", OnOffType.class);
        this.elements.put("ON", OnOffType.ON);
        this.elements.put("OFF", OnOffType.OFF);
        this.elements.put("OpenClosedType", OpenClosedType.class);
        this.elements.put("CLOSED", OpenClosedType.CLOSED);
        this.elements.put("OPEN", OpenClosedType.OPEN);
        this.elements.put("StopMoveType", StopMoveType.class);
        this.elements.put("MOVE", StopMoveType.MOVE);
        this.elements.put("STOP", StopMoveType.STOP);
        this.elements.put("UpDownType", UpDownType.class);
        this.elements.put("DOWN", UpDownType.DOWN);
        this.elements.put("UP", UpDownType.UP);
        this.elements.put("DateTimeType", DateTimeType.class);
        this.elements.put("DecimalType", DecimalType.class);
        this.elements.put("HSBType", HSBType.class);
        this.elements.put("PercentType", PercentType.class);
        this.elements.put("PointType", PointType.class);
        this.elements.put("StringType", StringType.class);
        this.elements.put("items", new ItemRegistryDelegate(this.itemRegistry));
        this.elements.put("ir", this.itemRegistry);
        this.elements.put("itemRegistry", this.itemRegistry);
        this.elements.put("things", this.thingRegistry);
        this.elements.put("events", this.busEvent);
        this.elements.put("rules", this.ruleRegistry);
    }

    protected void deactivate() {
        this.busEvent.dispose();
        this.busEvent = null;
        this.elements = null;
    }

    public Collection<String> getDefaultPresets() {
        return Collections.singleton("default");
    }

    public Collection<String> getPresets() {
        return Collections.singleton("default");
    }

    public Collection<String> getTypes() {
        return this.elements.keySet();
    }

    public Object get(String scriptIdentifier, String type) {
        return this.elements.get(type);
    }

    public Map<String, Object> importPreset(String scriptIdentifier, String preset) {
        if (preset.equals("default")) {
            return this.elements;
        }
        return null;
    }

    public void unload(String scriptIdentifier) {
    }
}

