/**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Signale;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.Enumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>ENUM Rahmen Art</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.set.toolboxmodel.Signale.SignalePackage#getENUMRahmenArt()
 * @model extendedMetaData="name='ENUMRahmen_Art'"
 * @generated
 */
public enum ENUMRahmenArt implements Enumerator {
	/**
	 * The '<em><b>ENUM Rahmen Art Bezeichnungsschild</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD(0, "ENUMRahmen_Art_Bezeichnungsschild", "Bezeichnungsschild"),

	/**
	 * The '<em><b>ENUM Rahmen Art Blechtafel</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_BLECHTAFEL_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_BLECHTAFEL(1, "ENUMRahmen_Art_Blechtafel", "Blechtafel"),

	/**
	 * The '<em><b>ENUM Rahmen Art Keramikkoerper</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_KERAMIKKOERPER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_KERAMIKKOERPER(2, "ENUMRahmen_Art_Keramikkoerper", "Keramikkoerper"),

	/**
	 * The '<em><b>ENUM Rahmen Art Schirm</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_SCHIRM_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_SCHIRM(3, "ENUMRahmen_Art_Schirm", "Schirm"),

	/**
	 * The '<em><b>ENUM Rahmen Art sonstige</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_SONSTIGE_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_SONSTIGE(4, "ENUMRahmen_Art_sonstige", "sonstige"),

	/**
	 * The '<em><b>ENUM Rahmen Art Zusatzanzeiger</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_ZUSATZANZEIGER_VALUE
	 * @generated
	 * @ordered
	 */
	ENUM_RAHMEN_ART_ZUSATZANZEIGER(5, "ENUMRahmen_Art_Zusatzanzeiger", "Zusatzanzeiger");

	/**
	 * The '<em><b>ENUM Rahmen Art Bezeichnungsschild</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD
	 * @model name="ENUMRahmen_Art_Bezeichnungsschild" literal="Bezeichnungsschild"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD_VALUE = 0;

	/**
	 * The '<em><b>ENUM Rahmen Art Blechtafel</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_BLECHTAFEL
	 * @model name="ENUMRahmen_Art_Blechtafel" literal="Blechtafel"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_BLECHTAFEL_VALUE = 1;

	/**
	 * The '<em><b>ENUM Rahmen Art Keramikkoerper</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_KERAMIKKOERPER
	 * @model name="ENUMRahmen_Art_Keramikkoerper" literal="Keramikkoerper"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_KERAMIKKOERPER_VALUE = 2;

	/**
	 * The '<em><b>ENUM Rahmen Art Schirm</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_SCHIRM
	 * @model name="ENUMRahmen_Art_Schirm" literal="Schirm"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_SCHIRM_VALUE = 3;

	/**
	 * The '<em><b>ENUM Rahmen Art sonstige</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_SONSTIGE
	 * @model name="ENUMRahmen_Art_sonstige" literal="sonstige"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_SONSTIGE_VALUE = 4;

	/**
	 * The '<em><b>ENUM Rahmen Art Zusatzanzeiger</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #ENUM_RAHMEN_ART_ZUSATZANZEIGER
	 * @model name="ENUMRahmen_Art_Zusatzanzeiger" literal="Zusatzanzeiger"
	 * @generated
	 * @ordered
	 */
	public static final int ENUM_RAHMEN_ART_ZUSATZANZEIGER_VALUE = 5;

	/**
	 * An array of all the '<em><b>ENUM Rahmen Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final ENUMRahmenArt[] VALUES_ARRAY =
		new ENUMRahmenArt[] {
			ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD,
			ENUM_RAHMEN_ART_BLECHTAFEL,
			ENUM_RAHMEN_ART_KERAMIKKOERPER,
			ENUM_RAHMEN_ART_SCHIRM,
			ENUM_RAHMEN_ART_SONSTIGE,
			ENUM_RAHMEN_ART_ZUSATZANZEIGER,
		};

	/**
	 * A public read-only list of all the '<em><b>ENUM Rahmen Art</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List<ENUMRahmenArt> VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>ENUM Rahmen Art</b></em>' literal with the specified literal value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param literal the literal.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRahmenArt get(String literal) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMRahmenArt result = VALUES_ARRAY[i];
			if (result.toString().equals(literal)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Rahmen Art</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param name the name.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRahmenArt getByName(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			ENUMRahmenArt result = VALUES_ARRAY[i];
			if (result.getName().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>ENUM Rahmen Art</b></em>' literal with the specified integer value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the integer value.
	 * @return the matching enumerator or <code>null</code>.
	 * @generated
	 */
	public static ENUMRahmenArt get(int value) {
		switch (value) {
			case ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD_VALUE: return ENUM_RAHMEN_ART_BEZEICHNUNGSSCHILD;
			case ENUM_RAHMEN_ART_BLECHTAFEL_VALUE: return ENUM_RAHMEN_ART_BLECHTAFEL;
			case ENUM_RAHMEN_ART_KERAMIKKOERPER_VALUE: return ENUM_RAHMEN_ART_KERAMIKKOERPER;
			case ENUM_RAHMEN_ART_SCHIRM_VALUE: return ENUM_RAHMEN_ART_SCHIRM;
			case ENUM_RAHMEN_ART_SONSTIGE_VALUE: return ENUM_RAHMEN_ART_SONSTIGE;
			case ENUM_RAHMEN_ART_ZUSATZANZEIGER_VALUE: return ENUM_RAHMEN_ART_ZUSATZANZEIGER;
			default: return null;
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final int value;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String name;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private final String literal;

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private ENUMRahmenArt(int value, String name, String literal) {
		this.value = value;
		this.name = name;
		this.literal = literal;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public int getValue() {
	  return value;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getName() {
	  return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String getLiteral() {
	  return literal;
	}

	/**
	 * Returns the literal value of the enumerator, which is its string representation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String toString() {
		return literal;
	}
	
} //ENUMRahmenArt
