/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sequoyah.device.framework.ui.wizard;

import java.util.ArrayList;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sequoyah.device.framework.DevicePlugin;
import org.eclipse.sequoyah.device.framework.factory.DeviceTypeRegistry;
import org.eclipse.sequoyah.device.framework.factory.InstanceRegistry;
import org.eclipse.sequoyah.device.framework.internal.model.MobileDeviceType;
import org.eclipse.sequoyah.device.framework.model.AbstractMobileInstance;
import org.eclipse.sequoyah.device.framework.model.IDeviceType;
import org.eclipse.sequoyah.device.framework.ui.DeviceUIResources;
import org.eclipse.sequoyah.device.framework.ui.wizard.NewDeviceWizard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DefaultDeviceTypeWizardPage
extends WizardPage {
    private static final String PROPERTY_ICON = "icon";
    private String instanceName = DeviceUIResources.DefaultDeviceTypeWizardPage_0;
    private MobileDeviceType currentDeviceType;
    private TreeViewer deviceTypesTreeViewer;

    protected DefaultDeviceTypeWizardPage(String string, String string2, ImageDescriptor imageDescriptor) {
        super(string, string2, imageDescriptor);
    }

    protected DefaultDeviceTypeWizardPage(String string) {
        super(string);
        this.setTitle(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_title);
        this.setMessage(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_message);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        composite2.setFont(composite.getFont());
        Label label = new Label(composite2, 0);
        label.setText(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_name);
        label.setFont(composite2.getFont());
        final Text text = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        text.setLayoutData((Object)gridData);
        text.setFont(composite2.getFont());
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyEvent) {
                InstanceRegistry instanceRegistry = InstanceRegistry.getInstance();
                String string = text.getText();
                String string2 = null;
                DefaultDeviceTypeWizardPage.this.instanceName = DeviceUIResources.DefaultDeviceTypeWizardPage_1;
                if (string != null && !string.equals("")) {
                    if (instanceRegistry.getInstancesByName(string).size() != 0) {
                        string2 = DeviceUIResources.SEQUOYAH_Emulator_Wizard_Project_Description_Duplicated_Error;
                    } else if (!AbstractMobileInstance.validName((String)string)) {
                        string2 = DeviceUIResources.SEQUOYAH_Instance_Name_Invalid_Error;
                    } else {
                        DefaultDeviceTypeWizardPage.this.instanceName = string;
                    }
                }
                DefaultDeviceTypeWizardPage.this.setErrorMessage(string2);
                DefaultDeviceTypeWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
        this.createDeviceTypesArea(composite2);
        this.setControl((Control)composite2);
    }

    public boolean isPageComplete() {
        if (this.getErrorMessage() != null) {
            return false;
        }
        return this.instanceName.trim() != "" && this.currentDeviceType != null;
    }

    private void createDeviceTypesArea(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(DeviceUIResources.SEQUOYAH_Default_Device_Type_Wizard_Page_deviceTypes);
        label.setFont(composite.getFont());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        this.deviceTypesTreeViewer = new TreeViewer(composite);
        this.deviceTypesTreeViewer.setContentProvider((IContentProvider)new DeviceTypesContentProvider());
        this.deviceTypesTreeViewer.setLabelProvider((IBaseLabelProvider)new DeviceTypesLabelProvider());
        this.deviceTypesTreeViewer.setInput((Object)this);
        this.deviceTypesTreeViewer.addFilter((ViewerFilter)new AbstractDeviceTypeViewerFilter());
        this.deviceTypesTreeViewer.expandAll();
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 2;
        this.deviceTypesTreeViewer.getControl().setLayoutData((Object)gridData);
        this.deviceTypesTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                Object object;
                ISelection iSelection = DefaultDeviceTypeWizardPage.this.deviceTypesTreeViewer.getSelection();
                if (iSelection instanceof StructuredSelection && (object = ((StructuredSelection)iSelection).getFirstElement()) instanceof MobileDeviceType) {
                    DefaultDeviceTypeWizardPage.this.currentDeviceType = (MobileDeviceType)object;
                    IWizard iWizard = DefaultDeviceTypeWizardPage.this.getWizard();
                    if (iWizard instanceof NewDeviceWizard) {
                        ((NewDeviceWizard)iWizard).setCurrentDeviceTypeId(DefaultDeviceTypeWizardPage.this.currentDeviceType.getId());
                    }
                }
                DefaultDeviceTypeWizardPage.this.getWizard().getContainer().updateButtons();
            }
        });
    }

    public String getInstanceName() {
        return this.instanceName.trim();
    }

    public MobileDeviceType getDeviceType() {
        return this.currentDeviceType;
    }

    class AbstractDeviceTypeViewerFilter
    extends ViewerFilter {
        AbstractDeviceTypeViewerFilter() {
        }

        public boolean select(Viewer viewer, Object object, Object object2) {
            return !(object2 instanceof IDeviceType) || !((IDeviceType)object2).isAbstract();
        }
    }

    class DeviceTypesContentProvider
    implements ITreeContentProvider {
        DeviceTypesContentProvider() {
        }

        public Object[] getChildren(Object object) {
            ArrayList arrayList = new ArrayList();
            if (object instanceof DefaultDeviceTypeWizardPage) {
                return DeviceTypeRegistry.getInstance().getDeviceTypes().toArray();
            }
            return arrayList.toArray();
        }

        public Object getParent(Object object) {
            return null;
        }

        public boolean hasChildren(Object object) {
            return this.getElements(object).length > 0;
        }

        public Object[] getElements(Object object) {
            return this.getChildren(object);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class DeviceTypesLabelProvider
    extends LabelProvider {
        DeviceTypesLabelProvider() {
        }

        public Image getImage(Object object) {
            MobileDeviceType mobileDeviceType;
            if (object instanceof MobileDeviceType && (mobileDeviceType = (MobileDeviceType)object).getProperties().containsKey(DefaultDeviceTypeWizardPage.PROPERTY_ICON)) {
                String string = mobileDeviceType.getProperties().getProperty(DefaultDeviceTypeWizardPage.PROPERTY_ICON);
                Image image = DevicePlugin.getDefault().getImageFromRegistry(mobileDeviceType.getBundleName(), string);
                return image;
            }
            return super.getImage(object);
        }

        public String getText(Object object) {
            if (object instanceof MobileDeviceType) {
                MobileDeviceType mobileDeviceType = (MobileDeviceType)object;
                return mobileDeviceType.getLabel();
            }
            return super.getText(object);
        }
    }
}

