/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.protocol.lib.internal.model;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.tml.common.utilities.BasePlugin;
import org.eclipse.tml.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.tml.protocol.lib.IProtocolHandshake;
import org.eclipse.tml.protocol.lib.ProtocolHandle;
import org.eclipse.tml.protocol.lib.exceptions.ProtocolHandshakeException;
import org.eclipse.tml.protocol.lib.internal.engine.ProtocolEngine;
import org.eclipse.tml.protocol.lib.internal.model.ServerProtocolEngineFactory;
import org.eclipse.tml.protocol.lib.msgdef.ProtocolMsgDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerModel {
    private static ServerModel instance;
    private Map<ProtocolHandle, ServerSocketChannel> openedSocketChannels = new HashMap<ProtocolHandle, ServerSocketChannel>();
    private Map<ProtocolHandle, ServerProtocolEngineFactory> engineFactories = new HashMap<ProtocolHandle, ServerProtocolEngineFactory>();
    private Map<ProtocolHandle, Collection<ProtocolEngine>> connectedClients = new HashMap<ProtocolHandle, Collection<ProtocolEngine>>();

    private ServerModel() {
    }

    public static ServerModel getInstance() {
        if (instance == null) {
            instance = new ServerModel();
        }
        return instance;
    }

    public ProtocolHandle startListeningToPort(int portToBind, Map<Long, ProtocolMsgDefinition> allMessages, Collection<String> incomingMessages, Collection<String> outgoingMessages, IProtocolHandshake protocolInitializer, IProtocolExceptionHandler exceptionHandler, boolean isBigEndianProtocol) {
        ProtocolHandle handle;
        block4: {
            handle = new ProtocolHandle();
            if (portToBind <= 0 || allMessages == null || incomingMessages == null || outgoingMessages == null) {
                BasePlugin.logError((String)"Invalid parameters provided to method");
                if (exceptionHandler != null) {
                    exceptionHandler.handleProtocolHandshakeException(handle, new ProtocolHandshakeException("Invalid parameters provided to method"));
                }
            }
            BasePlugin.logDebugMessage((String)"ServerModel", (String)("Creating a server socket channel to listen to connections at port " + portToBind + ". Generated handle: " + handle + "."));
            try {
                ServerSocketChannel channel = ServerSocketChannel.open();
                channel.socket().bind(new InetSocketAddress(portToBind));
                BasePlugin.logDebugMessage((String)"ServerModel", (String)"Registering needed objects at Server Model");
                ServerProtocolEngineFactory factory = new ServerProtocolEngineFactory(handle, protocolInitializer, allMessages, incomingMessages, outgoingMessages, exceptionHandler, isBigEndianProtocol);
                this.openedSocketChannels.put(handle, channel);
                this.engineFactories.put(handle, factory);
                ServerDeamon deamon = new ServerDeamon(handle, channel, factory);
                Thread deamonThread = new Thread(deamon);
                deamonThread.start();
            }
            catch (IOException e) {
                BasePlugin.logError((String)("Error opening server socket. Cause: " + e.getMessage()));
                if (exceptionHandler == null) break block4;
                exceptionHandler.handleIOException(handle, e);
            }
        }
        return handle;
    }

    public void stopListeningToPort(ProtocolHandle handle) {
        ServerSocketChannel channel = this.openedSocketChannels.get(handle);
        if (channel != null) {
            block4: {
                BasePlugin.logDebugMessage((String)"ServerModel", (String)"Closing server socket channel related to provided handle.");
                try {
                    channel.close();
                }
                catch (IOException e) {
                    IProtocolExceptionHandler excHandler;
                    BasePlugin.logError((String)("Error closing server socket. Cause: " + e.getMessage()));
                    ServerProtocolEngineFactory factory = this.engineFactories.get(handle);
                    if (factory == null || (excHandler = factory.getExceptionHandler()) == null) break block4;
                    excHandler.handleIOException(handle, e);
                }
            }
            BasePlugin.logDebugMessage((String)"ServerModel", (String)"Unregistering all objects related to provided handle from Server Model");
            Collection<ProtocolEngine> aImplCollection = this.connectedClients.get(handle);
            for (ProtocolEngine aImpl : aImplCollection) {
                aImpl.dispose();
                aImplCollection.remove(aImpl);
            }
            this.connectedClients.remove(handle);
            this.openedSocketChannels.remove(handle);
            this.engineFactories.remove(handle);
        }
    }

    public void requestRestartProtocol(ProtocolHandle handle) {
        ServerSocketChannel channel = this.openedSocketChannels.get(handle);
        if (channel != null) {
            int portToBind = channel.socket().getLocalPort();
            ServerProtocolEngineFactory factory = this.engineFactories.get(handle);
            this.stopListeningToPort(handle);
            this.startListeningToPort(portToBind, factory.getAllMessages(), factory.getIncomingMessages(), factory.getOutgoingMessages(), null, factory.getExceptionHandler(), factory.isBigEndianProtocol());
        }
    }

    public void cleanStoppedProtocols() {
        BasePlugin.logDebugMessage((String)"ServerModel", (String)"Removing all stopped protocol engines from Server Model.");
        Set<ProtocolHandle> keys = this.connectedClients.keySet();
        for (ProtocolHandle key : keys) {
            Collection<ProtocolEngine> aImplCollection = this.connectedClients.get(key);
            for (ProtocolEngine aImpl : aImplCollection) {
                if (aImpl.isConnected()) continue;
                aImpl.dispose();
                aImplCollection.remove(aImpl);
            }
        }
    }

    public boolean isListeningToPort(ProtocolHandle handle) {
        boolean isListeningToPort = false;
        ServerSocketChannel channel = this.openedSocketChannels.get(handle);
        if (channel != null) {
            isListeningToPort = channel.socket().isBound() && !channel.isOpen();
        }
        return isListeningToPort;
    }

    private class ServerDeamon
    implements Runnable {
        private ProtocolHandle handle;
        private ServerSocketChannel channel;
        private ServerProtocolEngineFactory factory;

        public ServerDeamon(ProtocolHandle handle, ServerSocketChannel channel, ServerProtocolEngineFactory factory) {
            BasePlugin.logDebugMessage((String)"ServerDeamon", (String)("Creating a server deamon to listen to connections to port " + channel.socket().getLocalPort()));
            this.handle = handle;
            this.channel = channel;
            this.factory = factory;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            block16: {
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Starting the server deamon.");
                if (this.channel == null) {
                }
                if (this.factory == null) {
                }
                break block16;
                finally {
                    BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Stopping the server deamon.");
                    try {
                        if (this.channel.isOpen()) {
                            this.channel.close();
                        }
                        BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Unregistering all objects related to provided handle from Server Model");
                        Collection allClients = (Collection)ServerModel.this.connectedClients.get(this.handle);
                        Iterator iterator = allClients.iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                ServerModel.this.openedSocketChannels.remove(this.handle);
                                ServerModel.this.engineFactories.remove(this.handle);
                                ServerModel.this.connectedClients.remove(this.handle);
                                BasePlugin.logInfo((String)"Server deamon stopped.");
                                return;
                            }
                            ProtocolEngine aClient = (ProtocolEngine)iterator.next();
                            aClient.requestStop();
                            allClients.remove(aClient);
                            aClient.dispose();
                        }
                    }
                    catch (IOException e) {
                        IProtocolExceptionHandler exceptionHandler = this.factory.getExceptionHandler();
                        if (exceptionHandler == null) return;
                        exceptionHandler.handleIOException(this.handle, e);
                    }
                }
            }
            while (true) {
                SocketChannel sc;
                try {
                    BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Listening to incoming connections.");
                    sc = this.channel.accept();
                }
                catch (IOException iOException) {
                }
                BasePlugin.logInfo((String)("A client has connected to port " + this.channel.socket().getLocalPort()));
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Creating a protocol engine to handle the protocol connection.");
                ProtocolEngine eng = this.factory.getServerProtocolEngine();
                eng.requestStart(sc, null);
                BasePlugin.logDebugMessage((String)"ServerDeamon", (String)"Registering the protocol engine at Server Model");
                HashSet<ProtocolEngine> allClients = (HashSet<ProtocolEngine>)ServerModel.this.connectedClients.get(this.handle);
                if (allClients == null) {
                    allClients = new HashSet<ProtocolEngine>();
                    ServerModel.this.connectedClients.put(this.handle, allClients);
                }
                allClients.add(eng);
            }
        }
    }
}

