/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tml.framework.device.statemachine;

import java.util.HashSet;
import java.util.Set;
import java.util.Vector;
import org.eclipse.tml.framework.status.IStatusTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateMachine {
    boolean[][] machine;
    private Vector statesVector;

    public StateMachine(Set<IStatusTransition> transitions) {
        new HashSet();
        this.statesVector = new Vector();
        for (IStatusTransition transition : transitions) {
            if (!this.statesVector.contains(transition.getStartId())) {
                this.statesVector.add(transition.getStartId());
            }
            if (!this.statesVector.contains(transition.getEndId())) {
                this.statesVector.add(transition.getEndId());
            }
            if (this.statesVector.contains(transition.getHaltId())) continue;
            this.statesVector.add(transition.getHaltId());
        }
        int size = this.statesVector.size();
        this.machine = new boolean[size][size];
        int i = 0;
        while (i < size) {
            int j = 0;
            while (j < size) {
                this.machine[i][j] = false;
                ++j;
            }
            ++i;
        }
        for (IStatusTransition transition : transitions) {
            int start = this.statesVector.indexOf(transition.getStartId());
            int end = this.statesVector.indexOf(transition.getEndId());
            int halt = this.statesVector.indexOf(transition.getHaltId());
            this.machine[start][end] = true;
            this.machine[start][halt] = true;
        }
    }

    public boolean isTransitionValid(String src, String dest) {
        int s = this.statesVector.indexOf(src);
        int d = this.statesVector.indexOf(dest);
        return this.machine[s][d];
    }
}

