/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.form.fields.composer.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.scout.commons.StringUtility;
import org.eclipse.scout.rt.client.ui.basic.tree.ITreeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.attribute.AbstractComposerAttribute;
import org.eclipse.scout.rt.client.ui.form.fields.composer.entity.AbstractComposerEntity;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.AttributeNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EitherOrNode;
import org.eclipse.scout.rt.client.ui.form.fields.composer.node.EntityNode;
import org.eclipse.scout.rt.shared.services.common.jdbc.LegacySearchFilter;

@Deprecated
public class LegacyComposerStatementBuilder {
    private final Map<String, Object> m_bindMap;
    private Map<String, LegacySearchFilter.ComposerAttributeRef> m_attributeRefMap;
    private long m_bindSeqNo = 0L;

    public LegacyComposerStatementBuilder(Map<String, Object> bindMap) {
        this.m_bindMap = bindMap;
    }

    public LegacySearchFilter.ComposerConstraint build(ITreeNode node) {
        this.m_attributeRefMap = new HashMap<String, LegacySearchFilter.ComposerAttributeRef>();
        String s = this.visitAndNodes(node.getChildNodes());
        return new LegacySearchFilter.ComposerConstraint(s, this.m_attributeRefMap);
    }

    private String visitAndNodes(ITreeNode[] nodes) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        int i = 0;
        while (i < nodes.length) {
            String s = null;
            if (nodes[i] instanceof EntityNode) {
                s = this.visitEntityNode((EntityNode)nodes[i]);
                ++i;
            } else if (nodes[i] instanceof AttributeNode) {
                s = this.visitAttributeNode((AttributeNode)nodes[i]);
                ++i;
            } else if (nodes[i] instanceof EitherOrNode) {
                int k = i;
                while (k + 1 < nodes.length && nodes[k + 1] instanceof EitherOrNode && !((EitherOrNode)nodes[k + 1]).isBeginOfEitherOr()) {
                    ++k;
                }
                EitherOrNode[] eNodes = new EitherOrNode[k - i + 1];
                System.arraycopy(nodes, i, eNodes, 0, eNodes.length);
                s = this.visitOrNodes(eNodes);
                i = k + 1;
            }
            if (s == null) continue;
            if (count > 0) {
                buf.append(" AND ");
            }
            buf.append(s);
            ++count;
        }
        if (count > 0) {
            return buf.toString();
        }
        return null;
    }

    private String visitOrNodes(EitherOrNode[] nodes) {
        StringBuilder buf = new StringBuilder();
        int count = 0;
        EitherOrNode[] eitherOrNodeArray = nodes;
        int n = nodes.length;
        int n2 = 0;
        while (n2 < n) {
            EitherOrNode node = eitherOrNodeArray[n2];
            String s = this.visitAndNodes(node.getChildNodes());
            if (s != null) {
                if (count > 0) {
                    buf.append(" OR ");
                    if (node.isNegative()) {
                        buf.append(" NOT ");
                    }
                }
                buf.append("(");
                buf.append(s);
                buf.append(")");
                ++count;
            }
            ++n2;
        }
        if (count > 0) {
            if (count > 1) {
                buf.insert(0, "(");
                buf.append(")");
                return buf.toString();
            }
            String s = buf.toString();
            if (s.matches("\\(.*\\)")) {
                return s.substring(1, s.length() - 1).trim();
            }
            return s;
        }
        return null;
    }

    private String visitEntityNode(EntityNode node) {
        String s;
        String stm = ((AbstractComposerEntity)node.getEntity()).getLegacyStatement();
        if (stm == null) {
            stm = "";
        }
        if (node.isNegative()) {
            stm = "NOT " + stm;
        }
        if ((s = this.visitAndNodes(node.getChildNodes())) != null) {
            s = " AND " + s;
        }
        if (stm.indexOf("<attributes/>") >= 0) {
            stm = StringUtility.replace((String)stm, (String)"<attributes/>", (String)s);
        } else if (stm.indexOf("#W#") >= 0) {
            stm = StringUtility.replace((String)stm, (String)"#W#", (String)s);
        } else if (s != null) {
            stm = String.valueOf(stm) + s;
        }
        if (stm.length() > 0) {
            return stm;
        }
        return null;
    }

    private String visitAttributeNode(final AttributeNode node) {
        Map<String, String> bindTranslationTable;
        String stm;
        String originalStatement = ((AbstractComposerAttribute)node.getAttribute()).getLegacyStatement();
        if (originalStatement == null) {
            originalStatement = "";
        }
        if (!(stm = this.localizeStatement(originalStatement, bindTranslationTable = this.localizeBindNames("S"))).equals(originalStatement)) {
            this.m_bindMap.put(bindTranslationTable.get("S"), node.getValues() != null && node.getValues().length > 0 ? node.getValues()[0] : null);
            return stm;
        }
        if (stm.indexOf("<attribute>") < 0) {
            stm = "<attribute>" + stm + "</attribute>";
        }
        StringUtility.ITagProcessor processor = new StringUtility.ITagProcessor(){

            public String processTag(String tagName, String attribute) {
                String key = "${attribute" + LegacyComposerStatementBuilder.this.getNextBindSeqNo() + "}";
                LegacyComposerStatementBuilder.this.m_attributeRefMap.put(key, new LegacySearchFilter.ComposerAttributeRef(node.getOp().getOperator(), attribute, (String)bindTranslationTable.get("S"), node.getValues() != null && node.getValues().length > 0 ? node.getValues()[0] : null));
                return key;
            }
        };
        return StringUtility.replaceTags((String)stm, (String)"attribute", (StringUtility.ITagProcessor)processor);
    }

    private long getNextBindSeqNo() {
        return this.m_bindSeqNo++;
    }

    private Map<String, String> localizeBindNames(String ... bindNames) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (bindNames != null) {
            String[] stringArray = bindNames;
            int n = bindNames.length;
            int n2 = 0;
            while (n2 < n) {
                String bindName = stringArray[n2];
                String locName = "__" + bindName + this.getNextBindSeqNo();
                map.put(bindName, locName);
                ++n2;
            }
        }
        return map;
    }

    private String localizeStatement(String stm, Map<String, String> bindTranslationTable) {
        for (Map.Entry<String, String> e : bindTranslationTable.entrySet()) {
            String oldName = e.getKey();
            String newName = e.getValue();
            stm = stm.replaceAll("#" + oldName + "#", "#" + newName + "#");
            stm = stm.replaceAll("\\&" + oldName + "\\&", "&" + newName + "&");
            stm = stm.replaceAll(":" + oldName + "([^A-Za-z0-9])", ":" + newName + "$1");
            stm = stm.replaceAll(":" + oldName + "$", ":" + newName);
        }
        return stm;
    }
}

