/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table.columns;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IDateColumn;
import org.eclipse.scout.rt.client.ui.form.fields.IFormField;
import org.eclipse.scout.rt.client.ui.form.fields.datefield.AbstractDateField;

public abstract class AbstractDateColumn
extends AbstractColumn<Date>
implements IDateColumn {
    private String m_format;
    private boolean m_hasTime;
    private boolean m_hasDate;
    private DateFormat m_fmt;

    @ConfigProperty(value="STRING")
    @Order(value=140.0)
    @ConfigPropertyValue(value="null")
    protected String getConfiguredFormat() {
        return null;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=150.0)
    @ConfigPropertyValue(value="true")
    protected boolean getConfiguredHasDate() {
        return true;
    }

    @ConfigProperty(value="BOOLEAN")
    @Order(value=151.0)
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredHasTime() {
        return false;
    }

    @Override
    protected void initConfig() {
        super.initConfig();
        this.setFormat(this.getConfiguredFormat());
        this.setHasDate(this.getConfiguredHasDate());
        this.setHasTime(this.getConfiguredHasTime());
    }

    @Override
    public void setFormat(String s) {
        this.m_format = s;
        this.m_fmt = null;
    }

    @Override
    public String getFormat() {
        return this.m_format;
    }

    @Override
    public void setHasDate(boolean b) {
        this.m_hasDate = b;
        this.m_fmt = null;
    }

    @Override
    public void setHasTime(boolean b) {
        this.m_hasTime = b;
        this.m_fmt = null;
    }

    @Override
    public boolean isHasDate() {
        return this.m_hasDate;
    }

    @Override
    public boolean isHasTime() {
        return this.m_hasTime;
    }

    @Override
    protected Date parseValueInternal(ITableRow row, Object rawValue) throws ProcessingException {
        if (rawValue instanceof Number) {
            rawValue = this.convertDoubleTimeToDate((Number)rawValue);
        }
        Date validValue = null;
        if (rawValue == null) {
            validValue = null;
        } else if (rawValue instanceof Date) {
            validValue = (Date)rawValue;
        } else {
            throw new ProcessingException("invalid Date value in column '" + this.getClass().getSimpleName() + "': " + rawValue + " class=" + rawValue.getClass());
        }
        return validValue;
    }

    private Date convertDoubleTimeToDate(Number d) {
        if (d == null) {
            return null;
        }
        int m = (int)((double)((long)(d.doubleValue() * 8.64E7 + 0.5)) % 8.64E7);
        Calendar c = Calendar.getInstance();
        c.clear();
        c.set(14, m % 1000);
        c.set(13, (m /= 1000) % 60);
        c.set(12, (m /= 60) % 60);
        c.set(11, (m /= 60) % 24);
        return c.getTime();
    }

    @Override
    protected IFormField prepareEditInternal(ITableRow row) throws ProcessingException {
        AbstractDateField f = new AbstractDateField(){};
        f.setFormat(this.getFormat());
        f.setHasDate(this.isHasDate());
        f.setHasTime(this.isHasTime());
        return f;
    }

    @Override
    protected void decorateCellInternal(Cell cell, ITableRow row) {
        super.decorateCellInternal(cell, row);
        if (cell.getValue() != null) {
            cell.setText(this.getDateFormat().format((Date)cell.getValue()));
        } else {
            cell.setText("");
        }
    }

    private DateFormat getDateFormat() {
        DateFormat df = null;
        if (this.getFormat() != null) {
            df = new SimpleDateFormat(this.getFormat());
        } else {
            df = this.isHasDate() && !this.isHasTime() ? DateFormat.getDateInstance(2) : (!this.isHasDate() && this.isHasTime() ? DateFormat.getTimeInstance(3) : DateFormat.getDateTimeInstance(3, 3));
            df.setLenient(true);
        }
        return df;
    }
}

