/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.table;

import java.util.ArrayList;
import java.util.TreeMap;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.rt.client.ui.ClientUIPreferences;
import org.eclipse.scout.rt.client.ui.action.keystroke.AbstractKeyStroke;
import org.eclipse.scout.rt.client.ui.basic.table.AbstractTable;
import org.eclipse.scout.rt.client.ui.basic.table.IHeaderCell;
import org.eclipse.scout.rt.client.ui.basic.table.ITable;
import org.eclipse.scout.rt.client.ui.basic.table.ITableRow;
import org.eclipse.scout.rt.client.ui.basic.table.TableRow;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractBooleanColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.AbstractStringColumn;
import org.eclipse.scout.rt.client.ui.basic.table.columns.IColumn;
import org.eclipse.scout.rt.client.ui.form.AbstractForm;
import org.eclipse.scout.rt.client.ui.form.AbstractFormHandler;
import org.eclipse.scout.rt.client.ui.form.fields.button.AbstractButton;
import org.eclipse.scout.rt.client.ui.form.fields.groupbox.AbstractGroupBox;
import org.eclipse.scout.rt.client.ui.form.fields.tablefield.AbstractTableField;
import org.eclipse.scout.rt.shared.ScoutTexts;

public class OrganizeColumnsForm
extends AbstractForm {
    ITable m_table;
    TreeMap<String, Boolean> m_origValues = new TreeMap();

    public OrganizeColumnsForm(ITable table) throws ProcessingException {
        super(false);
        this.m_table = table;
        this.callInitializer();
    }

    @Override
    protected String getConfiguredTitle() {
        return ScoutTexts.get((String)"OrganizeTableColumnsTitle", (String[])new String[0]);
    }

    @Override
    protected boolean getConfiguredModal() {
        return true;
    }

    public void startModify() throws ProcessingException {
        this.startInternal(new ModifyHandler());
    }

    public MainBox getMainBox() {
        return (MainBox)this.getRootGroupBox();
    }

    public MainBox.CloseButton getCloseButton() {
        return this.getFieldByClass(MainBox.CloseButton.class);
    }

    public MainBox.GroupBox.ColumnsTableField getColumnsTableField() {
        return this.getFieldByClass(MainBox.GroupBox.ColumnsTableField.class);
    }

    public MainBox.OkButton getOkButton() {
        return this.getFieldByClass(MainBox.OkButton.class);
    }

    public MainBox.GroupBox.ButtonsBox.SelectAllButton getSelectAllButton() {
        return this.getFieldByClass(MainBox.GroupBox.ButtonsBox.SelectAllButton.class);
    }

    public MainBox.GroupBox.ButtonsBox.SelectNoneButton getSelectNoneButton() {
        return this.getFieldByClass(MainBox.GroupBox.ButtonsBox.SelectNoneButton.class);
    }

    @Order(value=10.0)
    public class MainBox
    extends AbstractGroupBox {
        @Override
        protected int getConfiguredGridW() {
            return 1;
        }

        @Order(value=50.0)
        public class CloseButton
        extends AbstractButton {
            @Override
            protected int getConfiguredSystemType() {
                return 2;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"CloseButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"CloseButtonTooltip", (String[])new String[0]);
            }
        }

        @Order(value=10.0)
        public class GroupBox
        extends AbstractGroupBox {
            @Override
            protected int getConfiguredGridColumnCount() {
                return 2;
            }

            @Order(value=20.0)
            public class ButtonsBox
            extends AbstractGroupBox {
                @Override
                protected int getConfiguredGridColumnCount() {
                    return 1;
                }

                @Override
                protected boolean getConfiguredBorderVisible() {
                    return false;
                }

                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 4;
                }

                @Override
                protected double getConfiguredGridWeightY() {
                    return 0.0;
                }

                @Override
                protected double getConfiguredGridWeightX() {
                    return 0.0;
                }

                @Override
                protected boolean getConfiguredGridUseUiWidth() {
                    return true;
                }

                @Order(value=20.0)
                public class MoveDownButton
                extends AbstractButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"ButtonMoveDown", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredFillHorizontal() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiWidth() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return true;
                    }

                    @Override
                    protected void execClickAction() {
                        ITableRow row = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow();
                        if (row != null && row.getRowIndex() + 1 < ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getRowCount()) {
                            ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), row.getRowIndex() + 1);
                        }
                    }
                }

                @Order(value=10.0)
                public class MoveUpButton
                extends AbstractButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"ButtonMoveUp", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredFillHorizontal() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiWidth() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return true;
                    }

                    @Override
                    protected void execClickAction() {
                        ITableRow row = ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getSelectedRow();
                        if (row != null && row.getRowIndex() - 1 >= 0) {
                            ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).moveRow(row.getRowIndex(), row.getRowIndex() - 1);
                        }
                    }
                }

                @Order(value=30.0)
                public class SelectAllButton
                extends AbstractButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"ButtonSelectAll", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredFillHorizontal() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiWidth() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return true;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getCheckBoxColumn().fill(true);
                    }
                }

                @Order(value=40.0)
                public class SelectNoneButton
                extends AbstractButton {
                    @Override
                    protected String getConfiguredLabel() {
                        return ScoutTexts.get((String)"ButtonDeselectAll", (String[])new String[0]);
                    }

                    @Override
                    protected boolean getConfiguredProcessButton() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredFillHorizontal() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiWidth() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredGridUseUiHeight() {
                        return true;
                    }

                    @Override
                    protected void execClickAction() throws ProcessingException {
                        ((ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getCheckBoxColumn().fill(false);
                    }
                }
            }

            @Order(value=10.0)
            public class ColumnsTableField
            extends AbstractTableField<Table> {
                @Override
                protected int getConfiguredGridW() {
                    return 1;
                }

                @Override
                protected int getConfiguredGridH() {
                    return 8;
                }

                @Override
                protected boolean getConfiguredGridUseUiWidth() {
                    return true;
                }

                @Override
                protected String getConfiguredLabel() {
                    return ScoutTexts.get((String)"Columns", (String[])new String[0]);
                }

                @Override
                protected boolean getConfiguredLabelVisible() {
                    return false;
                }

                @Override
                protected void execReloadTableData() throws ProcessingException {
                    ArrayList<TableRow> rowList = new ArrayList<TableRow>();
                    IColumn[] iColumnArray = ((MainBox)((GroupBox)GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_table.getColumnSet().getAllColumnsInUserOrder();
                    int n = iColumnArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IColumn col = iColumnArray[n2];
                        if (col.isDisplayable() && (col.isVisible() || col.isVisibleGranted())) {
                            IHeaderCell headerCell = col.getHeaderCell();
                            TableRow row = new TableRow(((Table)this.getTable()).getColumnSet());
                            ((Table)this.getTable()).getCheckBoxColumn().setValue(row, Boolean.valueOf(col.isVisible()));
                            ((Table)this.getTable()).getKeyColumn().setValue(row, col);
                            ((Table)this.getTable()).getTextColumn().setValue(row, headerCell.getText());
                            row.setIconId(headerCell.getIconId());
                            rowList.add(row);
                        }
                        ++n2;
                    }
                    ((Table)this.getTable()).discardAllRows();
                    ((Table)this.getTable()).addRows(rowList.toArray(new ITableRow[rowList.size()]));
                    int i = 0;
                    while (i < ((Table)this.getTable()).getRowCount()) {
                        ITableRow row = ((Table)this.getTable()).getRow(i);
                        Boolean b = (Boolean)row.getCell(((Table)this.getTable()).getCheckBoxColumn()).getValue();
                        IColumn col = (IColumn)row.getCell(((Table)this.getTable()).getKeyColumn()).getValue();
                        ((MainBox)((GroupBox)GroupBox.this).MainBox.this).OrganizeColumnsForm.this.m_origValues.put(col.getClass().getName(), b);
                        ++i;
                    }
                }

                @Order(value=10.0)
                public class Table
                extends AbstractTable {
                    @Override
                    protected boolean getConfiguredAutoResizeColumns() {
                        return true;
                    }

                    @Override
                    protected boolean getConfiguredHeaderVisible() {
                        return false;
                    }

                    @Override
                    protected boolean getConfiguredMultiSelect() {
                        return false;
                    }

                    @Override
                    protected void execRowClick(ITableRow row) throws ProcessingException {
                        if (row != null && this.getContextColumn() == this.getCheckBoxColumn()) {
                            Boolean oldValue = (Boolean)this.getCheckBoxColumn().getValue(row);
                            this.getCheckBoxColumn().setValue(row, Boolean.valueOf(oldValue == false));
                        }
                    }

                    public CheckBoxColumn getCheckBoxColumn() {
                        return this.getColumnSet().getColumnByClass(CheckBoxColumn.class);
                    }

                    public KeyColumn getKeyColumn() {
                        return this.getColumnSet().getColumnByClass(KeyColumn.class);
                    }

                    public TextColumn getTextColumn() {
                        return this.getColumnSet().getColumnByClass(TextColumn.class);
                    }

                    @Order(value=20.0)
                    public class CheckBoxColumn
                    extends AbstractBooleanColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 20;
                        }
                    }

                    @Order(value=10.0)
                    public class KeyColumn
                    extends AbstractColumn<IColumn<?>> {
                        @Override
                        protected boolean getConfiguredPrimaryKey() {
                            return true;
                        }

                        @Override
                        protected boolean getConfiguredDisplayable() {
                            return false;
                        }
                    }

                    @Order(value=10.0)
                    public class SpaceKeyStroke
                    extends AbstractKeyStroke {
                        @Override
                        protected String getConfiguredKeyStroke() {
                            return "space";
                        }

                        @Override
                        protected void execAction() throws ProcessingException {
                            ITableRow[] iTableRowArray = Table.this.getSelectedRows();
                            int n = iTableRowArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                ITableRow row = iTableRowArray[n2];
                                Boolean b = (Boolean)Table.this.getCheckBoxColumn().getValue(row);
                                if (b == null) {
                                    b = false;
                                }
                                b = b == false;
                                Table.this.getCheckBoxColumn().setValue(row, b);
                                ++n2;
                            }
                        }
                    }

                    @Order(value=30.0)
                    public class TextColumn
                    extends AbstractStringColumn {
                        @Override
                        protected int getConfiguredWidth() {
                            return 180;
                        }
                    }
                }
            }
        }

        @Order(value=40.0)
        public class OkButton
        extends AbstractButton {
            @Override
            protected int getConfiguredSystemType() {
                return 3;
            }

            @Override
            protected String getConfiguredLabel() {
                return ScoutTexts.get((String)"OkButton", (String[])new String[0]);
            }

            @Override
            protected String getConfiguredTooltipText() {
                return ScoutTexts.get((String)"OkButtonTooltip", (String[])new String[0]);
            }
        }
    }

    private class ModifyHandler
    extends AbstractFormHandler {
        private ModifyHandler() {
        }

        @Override
        protected void execLoad() throws ProcessingException {
            OrganizeColumnsForm.this.getColumnsTableField().reloadTableData();
        }

        @Override
        protected void execPostLoad() throws ProcessingException {
            OrganizeColumnsForm.this.touch();
        }

        @Override
        protected void execStore() throws ProcessingException {
            IColumn[] visibleColumns = (IColumn[])((MainBox.GroupBox.ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getKeyColumn().getValues(((MainBox.GroupBox.ColumnsTableField.Table)OrganizeColumnsForm.this.getColumnsTableField().getTable()).getCheckBoxColumn().findRows(true));
            OrganizeColumnsForm.this.m_table.getColumnSet().setVisibleColumns(visibleColumns);
            ClientUIPreferences.getInstance().setAllTableColumnPreferences(OrganizeColumnsForm.this.m_table);
        }
    }
}

