/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.calendar.provider;

import java.util.Date;
import org.eclipse.scout.commons.annotations.ConfigProperty;
import org.eclipse.scout.commons.annotations.ConfigPropertyValue;
import org.eclipse.scout.commons.annotations.Order;
import org.eclipse.scout.commons.exception.ProcessingException;
import org.eclipse.scout.commons.holders.Holder;
import org.eclipse.scout.rt.client.IClientSession;
import org.eclipse.scout.rt.client.ui.basic.calendar.provider.AbstractCalendarItemProvider;
import org.eclipse.scout.rt.client.ui.basic.cell.Cell;
import org.eclipse.scout.rt.shared.services.common.calendar.HolidayItem;
import org.eclipse.scout.rt.shared.services.common.calendar.ICalendarItem;
import org.eclipse.scout.rt.shared.services.common.calendar.IHolidayCalendarService;
import org.eclipse.scout.rt.shared.services.common.file.RemoteFile;
import org.eclipse.scout.service.SERVICES;

public abstract class AbstractHolidayItemProvider
extends AbstractCalendarItemProvider {
    @Override
    @ConfigPropertyValue(value="false")
    protected boolean getConfiguredMoveItemEnabled() {
        return false;
    }

    @ConfigProperty(value="STRING")
    @ConfigPropertyValue(value="\"calendar/holidays.xml\"")
    @Order(value=100.0)
    protected String getConfiguredRemoteFile() {
        return "calendar/holidays.xml";
    }

    @Override
    protected void execLoadItemsInBackground(IClientSession session, Date minDate, Date maxDate, Holder<ICalendarItem[]> resultHolder) throws ProcessingException {
        IHolidayCalendarService service = (IHolidayCalendarService)SERVICES.getService(IHolidayCalendarService.class);
        if (service != null) {
            RemoteFile f = new RemoteFile(this.getConfiguredRemoteFile(), 0L);
            resultHolder.setValue((Object)service.getItems(f, minDate, maxDate));
        }
    }

    @Override
    protected void execDecorateCell(Cell cell, ICalendarItem item) {
        HolidayItem h = (HolidayItem)item;
        cell.setBackgroundColor(h.getColor());
    }
}

