/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.rt.client.ui.basic.activitymap;

import java.util.Date;
import java.util.TreeMap;
import org.eclipse.scout.rt.client.ui.basic.activitymap.MinorTimeColumn;
import org.eclipse.scout.rt.client.ui.basic.activitymap.TimeScale;

public class MajorTimeColumn {
    private TimeScale m_scale;
    private String m_smallText = "";
    private String m_mediumText = "";
    private String m_largeText = "";
    private String m_tooltipText;
    private TreeMap<Date, MinorTimeColumn> m_children = new TreeMap();

    public MajorTimeColumn(TimeScale scale) {
        this.m_scale = scale;
        this.m_scale.addMajorColumnNotify(this);
    }

    public TimeScale geTimeScale() {
        return this.m_scale;
    }

    public String getSmallText() {
        return this.m_smallText;
    }

    public void setSmallText(String s) {
        this.m_smallText = s;
    }

    public String getMediumText() {
        return this.m_mediumText;
    }

    public void setMediumText(String s) {
        this.m_mediumText = s;
    }

    public String getLargeText() {
        return this.m_largeText;
    }

    public void setLargeText(String s) {
        this.m_largeText = s;
    }

    public String getTooltipText() {
        return this.m_tooltipText;
    }

    public void setTooltipText(String s) {
        this.m_tooltipText = s;
    }

    public String getText(int size) {
        switch (size) {
            case 0: {
                return this.getSmallText();
            }
            case 1: {
                return this.getMediumText();
            }
            case 2: {
                return this.getLargeText();
            }
        }
        return "<UNKNOWN SIZE " + size + ">";
    }

    protected void addMinorColumnNotify(MinorTimeColumn c) {
        this.m_children.put(c.getBeginTime(), c);
        this.m_scale.addMinorColumnNotify(this, c);
    }

    public MinorTimeColumn[] getMinorTimeColumns() {
        return this.m_children.values().toArray(new MinorTimeColumn[this.m_children.size()]);
    }

    public String toString() {
        return this.toString(2);
    }

    public String toString(int size) {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append("[");
        b.append(this.getText(size));
        MinorTimeColumn[] minorTimeColumnArray = this.getMinorTimeColumns();
        int n = minorTimeColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            MinorTimeColumn c = minorTimeColumnArray[n2];
            b.append(" ");
            b.append(c.toString(size));
            ++n2;
        }
        b.append(" ]");
        return b.toString();
    }
}

